/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class BasicAbstractDataflowAnalysis<Fact>
implements DataflowAnalysis<Fact> {
    private final IdentityHashMap<BasicBlock, Fact> startFactMap = new IdentityHashMap();
    private final IdentityHashMap<BasicBlock, Fact> resultFactMap = new IdentityHashMap();

    public Iterator<Fact> resultFactIterator() {
        return this.resultFactMap.values().iterator();
    }

    @Override
    public String factToString(Fact fact) {
        return fact.toString();
    }

    @Override
    public Fact getStartFact(BasicBlock block) {
        return this.lookupOrCreateFact(this.startFactMap, block);
    }

    @Override
    public Fact getResultFact(BasicBlock block) {
        return this.lookupOrCreateFact(this.resultFactMap, block);
    }

    @Override
    public Fact getFactAtLocation(Location location) throws DataflowAnalysisException {
        return this.getStartFact(location.getBasicBlock());
    }

    @Override
    public Fact getFactAfterLocation(Location location) throws DataflowAnalysisException {
        return this.getResultFact(location.getBasicBlock());
    }

    @Override
    public Fact getFactOnEdge(Edge edge) throws DataflowAnalysisException {
        BasicBlock block = this.isForwards() ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
        Object predFact = this.createFact();
        this.copy(this.getResultFact(block), predFact);
        this.edgeTransfer(edge, predFact);
        Object result = this.createFact();
        this.makeFactTop(result);
        if (this instanceof UnconditionalValueDerefAnalysis) {
            ((UnconditionalValueDerefAnalysis)this).meetInto((UnconditionalValueDerefSet)predFact, edge, (UnconditionalValueDerefSet)result, true);
        } else {
            this.meetInto(predFact, edge, result);
        }
        return result;
    }

    @Override
    public void startIteration() {
    }

    @Override
    public void finishIteration() {
    }

    @Override
    public void edgeTransfer(Edge edge, Fact fact) throws DataflowAnalysisException {
    }

    private Fact lookupOrCreateFact(Map<BasicBlock, Fact> map, BasicBlock block) {
        Fact fact = map.get(block);
        if (fact == null) {
            fact = this.createFact();
            map.put(block, fact);
        }
        return fact;
    }

    @Override
    public int getLastUpdateTimestamp(Fact fact) {
        return 0;
    }

    @Override
    public void setLastUpdateTimestamp(Fact fact, int lastUpdateTimestamp) {
    }
}

