/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.WarningComparator;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import edu.umd.cs.findbugs.model.ClassNameRewriterUtil;
import edu.umd.cs.findbugs.model.IdentityClassNameRewriter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VersionInsensitiveBugComparator
implements WarningComparator {
    private ClassNameRewriter classNameRewriter = IdentityClassNameRewriter.instance();
    private boolean exactBugPatternMatch = true;
    private boolean comparePriorities;

    @Override
    public void setClassNameRewriter(ClassNameRewriter classNameRewriter) {
        this.classNameRewriter = classNameRewriter;
    }

    public void setComparePriorities(boolean b) {
        this.comparePriorities = b;
    }

    private boolean isBoring(BugAnnotation annotation) {
        return !(annotation instanceof LocalVariableAnnotation) && !annotation.isSignificant();
    }

    @Override
    public int compare(BugInstance lhs, BugInstance rhs) {
        BugPattern lhsPattern = lhs.getBugPattern();
        BugPattern rhsPattern = rhs.getBugPattern();
        int cmp = lhsPattern.getAbbrev().compareTo(rhsPattern.getAbbrev());
        if (cmp != 0) {
            return cmp;
        }
        if (this.isExactBugPatternMatch() && (cmp = lhsPattern.getType().compareTo(rhsPattern.getType())) != 0) {
            return cmp;
        }
        if (this.comparePriorities && (cmp = lhs.getPriority() - rhs.getPriority()) != 0) {
            return cmp;
        }
        FilteringAnnotationIterator lhsIter = new FilteringAnnotationIterator(lhs.annotationIterator());
        FilteringAnnotationIterator rhsIter = new FilteringAnnotationIterator(rhs.annotationIterator());
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            Class<?> rhsClass;
            Class<?> lhsClass;
            BugAnnotation lhsAnnotation = (BugAnnotation)lhsIter.next();
            BugAnnotation rhsAnnotation = (BugAnnotation)rhsIter.next();
            while ((lhsClass = lhsAnnotation.getClass()) != (rhsClass = rhsAnnotation.getClass())) {
                if (lhsClass == LocalVariableAnnotation.class && !((LocalVariableAnnotation)lhsAnnotation).isSignificant() && lhsIter.hasNext()) {
                    lhsAnnotation = (BugAnnotation)lhsIter.next();
                    continue;
                }
                if (rhsClass == LocalVariableAnnotation.class && !((LocalVariableAnnotation)rhsAnnotation).isSignificant() && rhsIter.hasNext()) {
                    rhsAnnotation = (BugAnnotation)rhsIter.next();
                    continue;
                }
                return lhsClass.getName().compareTo(rhsClass.getName());
            }
            if (lhsClass == ClassAnnotation.class) {
                String lhsClassName = this.classNameRewriter.rewriteClassName(((ClassAnnotation)lhsAnnotation).getClassName());
                String rhsClassName = this.classNameRewriter.rewriteClassName(((ClassAnnotation)rhsAnnotation).getClassName());
                cmp = lhsClassName.compareTo(rhsClassName);
            } else if (lhsClass == MethodAnnotation.class) {
                MethodAnnotation lhsMethod = ClassNameRewriterUtil.convertMethodAnnotation(this.classNameRewriter, (MethodAnnotation)lhsAnnotation);
                MethodAnnotation rhsMethod = ClassNameRewriterUtil.convertMethodAnnotation(this.classNameRewriter, (MethodAnnotation)rhsAnnotation);
                cmp = lhsMethod.compareTo(rhsMethod);
            } else if (lhsClass == FieldAnnotation.class) {
                FieldAnnotation lhsField = ClassNameRewriterUtil.convertFieldAnnotation(this.classNameRewriter, (FieldAnnotation)lhsAnnotation);
                FieldAnnotation rhsField = ClassNameRewriterUtil.convertFieldAnnotation(this.classNameRewriter, (FieldAnnotation)rhsAnnotation);
                cmp = lhsField.compareTo(rhsField);
            } else if (lhsClass == StringAnnotation.class) {
                String lhsString = ((StringAnnotation)lhsAnnotation).getValue();
                String rhsString = ((StringAnnotation)rhsAnnotation).getValue();
                cmp = lhsString.compareTo(rhsString);
            } else if (lhsClass == LocalVariableAnnotation.class) {
                String lhsName = ((LocalVariableAnnotation)lhsAnnotation).getName();
                String rhsName = ((LocalVariableAnnotation)rhsAnnotation).getName();
                if (lhsName.equals("?") || rhsName.equals("?")) continue;
                cmp = lhsName.compareTo(rhsName);
            } else if (lhsClass == TypeAnnotation.class) {
                String lhsType = ((TypeAnnotation)lhsAnnotation).getTypeDescriptor();
                String rhsType = ((TypeAnnotation)rhsAnnotation).getTypeDescriptor();
                lhsType = ClassNameRewriterUtil.rewriteSignature(this.classNameRewriter, lhsType);
                rhsType = ClassNameRewriterUtil.rewriteSignature(this.classNameRewriter, rhsType);
                cmp = lhsType.compareTo(rhsType);
            } else if (lhsClass == IntAnnotation.class) {
                int lhsValue = ((IntAnnotation)lhsAnnotation).getValue();
                int rhsValue = ((IntAnnotation)rhsAnnotation).getValue();
                cmp = lhsValue - rhsValue;
            } else {
                if (this.isBoring(lhsAnnotation)) {
                    throw new IllegalStateException("Impossible");
                }
                throw new IllegalStateException("Unknown annotation type: " + lhsClass.getName());
            }
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.interestingNext(rhsIter)) {
            return -1;
        }
        if (this.interestingNext(lhsIter)) {
            return 1;
        }
        return 0;
    }

    private boolean interestingNext(Iterator<BugAnnotation> i) {
        while (i.hasNext()) {
            BugAnnotation a = i.next();
            if (this.isBoring(a)) continue;
            if (!(a instanceof LocalVariableAnnotation)) {
                return true;
            }
            if (!((LocalVariableAnnotation)a).isSignificant()) continue;
            return true;
        }
        return false;
    }

    public void setExactBugPatternMatch(boolean exactBugPatternMatch) {
        this.exactBugPatternMatch = exactBugPatternMatch;
    }

    public boolean isExactBugPatternMatch() {
        return this.exactBugPatternMatch;
    }

    private class FilteringAnnotationIterator
    implements Iterator<BugAnnotation> {
        private final Iterator<BugAnnotation> iter;
        private BugAnnotation next;

        public FilteringAnnotationIterator(Iterator<BugAnnotation> iter) {
            this.iter = iter;
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public BugAnnotation next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            BugAnnotation result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.next == null && this.iter.hasNext()) {
                BugAnnotation candidate = this.iter.next();
                if (VersionInsensitiveBugComparator.this.isBoring(candidate)) continue;
                this.next = candidate;
                break;
            }
        }
    }
}

