/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Asserts;
import com.yourkit.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtil {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public static void sort(int[] a, MyComparator c) {
        ArrayUtil.sort(a, 0, a.length, c);
    }

    public static void sort(int[] a, int beginIndex, int endIndex, MyComparator c) {
        if (beginIndex < 0) {
            Asserts.fail();
        }
        if (beginIndex > endIndex) {
            Asserts.fail();
        }
        if (endIndex > a.length) {
            Asserts.fail();
        }
        int[] aux = (int[])a.clone();
        ArrayUtil.mergeSort(aux, a, beginIndex, endIndex, 0, c);
    }

    private static void mergeSort(int[] src, int[] dest, int low, int high, int off, MyComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    ArrayUtil.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        ArrayUtil.mergeSort(dest, src, low, mid, -off, c);
        ArrayUtil.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static char[] createCharArray(int size) {
        if (size < 0) {
            Asserts.fail();
        }
        return size == 0 ? EMPTY_CHAR_ARRAY : new char[size];
    }

    public static int[] createIntArray(int size) {
        if (size < 0) {
            Asserts.fail();
        }
        return size == 0 ? EMPTY_INT_ARRAY : new int[size];
    }

    public static long[] createLongArray(int size) {
        if (size < 0) {
            Asserts.fail();
        }
        return size == 0 ? EMPTY_LONG_ARRAY : new long[size];
    }

    public static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static boolean equals(@NotNull byte[] a, @NotNull byte[] b, int elementsToCompare) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (a.length < elementsToCompare) {
            Asserts.fail();
        }
        if (b.length < elementsToCompare) {
            Asserts.fail();
        }
        for (int i = 0; i < elementsToCompare; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T> T[] filterNulls(T ... arrayWithNulls) {
        if (arrayWithNulls == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : arrayWithNulls) {
            if (element == null) continue;
            result.add(element);
        }
        T[] resultArray = Arrays.copyOf(arrayWithNulls, result.size());
        for (int i = 0; i < resultArray.length; ++i) {
            resultArray[i] = result.get(i);
        }
        if (resultArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return resultArray;
    }

    public static int linearSearch(@NotNull int[] a, int key) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != key) continue;
            return i;
        }
        return -1;
    }

    public static int linearSearch0(@Nullable int[] a, int key) {
        return a != null ? ArrayUtil.linearSearch(a, key) : -1;
    }

    public static int linearSearch(@NotNull long[] a, long key) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != key) continue;
            return i;
        }
        return -1;
    }

    public static int linearSearch(@NotNull byte[] a, byte key) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != key) continue;
            return i;
        }
        return -1;
    }

    public static <T> int linearSearch(@NotNull T[] a, @Nullable T key) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < a.length; ++i) {
            if (!Util.equalsNullable(a[i], key)) continue;
            return i;
        }
        return -1;
    }

    public static Object wrapWithEqualable(long[] array) {
        return new MyArrayWrapper(array);
    }

    public static String[] getMapKeysSorted(HashMap<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        return keys.toArray(new String[keys.size()]);
    }

    public static String[] getMapKeyAndValuePairsSorted(HashMap<String, String> map, char splitCharacter) {
        String[] keysSorted = ArrayUtil.getMapKeysSorted(map);
        String[] result = new String[keysSorted.length];
        for (int i = 0; i < keysSorted.length; ++i) {
            String key = keysSorted[i];
            result[i] = key + splitCharacter + map.get(key);
        }
        return result;
    }

    private static final class MyArrayWrapper {
        private final long[] myArray;
        private int myHashCode;

        public MyArrayWrapper(long[] array) {
            this.myArray = array;
        }

        public boolean equals(Object second) {
            return second instanceof MyArrayWrapper && Arrays.equals(this.myArray, ((MyArrayWrapper)second).myArray);
        }

        public int hashCode() {
            int h = this.myHashCode;
            if (h == 0) {
                for (long v : this.myArray) {
                    h = 31 * h + (int)(v ^ v >>> 32);
                }
                if (h == 0) {
                    h = 1;
                }
                this.myHashCode = h;
            }
            return h;
        }
    }

    public static interface MyComparator {
        public int compare(int var1, int var2);
    }
}

