/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InitializationChain
extends BytecodeScanningDetector {
    Set<String> requires = new TreeSet<String>();
    Map<String, Set<String>> classRequires = new TreeMap<String, Set<String>>();
    private final BugReporter bugReporter;
    private final Map<XMethod, Set<XField>> staticFieldsRead = new HashMap<XMethod, Set<XField>>();
    private final Set<XField> staticFieldsReadInAnyConstructor = new HashSet<XField>();
    private Set<XField> fieldsReadInThisConstructor = new HashSet<XField>();
    private final Set<XMethod> constructorsInvokedInStaticInitializer = new HashSet<XMethod>();
    private final List<InvocationInfo> invocationInfo = new ArrayList<InvocationInfo>();
    private final Set<XField> warningGiven = new HashSet<XField>();
    private InvocationInfo lastInvocation;
    private static final boolean DEBUG = SystemProperties.getBoolean("ic.debug");

    public InitializationChain(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    protected Iterable<Method> getMethodVisitOrder(JavaClass obj) {
        ArrayList<Method> visitOrder = new ArrayList<Method>();
        Method staticInitializer = null;
        for (Method m : obj.getMethods()) {
            String name = m.getName();
            if (name.equals("<clinit>")) {
                staticInitializer = m;
                continue;
            }
            if (!name.equals("<init>")) continue;
            visitOrder.add(m);
        }
        if (staticInitializer != null) {
            visitOrder.add(staticInitializer);
        }
        return visitOrder;
    }

    @Override
    public void visit(Code obj) {
        this.fieldsReadInThisConstructor = new HashSet<XField>();
        super.visit(obj);
        this.staticFieldsRead.put(this.getXMethod(), this.fieldsReadInThisConstructor);
        this.requires.remove(this.getDottedClassName());
        if (this.getDottedClassName().equals("java.lang.System")) {
            this.requires.add("java.io.FileInputStream");
            this.requires.add("java.io.FileOutputStream");
            this.requires.add("java.io.BufferedInputStream");
            this.requires.add("java.io.BufferedOutputStream");
            this.requires.add("java.io.PrintStream");
        }
        if (!this.requires.isEmpty()) {
            this.classRequires.put(this.getDottedClassName(), this.requires);
            this.requires = new TreeSet<String>();
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.staticFieldsRead.clear();
        this.staticFieldsReadInAnyConstructor.clear();
        this.fieldsReadInThisConstructor.clear();
        this.constructorsInvokedInStaticInitializer.clear();
        this.invocationInfo.clear();
        this.lastInvocation = null;
    }

    @Override
    public void sawOpcode(int seen) {
        InvocationInfo prev = this.lastInvocation;
        this.lastInvocation = null;
        if (this.getMethodName().equals("<init>")) {
            if (seen == 178 && this.getClassConstantOperand().equals(this.getClassName())) {
                this.staticFieldsReadInAnyConstructor.add(this.getXFieldOperand());
                this.fieldsReadInThisConstructor.add(this.getXFieldOperand());
            }
            return;
        }
        if (seen == 183 && this.getNameConstantOperand().equals("<init>") && this.getClassConstantOperand().equals(this.getClassName())) {
            XMethod m = this.getXMethodOperand();
            Set<XField> read = this.staticFieldsRead.get(m);
            if (this.constructorsInvokedInStaticInitializer.add(m) && read != null && !read.isEmpty()) {
                this.lastInvocation = new InvocationInfo(m, this.getPC());
                this.invocationInfo.add(this.lastInvocation);
            }
        }
        if (seen == 179 && this.getClassConstantOperand().equals(this.getClassName())) {
            XField f = this.getXFieldOperand();
            if (prev != null) {
                prev.field = f;
            }
            if (this.staticFieldsReadInAnyConstructor.contains(f) && !this.warningGiven.contains(f)) {
                for (InvocationInfo i : this.invocationInfo) {
                    Set<XField> fields = this.staticFieldsRead.get(i.constructor);
                    if (fields == null || !fields.contains(f)) continue;
                    this.warningGiven.add(f);
                    BugInstance bug = new BugInstance(this, "SI_INSTANCE_BEFORE_FINALS_ASSIGNED", 2).addClassAndMethod(this);
                    if (i.field != null) {
                        bug.addField(i.field).describe("FIELD_STORED");
                    }
                    bug.addMethod(i.constructor).describe("METHOD_CONSTRUCTOR");
                    bug.addReferencedField(this).describe("FIELD_VALUE_OF").addSourceLine(this, i.pc);
                    this.bugReporter.reportBug(bug);
                    break;
                }
            }
        } else if ((seen == 179 || seen == 178 || seen == 184 || seen == 187) && this.getPC() + 6 < this.codeBytes.length) {
            this.requires.add(this.getDottedClassConstantOperand());
        }
    }

    public void compute() {
        Set<String> allClasses = this.classRequires.keySet();
        TreeSet<String> emptyClasses = new TreeSet<String>();
        for (String c : allClasses) {
            Set<String> needs = this.classRequires.get(c);
            needs.retainAll(allClasses);
            TreeSet extra = new TreeSet();
            for (String need : needs) {
                extra.addAll(this.classRequires.get(need));
            }
            needs.addAll(extra);
            needs.retainAll(allClasses);
            this.classRequires.put(c, needs);
            if (!needs.isEmpty()) continue;
            emptyClasses.add(c);
        }
        for (String c : emptyClasses) {
            this.classRequires.remove(c);
        }
    }

    @Override
    public void report() {
        if (DEBUG) {
            System.out.println("Finishing computation");
        }
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        Set<String> allClasses = this.classRequires.keySet();
        for (String c : allClasses) {
            if (DEBUG) {
                System.out.println("Class " + c + " requires:");
            }
            for (String needs : this.classRequires.get(c)) {
                Set<String> s;
                if (DEBUG) {
                    System.out.println("  " + needs);
                }
                if ((s = this.classRequires.get(needs)) == null || !s.contains(c) || c.compareTo(needs) >= 0) continue;
                this.bugReporter.reportBug(new BugInstance(this, "IC_INIT_CIRCULARITY", 2).addClass(c).addClass(needs));
            }
        }
    }

    static class InvocationInfo {
        XMethod constructor;
        int pc;
        XField field;

        public InvocationInfo(XMethod constructor, int pc) {
            this.constructor = constructor;
            this.pc = pc;
        }
    }
}

