/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamFactory;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ObjectType;

public class IOStreamFactory
implements StreamFactory {
    private final ObjectType baseClassType;
    private final ObjectType[] uninterestingSubclassTypeList;
    private final String bugType;

    public String toString() {
        return "IOStreamFactory(" + this.baseClassType + ")";
    }

    public IOStreamFactory(String baseClass, String[] uninterestingSubclassList, String bugType) {
        this.baseClassType = ObjectTypeFactory.getInstance(baseClass);
        this.uninterestingSubclassTypeList = new ObjectType[uninterestingSubclassList.length];
        for (int i = 0; i < uninterestingSubclassList.length; ++i) {
            this.uninterestingSubclassTypeList[i] = ObjectTypeFactory.getInstance(uninterestingSubclassList[i]);
        }
        this.bugType = bugType;
    }

    @Override
    public Stream createStream(Location location, ObjectType type, ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
        try {
            Instruction ins = location.getHandle().getInstruction();
            if (ins.getOpcode() != 187) {
                return null;
            }
            if (Hierarchy.isSubtype(type, this.baseClassType)) {
                boolean isUninteresting = false;
                for (ObjectType aUninterestingSubclassTypeList : this.uninterestingSubclassTypeList) {
                    if (!Hierarchy.isSubtype(type, aUninterestingSubclassTypeList)) continue;
                    isUninteresting = true;
                    break;
                }
                Stream result = new Stream(location, type.getClassName(), this.baseClassType.getClassName()).setIgnoreImplicitExceptions(true);
                if (!isUninteresting) {
                    result.setInteresting(this.bugType);
                }
                return result;
            }
        }
        catch (ClassNotFoundException e) {
            lookupFailureCallback.reportMissingClass(e);
        }
        return null;
    }
}

