/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Method;

public class FindUnconditionalWait
extends BytecodeScanningDetector
implements StatelessDetector {
    int stage = 0;
    private final BugReporter bugReporter;

    public FindUnconditionalWait(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        this.stage = 0;
    }

    @Override
    public void sawBranchTo(int target) {
        if (this.stage == 1) {
            this.stage = 0;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (this.stage) {
            case 0: {
                if (seen != 194) break;
                this.stage = 1;
                break;
            }
            case 1: {
                if (seen != 182 || !this.getNameConstantOperand().equals("wait")) break;
                this.bugReporter.reportBug(new BugInstance(this, "UW_UNCOND_WAIT", this.getSigConstantOperand().equals("()V") ? 2 : 3).addClassAndMethod(this).addSourceLine(this));
                this.stage = 2;
                break;
            }
        }
    }
}

