/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;

public class FindRoughConstants
extends OpcodeStackDetector {
    private static final BadConstant[] badConstants = new BadConstant[]{new BadConstant(Math.PI, 1.0, "Math.PI"), new BadConstant(Math.PI, 0.5, "Math.PI/2"), new BadConstant(Math.PI, 0.3333333333333333, "Math.PI/3"), new BadConstant(Math.PI, 0.25, "Math.PI/4"), new BadConstant(Math.PI, 2.0, "2*Math.PI"), new BadConstant(Math.E, 1.0, "Math.E")};
    private final BugReporter bugReporter;

    public FindRoughConstants(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 18 || seen == 19 || seen == 20) {
            Constant c = this.getConstantRefOperand();
            if (c instanceof ConstantFloat) {
                this.checkConst(Float.valueOf(((ConstantFloat)c).getBytes()));
            } else if (c instanceof ConstantDouble) {
                this.checkConst(((ConstantDouble)c).getBytes());
            }
        }
    }

    private void checkConst(Number constValue) {
        double candidate = constValue.doubleValue();
        if (Double.isNaN(candidate) || Double.isInfinite(candidate)) {
            return;
        }
        for (BadConstant badConstant : badConstants) {
            double diff;
            if (badConstant.exact(constValue) || (diff = badConstant.diff(candidate)) > 1.0E-4) continue;
            if (badConstant.equalPrefix(constValue)) {
                this.bugReporter.reportBug(new BugInstance(this, "CNT_ROUGH_CONSTANT_VALUE", 2).addClassAndMethod(this).addSourceLine(this).addString(constValue.toString()).addString(badConstant.replacement));
                return;
            }
            if (diff > 1.0E-7) continue;
            this.bugReporter.reportBug(new BugInstance(this, "CNT_ROUGH_CONSTANT_VALUE", 3).addClassAndMethod(this).addSourceLine(this).addString(constValue.toString()).addString(badConstant.replacement));
        }
    }

    static class BadConstant {
        double base;
        double factor;
        String replacement;
        double value;
        Set<Number> approxSet = new HashSet<Number>();

        BadConstant(double base, double factor, String replacement) {
            this.base = base;
            this.factor = factor;
            this.value = this.base * this.factor;
            this.replacement = replacement;
            BigDecimal valueBig = BigDecimal.valueOf(this.value);
            BigDecimal baseBig = BigDecimal.valueOf(base);
            BigDecimal factorBig = BigDecimal.valueOf(factor);
            for (int prec = 0; prec < 14; ++prec) {
                this.addApprox(baseBig.round(new MathContext(prec, RoundingMode.FLOOR)).multiply(factorBig));
                this.addApprox(baseBig.round(new MathContext(prec, RoundingMode.CEILING)).multiply(factorBig));
                this.addApprox(valueBig.round(new MathContext(prec, RoundingMode.FLOOR)));
                this.addApprox(valueBig.round(new MathContext(prec, RoundingMode.CEILING)));
            }
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        public boolean exact(Number candidate) {
            if (candidate instanceof Double) {
                return candidate.doubleValue() == this.value;
            }
            return candidate.floatValue() == (float)this.value;
        }

        public double diff(double candidate) {
            return Math.abs(this.value - candidate) / this.value;
        }

        public boolean equalPrefix(Number candidate) {
            return this.approxSet.contains(candidate);
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        private void addApprox(BigDecimal roundFloor) {
            float approxFloat;
            double approxDouble = roundFloor.doubleValue();
            if (approxDouble != this.value && Math.abs(approxDouble - this.value) / this.value < 1.0E-4) {
                this.approxSet.add(approxDouble);
            }
            if (Math.abs((double)(approxFloat = roundFloor.floatValue()) - this.value) / this.value < 1.0E-4) {
                this.approxSet.add(Float.valueOf(approxFloat));
                this.approxSet.add(approxFloat);
            }
        }
    }
}

