/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public final class FindJSR166LockMonitorenter
implements Detector,
StatelessDetector {
    private static final String UTIL_CONCURRRENT_SIG_PREFIX = "Ljava/util/concurrent/";
    private final BugReporter bugReporter;
    private static final ObjectType LOCK_TYPE = ObjectTypeFactory.getInstance("java.util.concurrent.locks.Lock");

    public FindJSR166LockMonitorenter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass jclass = classContext.getJavaClass();
        if (jclass.getClassName().startsWith("java.util.concurrent.")) {
            return;
        }
        for (Method method : methodList = jclass.getMethods()) {
            BitSet bytecodeSet;
            if (method.getCode() == null || (bytecodeSet = classContext.getBytecodeSet(method)) == null) continue;
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        TypeDataflow typeDataflow;
        CFG cfg;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        try {
            cfg = classContext.getCFG(method);
        }
        catch (CFGBuilderException e1) {
            AnalysisContext.logError("Coult not get CFG", e1);
            return;
        }
        try {
            typeDataflow = classContext.getTypeDataflow(method);
        }
        catch (CheckedAnalysisException e1) {
            AnalysisContext.logError("Coult not get Type dataflow", e1);
            return;
        }
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Type type;
            Instruction ins;
            Location location;
            block22: {
                location = i.next();
                InstructionHandle handle = location.getHandle();
                ins = handle.getInstruction();
                if (ins.getOpcode() == 182) {
                    INVOKEVIRTUAL iv = (INVOKEVIRTUAL)ins;
                    String methodName = iv.getMethodName(cpg);
                    String methodSig = iv.getSignature(cpg);
                    if (methodName.equals("wait") && (methodSig.equals("()V") || methodSig.equals("(J)V") || methodSig.equals("(JI)V")) || (methodName.equals("notify") || methodName.equals("notifyAll")) && methodSig.equals("()V")) {
                        try {
                            XMethod m;
                            ClassDescriptor classDescriptor;
                            Type type2;
                            TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                            if (!frame.isValid() || !((type2 = (Type)frame.getInstance(ins, cpg)) instanceof ReferenceType) || (classDescriptor = DescriptorFactory.createClassDescriptorFromSignature(type2.getSignature())).equals(classContext.getClassDescriptor()) || !classDescriptor.getClassName().startsWith("java/util/concurrent")) continue;
                            XClass c = Lookup.getXClass(classDescriptor);
                            int priority = 2;
                            if (methodName.equals("wait")) {
                                m = c.findMethod("await", "()V", false);
                                priority = 1;
                            } else if (methodName.equals("notify")) {
                                m = c.findMethod("signal", "()V", false);
                                if (m == null) {
                                    m = c.findMethod("countDown", "()V", false);
                                }
                            } else if (methodName.equals("notifyAll")) {
                                m = c.findMethod("signalAll", "()V", false);
                                if (m == null) {
                                    m = c.findMethod("countDown", "()V", false);
                                }
                            } else {
                                throw new IllegalStateException("Unexpected methodName: " + methodName);
                            }
                            if (m == null || !m.isPublic() || !c.isPublic()) break block22;
                            this.bugReporter.reportBug(new BugInstance(this, "JML_JSR166_CALLING_WAIT_RATHER_THAN_AWAIT", priority).addClassAndMethod(classContext.getJavaClass(), method).addCalledMethod(cpg, (InvokeInstruction)iv).addMethod(m).describe("METHOD_ALTERNATIVE_TARGET").addType(classDescriptor).describe("TYPE_FOUND").addSourceLine(classContext, method, location));
                        }
                        catch (CheckedAnalysisException e) {
                            AnalysisContext.logError("Coult not get Type dataflow", e);
                            continue;
                        }
                    }
                }
            }
            if (ins.getOpcode() != 194) continue;
            try {
                TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                if (!frame.isValid()) continue;
                type = (Type)frame.getInstance(ins, cpg);
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Coult not get Type dataflow", e);
                continue;
            }
            if (!(type instanceof ReferenceType)) continue;
            boolean isSubtype = false;
            try {
                isSubtype = Hierarchy.isSubtype((ReferenceType)type, LOCK_TYPE);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
            String sig = type.getSignature();
            boolean isUtilConcurrentSig = sig.startsWith(UTIL_CONCURRRENT_SIG_PREFIX);
            if (isSubtype) {
                this.bugReporter.reportBug(new BugInstance(this, "JLM_JSR166_LOCK_MONITORENTER", isUtilConcurrentSig ? 1 : 2).addClassAndMethod(classContext.getJavaClass(), method).addType(sig).addSourceForTopStackValue(classContext, method, location).addSourceLine(classContext, method, location));
                continue;
            }
            if (!isUtilConcurrentSig) continue;
            int priority = "Ljava/util/concurrent/CopyOnWriteArrayList;".equals(sig) ? 1 : 2;
            this.bugReporter.reportBug(new BugInstance(this, "JLM_JSR166_UTILCONCURRENT_MONITORENTER", priority).addClassAndMethod(classContext.getJavaClass(), method).addType(sig).addSourceForTopStackValue(classContext, method, location).addSourceLine(classContext, method, location));
        }
    }

    @Override
    public void report() {
    }
}

