/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CallGraph;
import edu.umd.cs.findbugs.CallGraphEdge;
import edu.umd.cs.findbugs.CallGraphNode;
import edu.umd.cs.findbugs.CallSite;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SelfCalls;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AccessibleEntity;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockChecker;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.InconsistentSyncWarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class FindInconsistentSync2
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean("fis.debug");
    private static final boolean SYNC_ACCESS = true;
    private static final boolean ADJUST_SUBCLASS_ACCESSES = !SystemProperties.getBoolean("fis.noAdjustSubclass");
    private static final boolean EVAL = SystemProperties.getBoolean("fis.eval");
    private static final int MIN_SYNC_PERCENT = SystemProperties.getInt("findbugs.fis.minSyncPercent", 50);
    private static final double WRITE_BIAS = Double.parseDouble(SystemProperties.getProperty("findbugs.fis.writeBias", "2.0"));
    private static final double UNSYNC_FACTOR = Double.parseDouble(SystemProperties.getProperty("findbugs.fis.unsyncFactor", "1.6"));
    private static final int UNLOCKED = 0;
    private static final int LOCKED = 1;
    private static final int READ = 0;
    private static final int WRITE = 2;
    private static final int NULLCHECK = 4;
    private static final int READ_UNLOCKED = 0;
    private static final int WRITE_UNLOCKED = 2;
    private static final int NULLCHECK_UNLOCKED = 4;
    private static final int READ_LOCKED = 1;
    private static final int WRITE_LOCKED = 3;
    private static final int NULLCHECK_LOCKED = 5;
    private static ClassDescriptor servlet = DescriptorFactory.createClassDescriptor("javax/servlet/GenericServlet");
    private static ClassDescriptor singleThreadedServlet = DescriptorFactory.createClassDescriptor("javax/servlet/SingleThreadModel");
    private final BugReporter bugReporter;
    private final Map<XField, FieldStats> statMap = new HashMap<XField, FieldStats>();

    public static boolean isServletField(XField field) {
        ClassDescriptor classDescriptor = field.getClassDescriptor();
        try {
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            if (subtypes2.isSubtype(classDescriptor, servlet) && !subtypes2.isSubtype(classDescriptor, singleThreadedServlet)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return classDescriptor.getClassName().endsWith("Servlet");
    }

    public FindInconsistentSync2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Set<Method> lockedMethodSet;
        JavaClass javaClass = classContext.getJavaClass();
        if (DEBUG) {
            System.out.println("******** Analyzing class " + javaClass.getClassName());
        }
        SelfCalls selfCalls = new SelfCalls(classContext){

            @Override
            public boolean wantCallsFor(Method method) {
                return !method.isPublic();
            }
        };
        HashSet<Method> allMethods = new HashSet<Method>(Arrays.asList(javaClass.getMethods()));
        try {
            selfCalls.execute();
            CallGraph callGraph = selfCalls.getCallGraph();
            if (DEBUG) {
                System.out.println("Call graph (not unlocked methods): " + callGraph.getNumVertices() + " nodes, " + callGraph.getNumEdges() + " edges");
            }
            Set<CallSite> obviouslyLockedSites = FindInconsistentSync2.findObviouslyLockedCallSites(classContext, selfCalls);
            lockedMethodSet = FindInconsistentSync2.findNotUnlockedMethods(classContext, selfCalls, obviouslyLockedSites);
            lockedMethodSet.retainAll(FindInconsistentSync2.findLockedMethods(classContext, selfCalls, obviouslyLockedSites));
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Error finding locked call sites", e);
            return;
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Error finding locked call sites", e);
            return;
        }
        for (Method method : allMethods) {
            String name;
            boolean inConstructor;
            if (DEBUG) {
                System.out.println("******** considering method " + method.getName());
            }
            if (classContext.getMethodGen(method) == null || method.getName().startsWith("access$") || (inConstructor = (name = method.getName()).equals("<init>") || name.equals("<clinit>") || name.equals("readObject") || name.equals("clone") || name.equals("close") || name.equals("finalize"))) continue;
            if (DEBUG) {
                System.out.println("******** Analyzing method " + method.getName());
            }
            try {
                this.analyzeMethod(classContext, method, lockedMethodSet);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing method", e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing method", e);
            }
        }
        for (Field f : javaClass.getFields()) {
            XField xf;
            FieldStats stats;
            if (!f.isPrivate() || (stats = this.statMap.get(xf = XFactory.getExactXField(classContext.getClassDescriptor().getClassName(), f))) == null || stats.isServletField() || stats.hasAnySynchronizedAccesses()) continue;
            this.statMap.remove(xf);
        }
    }

    @Override
    public void report() {
        if (this.statMap.isEmpty()) {
            return;
        }
        JCIPAnnotationDatabase jcipAnotationDatabase = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase();
        for (XField xfield : this.statMap.keySet()) {
            SourceLineAnnotation accessSourceLine;
            int printFreq;
            int freq;
            boolean notThreadSafe;
            FieldStats stats = this.statMap.get(xfield);
            if (!stats.isInteresting() || (notThreadSafe = jcipAnotationDatabase.hasClassAnnotation(xfield.getClassName(), "NotThreadSafe"))) continue;
            ElementValue guardedByValue = jcipAnotationDatabase.getFieldAnnotation(xfield, "GuardedBy");
            boolean guardedByThis = guardedByValue != null ? guardedByValue.stringifyValue().equals("this") : false;
            boolean threadSafe = jcipAnotationDatabase.hasClassAnnotation(xfield.getClassName(), "ThreadSafe");
            WarningPropertySet<InconsistentSyncWarningProperty> propertySet = new WarningPropertySet<InconsistentSyncWarningProperty>();
            int numReadUnlocked = stats.getNumAccesses(0);
            int numWriteUnlocked = stats.getNumAccesses(2);
            int numNullCheckUnlocked = stats.getNumAccesses(4);
            int numReadLocked = stats.getNumAccesses(1);
            int numWriteLocked = stats.getNumAccesses(3);
            int numNullCheckLocked = stats.getNumAccesses(5);
            int extra = 0;
            if (numWriteUnlocked > 0) {
                extra = numNullCheckLocked;
            }
            int locked = numReadLocked + numWriteLocked + numNullCheckLocked;
            int biasedLocked = numReadLocked + (int)(WRITE_BIAS * (double)(numWriteLocked + numNullCheckLocked + extra));
            int unlocked = numReadUnlocked + numWriteUnlocked + numNullCheckUnlocked;
            int biasedUnlocked = numReadUnlocked + (int)(WRITE_BIAS * (double)numWriteUnlocked);
            if (unlocked == 0) continue;
            if (guardedByThis) {
                propertySet.addProperty(InconsistentSyncWarningProperty.ANNOTATED_AS_GUARDED_BY_THIS);
            }
            if (threadSafe) {
                propertySet.addProperty(InconsistentSyncWarningProperty.ANNOTATED_AS_THREAD_SAFE);
            }
            if (!guardedByThis && locked == 0 && !stats.isServletField() || stats.isServletField() && numWriteLocked == 0 && numWriteUnlocked == 0) continue;
            if (DEBUG) {
                System.out.println("IS2: " + xfield);
                if (guardedByThis) {
                    System.out.println("Guarded by this");
                }
                System.out.println("  RL: " + numReadLocked);
                System.out.println("  WL: " + numWriteLocked);
                System.out.println("  NL: " + numNullCheckLocked);
                System.out.println("  RU: " + numReadUnlocked);
                System.out.println("  WU: " + numWriteUnlocked);
                System.out.println("  NU: " + numNullCheckUnlocked);
            }
            if (!EVAL && numReadUnlocked > 0 && (int)(UNSYNC_FACTOR * (double)(biasedUnlocked - 1)) > biasedLocked && !stats.isServletField()) {
                propertySet.addProperty(InconsistentSyncWarningProperty.MANY_BIASED_UNLOCKED);
            }
            if (numWriteUnlocked + numWriteLocked == 0) {
                if (DEBUG) {
                    System.out.println("  No writes outside of constructor");
                }
                propertySet.addProperty(InconsistentSyncWarningProperty.NEVER_WRITTEN);
            }
            if (numReadUnlocked + numReadLocked == 0) {
                if (DEBUG) {
                    System.out.println("  No reads outside of constructor");
                }
                propertySet.addProperty(InconsistentSyncWarningProperty.NEVER_READ);
            }
            if (stats.getNumLocalLocks() == 0) {
                if (DEBUG) {
                    System.out.println("  No local locks");
                }
                propertySet.addProperty(InconsistentSyncWarningProperty.NO_LOCAL_LOCKS);
            }
            if (locked + unlocked > 0) {
                freq = 100 * locked / (locked + unlocked);
                printFreq = 100 * locked / (locked + unlocked + numNullCheckUnlocked);
            } else {
                freq = 0;
                printFreq = 0;
            }
            if (freq < MIN_SYNC_PERCENT) {
                propertySet.addProperty(InconsistentSyncWarningProperty.BELOW_MIN_SYNC_PERCENT);
            }
            if (DEBUG) {
                System.out.println("  Sync %: " + freq);
            }
            if (stats.getNumGetterMethodAccesses() >= unlocked) {
                propertySet.addProperty(InconsistentSyncWarningProperty.ONLY_UNSYNC_IN_GETTERS);
            }
            if (stats.isServletField()) {
                propertySet.addProperty(InconsistentSyncWarningProperty.MUTABLE_SERVLET_FIELD);
            }
            BugInstance bugInstance = stats.isServletField() ? new BugInstance(this, "MSF_MUTABLE_SERVLET_FIELD", 2).addClass(xfield.getClassName()).addField(xfield) : new BugInstance(this, guardedByThis ? "IS_FIELD_NOT_GUARDED" : "IS2_INCONSISTENT_SYNC", 2).addClass(xfield.getClassName()).addField(xfield).addInt(printFreq).describe("INT_SYNC_PERCENT");
            propertySet.decorateBugInstance(bugInstance);
            Iterator<SourceLineAnnotation> j = stats.unsyncAccessIterator();
            while (j.hasNext()) {
                accessSourceLine = j.next();
                bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_UNSYNC_ACCESS");
            }
            j = stats.syncAccessIterator();
            while (j.hasNext()) {
                accessSourceLine = j.next();
                bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_SYNC_ACCESS");
            }
            if (EVAL) {
                bugInstance.addInt(biasedLocked).describe("INT_BIASED_LOCKED");
                bugInstance.addInt(biasedUnlocked).describe("INT_BIASED_UNLOCKED");
            }
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private static boolean isConstructor(String methodName) {
        return methodName.equals("<init>") || methodName.equals("<clinit>") || methodName.equals("readObject") || methodName.equals("clone") || methodName.equals("close") || methodName.equals("writeObject") || methodName.equals("toString") || methodName.equals("init") || methodName.equals("initialize") || methodName.equals("dispose") || methodName.equals("finalize") || methodName.equals("this") || methodName.equals("_jspInit") || methodName.equals("_jspDestroy");
    }

    private void analyzeMethod(ClassContext classContext, Method method, Set<Method> lockedMethodSet) throws CFGBuilderException, DataflowAnalysisException {
        InnerClassAccessMap icam = AnalysisContext.currentAnalysisContext().getInnerClassAccessMap();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        LockChecker lockChecker = classContext.getLockChecker(method);
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        boolean isGetterMethod = FindInconsistentSync2.isGetterMethod(classContext, method);
        MethodDescriptor methodDescriptor = DescriptorFactory.instance().getMethodDescriptor(classContext.getJavaClass(), method);
        if (DEBUG) {
            System.out.println("**** Analyzing method " + SignatureConverter.convertMethodSignature(methodGen));
        }
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            try {
                boolean isLocked;
                ValueNumberFrame frame;
                INVOKESTATIC inv;
                InnerClassAccess access;
                Instruction ins = location.getHandle().getInstruction();
                AccessibleEntity xfield = null;
                boolean isWrite = false;
                boolean isLocal = false;
                boolean isNullCheck = false;
                if (ins instanceof FieldInstruction) {
                    FieldInstruction fins;
                    InstructionHandle n = location.getHandle().getNext();
                    boolean bl = isNullCheck = n.getInstruction() instanceof IFNONNULL || n.getInstruction() instanceof IFNULL;
                    if (DEBUG && isNullCheck) {
                        System.out.println("is null check");
                    }
                    if ((xfield = Hierarchy.findXField(fins = (FieldInstruction)ins, cpg)) == null) continue;
                    isWrite = ins.getOpcode() == 181;
                    isLocal = fins.getClassName(cpg).equals(classContext.getJavaClass().getClassName());
                    if (DEBUG) {
                        System.out.println("Handling field access: " + location.getHandle() + " (frame=" + vnaDataflow.getFactAtLocation(location) + ") :" + n);
                    }
                } else if (ins instanceof INVOKESTATIC && (access = icam.getInnerClassAccess(inv = (INVOKESTATIC)ins, cpg)) != null && access.getMethodSignature().equals(inv.getSignature(cpg))) {
                    xfield = access.getField();
                    isWrite = !access.isLoad();
                    isLocal = false;
                    if (DEBUG) {
                        System.out.println("Handling inner class access: " + location.getHandle() + " (frame=" + vnaDataflow.getFactAtLocation(location) + ")");
                    }
                }
                if (xfield == null || xfield.isStatic() || xfield.isPublic() || xfield.isVolatile() || xfield.isFinal() || !(frame = (ValueNumberFrame)vnaDataflow.getFactAtLocation(location)).isValid()) continue;
                ValueNumber thisValue = !method.isStatic() ? ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getThisValue() : null;
                LockSet lockSet = lockChecker.getFactAtLocation(location);
                InstructionHandle handle = location.getHandle();
                ValueNumber instance = (ValueNumber)frame.getInstance(handle.getInstruction(), cpg);
                if (DEBUG) {
                    System.out.println("Lock set: " + lockSet);
                    System.out.println("value number: " + instance.getNumber());
                    System.out.println("Lock count: " + lockSet.getLockCount(instance.getNumber()));
                }
                boolean isExplicitlyLocked = lockSet.getLockCount(instance.getNumber()) > 0;
                boolean isAccessedThroughThis = thisValue != null && thisValue.equals(instance);
                boolean bl = isLocked = isExplicitlyLocked || (FindInconsistentSync2.isConstructor(method.getName()) || lockedMethodSet.contains(method)) && isAccessedThroughThis || lockSet.containsReturnValue(((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactory());
                if (ADJUST_SUBCLASS_ACCESSES) {
                    TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
                    TypeFrame typeFrame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                    if (!typeFrame.isValid()) continue;
                    Type instanceType = (Type)typeFrame.getInstance(handle.getInstruction(), cpg);
                    if (instanceType instanceof TopType) {
                        if (!DEBUG) continue;
                        System.out.println("Freaky: typeFrame is " + typeFrame);
                        continue;
                    }
                    if (instanceType != TypeFrame.getNullType() && instanceType != TypeFrame.getBottomType()) {
                        if (!(instanceType instanceof ObjectType)) {
                            throw new DataflowAnalysisException("Field accessed through non-object reference " + instanceType, methodGen, handle);
                        }
                        ObjectType objType = (ObjectType)instanceType;
                        String instanceClassName = objType.getClassName();
                        if (!instanceClassName.equals(xfield.getClassName())) {
                            xfield = XFactory.getExactXField(instanceClassName, xfield.getName(), xfield.getSignature(), xfield.isStatic());
                        }
                    }
                }
                int kind = 0;
                kind |= isLocked ? 1 : 0;
                kind |= isWrite ? 2 : (isNullCheck ? 4 : 0);
                if (DEBUG) {
                    System.out.println("IS2:\t" + SignatureConverter.convertMethodSignature(methodGen) + "\t" + xfield + "\t" + (isWrite ? "W" : "R") + "/" + (isLocked ? "L" : "U"));
                }
                if (!isLocked && methodDescriptor.getClassDescriptor().isAnonymousClass()) continue;
                FieldStats stats = this.getStats((XField)xfield);
                if (!isLocked || !FindInconsistentSync2.isConstructor(method.getName())) {
                    stats.addAccess(kind);
                }
                if (isExplicitlyLocked && isLocal) {
                    stats.addLocalLock();
                }
                if (isGetterMethod && !isLocked) {
                    stats.addGetterMethodAccess();
                }
                stats.addAccess(methodDescriptor, handle, isLocked);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    public static boolean isGetterMethod(ClassContext classContext, Method method) {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return false;
        }
        InstructionList il = methodGen.getInstructionList();
        if (il.getLength() > 60) {
            return false;
        }
        int count = 0;
        Iterator<InstructionHandle> it = il.iterator();
        while (it.hasNext()) {
            InstructionHandle ih = it.next();
            switch (ih.getInstruction().getOpcode()) {
                case 180: {
                    if (++count <= 1) break;
                    return false;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 179: 
                case 181: {
                    return false;
                }
            }
        }
        return true;
    }

    private FieldStats getStats(XField field) {
        FieldStats stats = this.statMap.get(field);
        if (stats == null) {
            stats = new FieldStats(field);
            this.statMap.put(field, stats);
        }
        return stats;
    }

    private static Set<Method> findNotUnlockedMethods(ClassContext classContext, SelfCalls selfCalls, Set<CallSite> obviouslyLockedSites) {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> lockedMethodSet = new HashSet<Method>();
        lockedMethodSet.addAll(Arrays.asList(methodList));
        for (Method method : methodList) {
            if (!method.isPublic() || FindInconsistentSync2.isConstructor(method.getName())) continue;
            lockedMethodSet.remove(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (obviouslyLockedSites.contains(callSite) || lockedMethodSet.contains(callSite.getMethod()) || !lockedMethodSet.remove((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Apparently not unlocked methods:");
            for (Method method : lockedMethodSet) {
                System.out.println("\t" + method.getName());
            }
        }
        return lockedMethodSet;
    }

    private static Set<Method> findLockedMethods(ClassContext classContext, SelfCalls selfCalls, Set<CallSite> obviouslyLockedSites) {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> lockedMethodSet = new HashSet<Method>();
        for (Method method : methodList) {
            if (!method.isSynchronized()) continue;
            lockedMethodSet.add(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (!obviouslyLockedSites.contains(callSite) && !lockedMethodSet.contains(callSite.getMethod()) || !lockedMethodSet.add((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Apparently locked methods:");
            for (Method method : lockedMethodSet) {
                System.out.println("\t" + method.getName());
            }
        }
        return lockedMethodSet;
    }

    private static Set<CallSite> findObviouslyLockedCallSites(ClassContext classContext, SelfCalls selfCalls) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        HashSet<CallSite> obviouslyLockedSites = new HashSet<CallSite>();
        Iterator<CallSite> i = selfCalls.callSiteIterator();
        while (i.hasNext()) {
            CallSite callSite = i.next();
            Method method = callSite.getMethod();
            Location location = callSite.getLocation();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (ins.getOpcode() == 184) continue;
            LockChecker lockChecker = classContext.getLockChecker(method);
            LockSet lockSet = lockChecker.getFactAtLocation(location);
            ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
            ValueNumberFrame frame = (ValueNumberFrame)vnaDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            int numConsumed = ins.consumeStack(cpg);
            MethodGen methodGen = classContext.getMethodGen(method);
            assert (methodGen != null);
            if (numConsumed == -2) {
                throw new DataflowAnalysisException("Unpredictable stack consumption", methodGen, handle);
            }
            ValueNumber instance = (ValueNumber)frame.getStackValue(numConsumed - 1);
            int lockCount = lockSet.getLockCount(instance.getNumber());
            if (lockCount <= 0) continue;
            obviouslyLockedSites.add(callSite);
        }
        return obviouslyLockedSites;
    }

    private static class FieldStats {
        private final int[] countList = new int[6];
        private int numLocalLocks = 0;
        private int numGetterMethodAccesses = 0;
        private List<FieldAccess> unsyncAccessList = Collections.emptyList();
        private List<FieldAccess> syncAccessList = Collections.emptyList();
        boolean interesting = true;
        final boolean servletField;

        FieldStats(XField field) {
            this.servletField = FindInconsistentSync2.isServletField(field);
        }

        public void addAccess(int kind) {
            int n = kind;
            this.countList[n] = this.countList[n] + 1;
        }

        public int getNumAccesses(int kind) {
            return this.countList[kind];
        }

        public void addLocalLock() {
            ++this.numLocalLocks;
        }

        public int getNumLocalLocks() {
            return this.numLocalLocks;
        }

        public void addGetterMethodAccess() {
            ++this.numGetterMethodAccesses;
        }

        public int getNumGetterMethodAccesses() {
            return this.numGetterMethodAccesses;
        }

        public boolean isInteresting() {
            return this.interesting;
        }

        public boolean isServletField() {
            return this.servletField;
        }

        public boolean hasAnySynchronizedAccesses() {
            return this.interesting && !this.syncAccessList.isEmpty();
        }

        public void addAccess(MethodDescriptor method, InstructionHandle handle, boolean isLocked) {
            if (!this.interesting) {
                return;
            }
            if (!this.servletField && !isLocked && this.syncAccessList.size() == 0 && this.unsyncAccessList.size() > 6) {
                this.interesting = false;
                this.syncAccessList = null;
                this.unsyncAccessList = null;
                return;
            }
            FieldAccess fa = new FieldAccess(method, handle.getPosition());
            if (isLocked) {
                this.syncAccessList = Util.addTo(this.syncAccessList, fa);
            } else {
                this.unsyncAccessList = Util.addTo(this.unsyncAccessList, fa);
            }
        }

        public Iterator<SourceLineAnnotation> unsyncAccessIterator() {
            if (!this.interesting) {
                throw new IllegalStateException("Not interesting");
            }
            return FieldAccess.asSourceLineAnnotation(this.unsyncAccessList).iterator();
        }

        public Iterator<SourceLineAnnotation> syncAccessIterator() {
            if (!this.interesting) {
                throw new IllegalStateException("Not interesting");
            }
            return FieldAccess.asSourceLineAnnotation(this.syncAccessList).iterator();
        }
    }

    private static class FieldAccess {
        final MethodDescriptor methodDescriptor;
        final int position;

        FieldAccess(MethodDescriptor methodDescriptor, int position) {
            this.methodDescriptor = methodDescriptor;
            this.position = position;
        }

        SourceLineAnnotation asSourceLineAnnotation() {
            return SourceLineAnnotation.fromVisitedInstruction(this.methodDescriptor, this.position);
        }

        public static Collection<SourceLineAnnotation> asSourceLineAnnotation(Collection<FieldAccess> c) {
            ArrayList<SourceLineAnnotation> result = new ArrayList<SourceLineAnnotation>(c.size());
            for (FieldAccess f : c) {
                result.add(f.asSourceLineAnnotation());
            }
            return result;
        }
    }
}

