/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.asm;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.RecomputableClassAnalysisEngine;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassNodeAnalysisEngine
extends RecomputableClassAnalysisEngine<ClassNode> {
    @Override
    public ClassNode analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        ClassReader classReader = analysisCache.getClassAnalysis(ClassReader.class, descriptor);
        ICodeBaseEntry entry = analysisCache.getClassPath().lookupResource(descriptor.toResourceName());
        try {
            ClassNode cn = new ClassNode();
            classReader.accept((ClassVisitor)cn, 0);
            return cn;
        }
        catch (RuntimeException e) {
            throw new InvalidClassFileFormatException(descriptor, entry, e);
        }
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassNode.class, this);
    }
}

