/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class OpcodeStackScanner {
    static final boolean DEBUG = SystemProperties.getBoolean("oss.debug");

    public static OpcodeStack getStackAt(JavaClass theClass, Method method, int pc) {
        Scanner scanner = new Scanner(theClass, method, pc);
        try {
            scanner.execute();
        }
        catch (EarlyExitException e) {
            return e.stack;
        }
        throw new UnreachableCodeException(theClass.getClassName(), method.getName(), method.getSignature(), pc);
    }

    static class Scanner
    extends OpcodeStackDetector {
        final JavaClass theClass;
        final Method targetMethod;
        final int targetPC;

        Scanner(JavaClass theClass, Method targetMethod, int targetPC) {
            if (DEBUG) {
                System.out.println("Scanning " + theClass.getClassName() + "." + targetMethod.getName());
            }
            this.theClass = theClass;
            this.targetMethod = targetMethod;
            this.targetPC = targetPC;
        }

        @Override
        public void sawOpcode(int seen) {
            if (DEBUG) {
                System.out.printf("%3d: %8s %s%n", this.getPC(), OPCODE_NAMES[seen], this.getStack());
            }
            if (this.getPC() == this.targetPC) {
                throw new EarlyExitException(this.stack);
            }
        }

        @Override
        public void visitJavaClass(JavaClass obj) {
            this.setupVisitorForClass(obj);
            this.getConstantPool().accept(this);
            this.doVisitMethod(this.targetMethod);
        }

        public void execute() {
            this.theClass.accept(this);
        }
    }

    static class EarlyExitException
    extends RuntimeException {
        final OpcodeStack stack;

        public EarlyExitException(OpcodeStack stack) {
            this.stack = stack;
        }
    }

    public static class UnreachableCodeException
    extends RuntimeException {
        @DottedClassName
        String className;
        String methodName;
        String methodSignature;
        int pc;

        public UnreachableCodeException(@DottedClassName String className, String methodName, String methodSignature, int pc) {
            super("Didn't reach pc " + pc + " of " + className + "." + methodName + methodSignature);
            this.className = className;
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.pc = pc;
        }
    }
}

