/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.util.EditDistance;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.InstructionHandle;

public class LocalVariableAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "LOCAL_VARIABLE_DEFAULT";
    public static final String NAMED_ROLE = "LOCAL_VARIABLE_NAMED";
    public static final String UNKNOWN_ROLE = "LOCAL_VARIABLE_UNKNOWN";
    public static final String PARAMETER_ROLE = "LOCAL_VARIABLE_PARAMETER";
    public static final String PARAMETER_NAMED_ROLE = "LOCAL_VARIABLE_PARAMETER_NAMED";
    public static final String PARAMETER_VALUE_SOURCE_ROLE = "LOCAL_VARIABLE_PARAMETER_VALUE_SOURCE";
    public static final String PARAMETER_VALUE_SOURCE_NAMED_ROLE = "LOCAL_VARIABLE_PARAMETER_VALUE_SOURCE_NAMED";
    public static final String VALUE_DOOMED_ROLE = "LOCAL_VARIABLE_VALUE_DOOMED";
    public static final String VALUE_DOOMED_NAMED_ROLE = "LOCAL_VARIABLE_VALUE_DOOMED_NAMED";
    public static final String DID_YOU_MEAN_ROLE = "LOCAL_VARIABLE_DID_YOU_MEAN";
    public static final String INVOKED_ON_ROLE = "LOCAL_VARIABLE_INVOKED_ON";
    public static final String ARGUMENT_ROLE = "LOCAL_VARIABLE_ARGUMENT";
    public static final String VALUE_OF_ROLE = "LOCAL_VARIABLE_VALUE_OF";
    private final String name;
    final int register;
    final int pc;
    final int line;
    private String description;
    private static final String ELEMENT_NAME = "LocalVariable";

    public LocalVariableAnnotation(String name, int register, int pc) {
        this.name = name;
        this.register = register;
        this.pc = pc;
        this.line = -1;
        this.description = DEFAULT_ROLE;
        this.setDescription(name.equals("?") ? UNKNOWN_ROLE : NAMED_ROLE);
    }

    public LocalVariableAnnotation(String name, int register, int pc, int line) {
        this.name = name;
        this.register = register;
        this.pc = pc;
        this.line = line;
        this.description = DEFAULT_ROLE;
        this.setDescription(name.equals("?") ? UNKNOWN_ROLE : NAMED_ROLE);
    }

    public static LocalVariableAnnotation getLocalVariableAnnotation(Method method, Location location, IndexedInstruction ins) {
        int local = ins.getIndex();
        InstructionHandle handle = location.getHandle();
        int position1 = handle.getNext().getPosition();
        int position2 = handle.getPosition();
        return LocalVariableAnnotation.getLocalVariableAnnotation(method, local, position1, position2);
    }

    public static LocalVariableAnnotation getLocalVariableAnnotation(Method method, int local, int position1, int position2) {
        LineNumberTable lineNumbers;
        LocalVariableTable localVariableTable = method.getLocalVariableTable();
        String localName = "?";
        if (localVariableTable != null) {
            LocalVariable lv1 = localVariableTable.getLocalVariable(local, position1);
            if (lv1 == null) {
                lv1 = localVariableTable.getLocalVariable(local, position2);
                position1 = position2;
            }
            if (lv1 != null) {
                localName = lv1.getName();
            } else {
                for (LocalVariable lv : localVariableTable.getLocalVariableTable()) {
                    if (lv.getIndex() != local) continue;
                    if (!localName.equals("?") && !localName.equals(lv.getName())) {
                        localName = "?";
                        break;
                    }
                    localName = lv.getName();
                }
            }
        }
        if ((lineNumbers = method.getLineNumberTable()) == null) {
            return new LocalVariableAnnotation(localName, local, position1);
        }
        int line = lineNumbers.getSourceLine(position1);
        return new LocalVariableAnnotation(localName, local, position1, line);
    }

    public static LocalVariableAnnotation getParameterLocalVariableAnnotation(Method method, int local) {
        LocalVariableAnnotation lva = LocalVariableAnnotation.getLocalVariableAnnotation(method, local, 0, 0);
        if (lva.isNamed()) {
            lva.setDescription(PARAMETER_NAMED_ROLE);
        } else {
            lva.setDescription(PARAMETER_ROLE);
        }
        return lva;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitLocalVariableAnnotation(this);
    }

    @Override
    public String format(String key, ClassAnnotation primaryClass) {
        if (key.equals("hash")) {
            if (this.register < 0) {
                return "??";
            }
            return this.name;
        }
        if (this.register < 0) {
            return "?";
        }
        if (key.equals("register")) {
            return String.valueOf(this.register);
        }
        if (key.equals("pc")) {
            return String.valueOf(this.pc);
        }
        if (key.equals("name") || key.equals("givenClass")) {
            return this.name;
        }
        if (!this.name.equals("?")) {
            return this.name;
        }
        return "$L" + this.register;
    }

    @Override
    public void setDescription(String description) {
        this.description = description.intern();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariableAnnotation)) {
            return false;
        }
        return this.name.equals(((LocalVariableAnnotation)o).name);
    }

    @Override
    public int compareTo(BugAnnotation o) {
        if (!(o instanceof LocalVariableAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.name.compareTo(((LocalVariableAnnotation)o).name);
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("name", this.name).addAttribute("register", String.valueOf(this.register)).addAttribute("pc", String.valueOf(this.pc));
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    public boolean isNamed() {
        return this.register >= 0 && !this.name.equals("?");
    }

    public String getName() {
        return this.name;
    }

    public int getPC() {
        return this.pc;
    }

    public int getRegister() {
        return this.register;
    }

    @Override
    public boolean isSignificant() {
        return !this.name.equals("?");
    }

    @CheckForNull
    public static LocalVariableAnnotation getLocalVariableAnnotation(Method method, OpcodeStack.Item item, int pc) {
        int reg = item.getRegisterNumber();
        if (reg < 0) {
            return null;
        }
        return LocalVariableAnnotation.getLocalVariableAnnotation(method, reg, pc, item.getPC());
    }

    @CheckForNull
    public static LocalVariableAnnotation getLocalVariableAnnotation(DismantleBytecode visitor, OpcodeStack.Item item) {
        int reg = item.getRegisterNumber();
        if (reg < 0) {
            return null;
        }
        return LocalVariableAnnotation.getLocalVariableAnnotation(visitor.getMethod(), reg, visitor.getPC(), item.getPC());
    }

    @CheckForNull
    public static LocalVariableAnnotation findMatchingIgnoredParameter(ClassContext classContext, Method method, String name, String signature) {
        try {
            LiveLocalStoreDataflow llsaDataflow = classContext.getLiveLocalStoreDataflow(method);
            CFG cfg = classContext.getCFG(method);
            LocalVariableAnnotation match = null;
            int lowestCost = Integer.MAX_VALUE;
            BitSet liveStoreSetAtEntry = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getResultFact(cfg.getEntry());
            int localsThatAreParameters = PreorderVisitor.getNumberArguments(method.getSignature());
            int startIndex = 0;
            if (!method.isStatic()) {
                startIndex = 1;
            }
            SignatureParser parser = new SignatureParser(method.getSignature());
            Iterator<String> signatureIterator = parser.parameterSignatureIterator();
            for (int i = startIndex; i < localsThatAreParameters + startIndex; ++i) {
                String sig = signatureIterator.next();
                if (liveStoreSetAtEntry.get(i) || !signature.equals(sig)) continue;
                LocalVariableAnnotation potentialMatch = LocalVariableAnnotation.getLocalVariableAnnotation(method, i, 0, 0);
                potentialMatch.setDescription(DID_YOU_MEAN_ROLE);
                if (!potentialMatch.isNamed()) {
                    return potentialMatch;
                }
                int distance = EditDistance.editDistance(name, potentialMatch.getName());
                if (distance < lowestCost) {
                    match = potentialMatch;
                    match.setDescription(DID_YOU_MEAN_ROLE);
                    lowestCost = distance;
                    continue;
                }
                if (distance != lowestCost) continue;
                match = null;
            }
            return match;
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("", e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("", e);
        }
        return null;
    }

    @CheckForNull
    public static LocalVariableAnnotation findUniqueBestMatchingParameter(ClassContext classContext, Method method, String name, String signature) {
        LocalVariableAnnotation match = null;
        int localsThatAreParameters = PreorderVisitor.getNumberArguments(method.getSignature());
        int startIndex = 0;
        if (!method.isStatic()) {
            startIndex = 1;
        }
        SignatureParser parser = new SignatureParser(method.getSignature());
        Iterator<String> signatureIterator = parser.parameterSignatureIterator();
        int lowestCost = Integer.MAX_VALUE;
        for (int i = startIndex; i < localsThatAreParameters + startIndex; ++i) {
            LocalVariableAnnotation potentialMatch;
            String sig = signatureIterator.next();
            if (!signature.equals(sig) || !(potentialMatch = LocalVariableAnnotation.getLocalVariableAnnotation(method, i, 0, 0)).isNamed()) continue;
            int distance = EditDistance.editDistance(name, potentialMatch.getName());
            if (distance < lowestCost) {
                match = potentialMatch;
                match.setDescription(DID_YOU_MEAN_ROLE);
                lowestCost = distance;
                continue;
            }
            if (distance != lowestCost) continue;
            match = null;
        }
        if (lowestCost < 5) {
            return match;
        }
        return null;
    }

    @Override
    public String toString(ClassAnnotation primaryClass) {
        return this.toString();
    }
}

