/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;

public class ReflectiveClasses
extends BytecodeScanningDetector
implements NonReportingDetector {
    String constantString;

    public ReflectiveClasses(BugReporter bugReporter) {
        AnalysisContext.currentXFactory().addReflectiveClasses(DescriptorFactory.createClassDescriptor(System.class));
    }

    @Override
    public void sawString(String s) {
        this.constantString = s;
    }

    @Override
    public void sawClass() {
        int opcode = this.getOpcode();
        if (opcode == 18 || opcode == 19) {
            this.process(this.getClassConstantOperand());
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 184 && this.constantString != null && this.getClassConstantOperand().equals("java/lang/Class") && this.getNameConstantOperand().equals("forName")) {
            this.process(ClassName.toSlashedClassName(this.constantString));
        }
        this.constantString = null;
    }

    private void process(@SlashedClassName String className) {
        ClassDescriptor d = DescriptorFactory.createClassDescriptor(className);
        AnalysisContext.currentXFactory().addReflectiveClasses(d);
    }
}

