/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.HashSet;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Method;

public class FindUncalledPrivateMethods
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private String className;
    private HashSet<MethodAnnotation> definedPrivateMethods;
    private HashSet<MethodAnnotation> calledMethods;
    private HashSet<String> calledMethodNames;

    public FindUncalledPrivateMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitMethod(Method obj) {
        if (!obj.isPrivate() || obj.isSynthetic()) {
            return;
        }
        super.visitMethod(obj);
        String methodName = this.getMethodName();
        if (!(methodName.equals("writeReplace") || methodName.equals("readResolve") || methodName.equals("readObject") || methodName.equals("readObjectNoData") || methodName.equals("writeObject") || methodName.indexOf("debug") != -1 || methodName.indexOf("Debug") != -1 || methodName.indexOf("trace") != -1 || methodName.indexOf("Trace") != -1 || methodName.equals("<init>") || methodName.equals("<clinit>"))) {
            for (AnnotationEntry a : obj.getAnnotationEntries()) {
                String typeName = a.getAnnotationType();
                if (!typeName.equals("Ljavax/annotation/PostConstruct;") && !typeName.equals("Ljavax/annotation/PreDestroy;")) continue;
                return;
            }
            this.definedPrivateMethods.add(MethodAnnotation.fromVisitedMethod(this));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: {
                if (!this.getDottedClassConstantOperand().equals(this.className)) break;
                String className = this.getDottedClassConstantOperand();
                MethodAnnotation called = new MethodAnnotation(className, this.getNameConstantOperand(), this.getSigConstantOperand(), seen == 184);
                this.calledMethods.add(called);
                this.calledMethodNames.add(this.getNameConstantOperand().toLowerCase());
                break;
            }
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.definedPrivateMethods = new HashSet();
        this.calledMethods = new HashSet();
        this.calledMethodNames = new HashSet();
        this.className = classContext.getJavaClass().getClassName();
        String[] parts = this.className.split("[$+.]");
        String simpleClassName = parts[parts.length - 1];
        super.visitClassContext(classContext);
        this.definedPrivateMethods.removeAll(this.calledMethods);
        for (MethodAnnotation m : this.definedPrivateMethods) {
            int priority = 3;
            String methodName = m.getMethodName();
            if (methodName.equals(simpleClassName) && m.getMethodSignature().equals("()V")) continue;
            if (methodName.length() > 1 && this.calledMethodNames.contains(methodName.toLowerCase())) {
                priority = 2;
            }
            BugInstance bugInstance = new BugInstance(this, "UPM_UNCALLED_PRIVATE_METHOD", priority).addClass(this).addMethod(m);
            this.bugReporter.reportBug(bugInstance);
        }
        this.definedPrivateMethods = null;
        this.calledMethods = null;
    }
}

