/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.interproc.MethodPropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.ba.obl.MatchMethodEntry;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntryType;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ExactStringMatcher;
import edu.umd.cs.findbugs.util.RegexStringMatcher;
import edu.umd.cs.findbugs.util.SplitCamelCaseIdentifier;
import edu.umd.cs.findbugs.util.SubtypeTypeMatcher;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.WillClose;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class BuildObligationPolicyDatabase
implements Detector2,
NonReportingDetector {
    public static final boolean INFER_CLOSE_METHODS = SystemProperties.getBoolean("oa.inferclose", true);
    private static final boolean DEBUG_ANNOTATIONS = SystemProperties.getBoolean("oa.debug.annotations");
    private static final boolean DUMP_DB = SystemProperties.getBoolean("oa.dumpdb");
    private final BugReporter reporter;
    private final ObligationPolicyDatabase database;
    private final ClassDescriptor willClose;
    private final ClassDescriptor willNotClose;
    private final ClassDescriptor willCloseWhenClosed;
    private final ClassDescriptor cleanupObligation;
    private final ClassDescriptor createsObligation;
    private final ClassDescriptor dischargesObligation;
    private boolean sawAnnotationsInApplicationCode;

    public BuildObligationPolicyDatabase(BugReporter bugReporter) {
        this.reporter = bugReporter;
        DescriptorFactory instance = DescriptorFactory.instance();
        this.willClose = instance.getClassDescriptor(WillClose.class);
        this.willNotClose = instance.getClassDescriptor(WillNotClose.class);
        this.willCloseWhenClosed = instance.getClassDescriptor(WillCloseWhenClosed.class);
        this.cleanupObligation = instance.getClassDescriptor(CleanupObligation.class);
        this.createsObligation = instance.getClassDescriptor(CreatesObligation.class);
        this.dischargesObligation = instance.getClassDescriptor(DischargesObligation.class);
        this.database = new ObligationPolicyDatabase();
        this.addBuiltInPolicies();
        URL u = DetectorFactoryCollection.getCoreResource("obligationPolicy.db");
        try {
            if (u != null) {
                AuxilaryObligationPropertyDatabase db = new AuxilaryObligationPropertyDatabase();
                db.read(u.openStream());
                for (Map.Entry e : db.entrySet()) {
                    String[] v = ((String)e.getValue()).split(",");
                    Obligation obligation = this.database.getFactory().getObligationByName(v[2]);
                    if (obligation == null) {
                        obligation = this.database.getFactory().addObligation(v[2]);
                    }
                    this.database.addEntry(new MatchMethodEntry((MethodDescriptor)e.getKey(), ObligationPolicyDatabaseActionType.valueOf(v[0]), ObligationPolicyDatabaseEntryType.valueOf(v[1]), obligation));
                }
            }
        }
        catch (Exception e) {
            AnalysisContext.logError("Unable to read " + u, e);
        }
        this.scanForResourceTypes();
        Global.getAnalysisCache().eagerlyPutDatabase(ObligationPolicyDatabase.class, this.database);
    }

    @Override
    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
        Obligation thisClassObligation = this.database.getFactory().getObligationByType(xclass.getClassDescriptor());
        for (XMethod xMethod : xclass.getXMethods()) {
            if (thisClassObligation != null) {
                if (xMethod.getAnnotation(this.createsObligation) != null) {
                    this.database.addEntry(new MatchMethodEntry(xMethod, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, thisClassObligation));
                }
                if (xMethod.getAnnotation(this.dischargesObligation) != null) {
                    this.database.addEntry(new MatchMethodEntry(xMethod, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, thisClassObligation));
                }
            }
            this.addObligations(xMethod);
        }
    }

    public void addObligations(XMethod xmethod) {
        Obligation[] paramObligationTypes = this.database.getFactory().getParameterObligationTypes(xmethod);
        boolean methodHasCloseInName = false;
        if (INFER_CLOSE_METHODS) {
            SplitCamelCaseIdentifier splitter = new SplitCamelCaseIdentifier(xmethod.getName());
            methodHasCloseInName = splitter.split().contains("close");
        }
        for (int i = 0; i < xmethod.getNumParams(); ++i) {
            Obligation obligationType = paramObligationTypes[i];
            if (obligationType == null) continue;
            if (xmethod.getParameterAnnotation(i, this.willCloseWhenClosed) != null) {
                this.handleWillCloseWhenClosed(xmethod, obligationType);
                continue;
            }
            if (xmethod.getParameterAnnotation(i, this.willClose) != null) {
                this.addParameterDeletesObligationDatabaseEntry(xmethod, obligationType, ObligationPolicyDatabaseEntryType.STRONG);
                this.sawAnnotationsInApplicationCode = true;
                continue;
            }
            if (xmethod.getParameterAnnotation(i, this.willNotClose) != null) {
                this.sawAnnotationsInApplicationCode = true;
                continue;
            }
            if (INFER_CLOSE_METHODS && methodHasCloseInName) {
                this.addParameterDeletesObligationDatabaseEntry(xmethod, obligationType, ObligationPolicyDatabaseEntryType.STRONG);
                continue;
            }
            if (!xmethod.getName().equals("<init>") && !xmethod.isStatic() && xmethod.getName().toLowerCase().indexOf("close") < 0 && xmethod.getSignature().toLowerCase().indexOf("Closeable") < 0) continue;
            this.addParameterDeletesObligationDatabaseEntry(xmethod, obligationType, ObligationPolicyDatabaseEntryType.WEAK);
        }
    }

    @Override
    public void finishPass() {
        this.database.setStrictChecking(this.sawAnnotationsInApplicationCode);
        if (DUMP_DB || ObligationPolicyDatabase.DEBUG) {
            System.out.println("======= Completed ObligationPolicyDatabase ======= ");
            System.out.println("Strict checking is " + (this.database.isStrictChecking() ? "ENABLED" : "disabled"));
            for (ObligationPolicyDatabaseEntry entry : this.database.getEntries()) {
                System.out.println("  * " + entry);
            }
            System.out.println("================================================== ");
        }
    }

    @Override
    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    private void addBuiltInPolicies() {
        this.addFileStreamEntries("InputStream");
        this.addFileStreamEntries("OutputStream");
        this.addFileStreamEntries("Reader");
        this.addFileStreamEntries("Writer");
        Obligation javaIoInputStreamObligation = this.database.getFactory().getObligationByName("java.io.InputStream");
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.lang.Class")), new ExactStringMatcher("getResourceAsStream"), new ExactStringMatcher("(Ljava/lang/String;)Ljava/io/InputStream;"), false, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, javaIoInputStreamObligation));
        Obligation javaIoOutputStreamObligation = this.database.getFactory().getObligationByName("java.io.OutputStream");
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.util.logging.StreamHandler")), new ExactStringMatcher("setOutputStream"), new ExactStringMatcher("(Ljava/io/OutputStream;)V"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, javaIoOutputStreamObligation));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.io.FileOutputStream")), new ExactStringMatcher("getChannel"), new ExactStringMatcher("()Ljava/nio/channels/FileChannel;"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, javaIoOutputStreamObligation));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.io.FileInputStream")), new ExactStringMatcher("getChannel"), new ExactStringMatcher("()Ljava/nio/channels/FileChannel;"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, javaIoInputStreamObligation));
        Obligation connection = this.database.getFactory().addObligation("java.sql.Connection");
        Obligation statement = this.database.getFactory().addObligation("java.sql.Statement");
        Obligation resultSet = this.database.getFactory().addObligation("java.sql.ResultSet");
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.DriverManager")), new ExactStringMatcher("getConnection"), new RegexStringMatcher("^.*\\)Ljava/sql/Connection;$"), false, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, connection));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.Connection")), new ExactStringMatcher("createStatement"), new RegexStringMatcher("^.*\\)Ljava/sql/Statement;$"), false, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, statement));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.Connection")), new ExactStringMatcher("prepareStatement"), new RegexStringMatcher("^.*\\)Ljava/sql/PreparedStatement;$"), false, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, statement));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.Statement")), new ExactStringMatcher("executeQuery"), new RegexStringMatcher("^.*\\)Ljava/sql/ResultSet;$"), false, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, resultSet));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.Connection")), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, connection));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.Statement")), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, statement, resultSet));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.sql.ResultSet")), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, resultSet));
    }

    private void addFileStreamEntries(String kind) {
        Obligation obligation = this.database.getFactory().addObligation("java.io." + kind);
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.io.File" + kind)), new ExactStringMatcher("<init>"), new RegexStringMatcher(".*"), false, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, obligation));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(BCELUtil.getObjectTypeInstance("java.io." + kind)), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, obligation));
    }

    private void addParameterDeletesObligationDatabaseEntry(XMethod xmethod, Obligation obligation, ObligationPolicyDatabaseEntryType entryType) {
        ObligationPolicyDatabaseEntry entry = this.database.addParameterDeletesObligationDatabaseEntry(xmethod, obligation, entryType);
        if (DEBUG_ANNOTATIONS) {
            System.out.println("Added entry: " + entry);
        }
    }

    private void handleWillCloseWhenClosed(XMethod xmethod, Obligation deletedObligation) {
        if (deletedObligation == null) {
            if (DEBUG_ANNOTATIONS) {
                System.out.println("Method " + xmethod.toString() + " is marked @WillCloseWhenClosed, " + "but its parameter is not an obligation");
            }
            return;
        }
        Obligation createdObligation = null;
        if (xmethod.getName().equals("<init>")) {
            createdObligation = this.database.getFactory().getObligationByType(xmethod.getClassDescriptor());
        } else {
            Type returnType = Type.getReturnType(xmethod.getSignature());
            if (returnType instanceof ObjectType) {
                try {
                    createdObligation = this.database.getFactory().getObligationByType((ObjectType)returnType);
                }
                catch (ClassNotFoundException e) {
                    this.reporter.reportMissingClass(e);
                    return;
                }
            }
        }
        if (createdObligation == null) {
            if (DEBUG_ANNOTATIONS) {
                System.out.println("Method " + xmethod.toString() + " is marked @WillCloseWhenClosed, " + "but its return type is not an obligation");
            }
            return;
        }
        this.database.addEntry(new MatchMethodEntry(xmethod, ObligationPolicyDatabaseActionType.DEL, ObligationPolicyDatabaseEntryType.STRONG, deletedObligation));
        this.database.addEntry(new MatchMethodEntry(xmethod, ObligationPolicyDatabaseActionType.ADD, ObligationPolicyDatabaseEntryType.STRONG, createdObligation));
    }

    private void scanForResourceTypes() {
        Subtypes2 subtypes2 = Global.getAnalysisCache().getDatabase(Subtypes2.class);
        Collection<XClass> knownClasses = subtypes2.getXClassCollection();
        for (XClass xclass : knownClasses) {
            if (xclass.getAnnotation(this.cleanupObligation) == null) continue;
            this.database.getFactory().addObligation(xclass.getClassDescriptor().toDottedClassName());
        }
        if (DEBUG_ANNOTATIONS) {
            System.out.println("After scanning for resource types:");
            Iterator<Obligation> i = this.database.getFactory().obligationIterator();
            while (i.hasNext()) {
                Obligation obligation = i.next();
                System.out.println("  " + obligation);
            }
        }
    }

    static class AuxilaryObligationPropertyDatabase
    extends MethodPropertyDatabase<String> {
        AuxilaryObligationPropertyDatabase() {
        }

        @Override
        protected String decodeProperty(String propStr) throws PropertyDatabaseFormatException {
            return propStr;
        }

        @Override
        protected String encodeProperty(String property) {
            return property;
        }
    }
}

