/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Method;

public class AppendingToAnObjectOutputStream
extends OpcodeStackDetector {
    BugReporter bugReporter;
    boolean sawOpenInAppendMode;

    public AppendingToAnObjectOutputStream(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        this.sawOpenInAppendMode = false;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen != 183) {
            this.sawOpenInAppendMode = false;
            return;
        }
        String calledClassName = this.getClassConstantOperand();
        String calledMethodName = this.getNameConstantOperand();
        String calledMethodSig = this.getSigConstantOperand();
        if (!this.sawOpenInAppendMode) {
            if (calledClassName.equals("java/io/ObjectOutputStream") && calledMethodName.equals("<init>") && calledMethodSig.equals("(Ljava/io/OutputStream;)V") && this.stack.getStackItem(0).getSpecialKind() == 16) {
                this.bugReporter.reportBug(new BugInstance(this, "IO_APPENDING_TO_OBJECT_OUTPUT_STREAM", 1).addClassAndMethod(this).addSourceLine(this));
            }
            return;
        }
        if (calledClassName.equals("java/io/FileOutputStream") && calledMethodName.equals("<init>") && (calledMethodSig.equals("(Ljava/io/File;Z)V") || calledMethodSig.equals("(Ljava/lang/String;Z)V"))) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            Object value = item.getConstant();
            this.sawOpenInAppendMode = value instanceof Integer && (Integer)value == 1;
        } else {
            if (!this.sawOpenInAppendMode) {
                return;
            }
            if (!(calledClassName.equals("java/io/BufferedOutputStream") && calledMethodName.equals("<init>") && calledMethodSig.equals("(Ljava/io/OutputStream;)V"))) {
                if (calledClassName.equals("java/io/ObjectOutputStream") && calledMethodName.equals("<init>") && calledMethodSig.equals("(Ljava/io/OutputStream;)V")) {
                    this.bugReporter.reportBug(new BugInstance(this, "IO_APPENDING_TO_OBJECT_OUTPUT_STREAM", 1).addClassAndMethod(this).addSourceLine(this));
                    this.sawOpenInAppendMode = false;
                } else {
                    this.sawOpenInAppendMode = false;
                }
            }
        }
    }
}

