/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.config;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.SortedProperties;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.WillClose;

public class UserPreferences
implements Cloneable {
    private static final char BOOL_SEPARATOR = '|';
    public static final String EFFORT_MIN = "min";
    public static final String EFFORT_DEFAULT = "default";
    public static final String EFFORT_MAX = "max";
    public static final String KEY_PLUGIN = "plugin";
    private static final String PREF_FILE_NAME = ".Findbugs_prefs";
    private static final int MAX_RECENT_FILES = 9;
    private static final String CLOUD_ID_KEY = "cloud_id";
    private static final String DETECTOR_THRESHOLD_KEY = "detector_threshold";
    private static final String FILTER_SETTINGS_KEY = "filter_settings";
    private static final String FILTER_SETTINGS2_KEY = "filter_settings_neg";
    private static final String RUN_AT_FULL_BUILD = "run_at_full_build";
    private static final String EFFORT_KEY = "effort";
    public static final String KEY_INCLUDE_FILTER = "includefilter";
    public static final String KEY_EXCLUDE_FILTER = "excludefilter";
    public static final String KEY_EXCLUDE_BUGS = "excludebugs";
    private LinkedList<String> recentProjectsList;
    private Map<String, Boolean> detectorEnablementMap;
    private ProjectFilterSettings filterSettings = ProjectFilterSettings.createDefault();
    private boolean runAtFullBuild = true;
    private String effort = "default";
    private String cloudId;
    private Map<String, Boolean> includeFilterFiles;
    private Map<String, Boolean> excludeFilterFiles;
    private Map<String, Boolean> excludeBugsFiles;
    private Map<String, Boolean> customPlugins;

    private UserPreferences() {
        this.recentProjectsList = new LinkedList();
        this.detectorEnablementMap = new HashMap<String, Boolean>();
        this.includeFilterFiles = new TreeMap<String, Boolean>();
        this.excludeFilterFiles = new TreeMap<String, Boolean>();
        this.excludeBugsFiles = new TreeMap<String, Boolean>();
        this.customPlugins = new TreeMap<String, Boolean>();
    }

    public static UserPreferences createDefaultUserPreferences() {
        return new UserPreferences();
    }

    public void read() {
        File prefFile = new File(SystemProperties.getProperty("user.home"), PREF_FILE_NAME);
        if (!prefFile.exists() || !prefFile.isFile()) {
            return;
        }
        try {
            this.read(new FileInputStream(prefFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(@WillClose InputStream in) throws IOException {
        BufferedInputStream prefStream = null;
        Properties props = new Properties();
        try {
            prefStream = new BufferedInputStream(in);
            props.load(prefStream);
        }
        finally {
            try {
                if (prefStream != null) {
                    prefStream.close();
                }
            }
            catch (IOException ioe) {}
        }
        if (props.size() == 0) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            String key = "recent" + i;
            String projectName = (String)props.get(key);
            if (projectName == null) continue;
            this.recentProjectsList.add(projectName);
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String detectorState;
            int pipePos;
            String key = (String)e.getKey();
            if (!key.startsWith("detector") || key.startsWith("detector_") || (pipePos = (detectorState = (String)e.getValue()).indexOf(124)) < 0) continue;
            String name = detectorState.substring(0, pipePos);
            String enabled = detectorState.substring(pipePos + 1);
            this.detectorEnablementMap.put(name, Boolean.valueOf(enabled));
        }
        if (props.get(FILTER_SETTINGS_KEY) != null) {
            this.filterSettings = ProjectFilterSettings.fromEncodedString(props.getProperty(FILTER_SETTINGS_KEY));
        } else {
            String threshold = (String)props.get(DETECTOR_THRESHOLD_KEY);
            if (threshold != null) {
                try {
                    int detectorThreshold = Integer.parseInt(threshold);
                    this.setUserDetectorThreshold(detectorThreshold);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (props.get(FILTER_SETTINGS2_KEY) != null) {
            ProjectFilterSettings.hiddenFromEncodedString(this.filterSettings, props.getProperty(FILTER_SETTINGS2_KEY));
        }
        if (props.get(RUN_AT_FULL_BUILD) != null) {
            this.runAtFullBuild = Boolean.parseBoolean(props.getProperty(RUN_AT_FULL_BUILD));
        }
        this.effort = props.getProperty(EFFORT_KEY, EFFORT_DEFAULT);
        this.cloudId = props.getProperty(CLOUD_ID_KEY);
        this.includeFilterFiles = UserPreferences.readProperties(props, KEY_INCLUDE_FILTER);
        this.excludeFilterFiles = UserPreferences.readProperties(props, KEY_EXCLUDE_FILTER);
        this.excludeBugsFiles = UserPreferences.readProperties(props, KEY_EXCLUDE_BUGS);
        this.customPlugins = UserPreferences.readProperties(props, KEY_PLUGIN);
    }

    public void write() {
        block2: {
            try {
                File prefFile = new File(SystemProperties.getProperty("user.home"), PREF_FILE_NAME);
                this.write(new FileOutputStream(prefFile));
            }
            catch (IOException e) {
                if (!FindBugs.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@WillClose OutputStream out) throws IOException {
        SortedProperties props = new SortedProperties();
        for (int i = 0; i < this.recentProjectsList.size(); ++i) {
            String projectName = this.recentProjectsList.get(i);
            String key = "recent" + i;
            props.put(key, projectName);
        }
        for (Map.Entry<String, Boolean> entry : this.detectorEnablementMap.entrySet()) {
            props.put("detector" + entry.getKey(), entry.getKey() + '|' + String.valueOf(entry.getValue()));
        }
        props.put(FILTER_SETTINGS_KEY, this.filterSettings.toEncodedString());
        props.put(FILTER_SETTINGS2_KEY, this.filterSettings.hiddenToEncodedString());
        props.put(DETECTOR_THRESHOLD_KEY, String.valueOf(this.filterSettings.getMinPriorityAsInt()));
        props.put(RUN_AT_FULL_BUILD, String.valueOf(this.runAtFullBuild));
        props.setProperty(EFFORT_KEY, this.effort);
        if (this.cloudId != null) {
            props.setProperty(CLOUD_ID_KEY, this.cloudId);
        }
        UserPreferences.writeProperties(props, KEY_INCLUDE_FILTER, this.includeFilterFiles);
        UserPreferences.writeProperties(props, KEY_EXCLUDE_FILTER, this.excludeFilterFiles);
        UserPreferences.writeProperties(props, KEY_EXCLUDE_BUGS, this.excludeBugsFiles);
        UserPreferences.writeProperties(props, KEY_PLUGIN, this.customPlugins);
        BufferedOutputStream prefStream = null;
        try {
            prefStream = new BufferedOutputStream(out);
            props.store(prefStream, "FindBugs User Preferences");
            ((OutputStream)prefStream).flush();
        }
        finally {
            try {
                if (prefStream != null) {
                    ((OutputStream)prefStream).close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public List<String> getRecentProjects() {
        return this.recentProjectsList;
    }

    public void useProject(String projectName) {
        this.removeProject(projectName);
        this.recentProjectsList.addFirst(projectName);
        while (this.recentProjectsList.size() > 9) {
            this.recentProjectsList.removeLast();
        }
    }

    public void removeProject(String projectName) {
        Iterator it = this.recentProjectsList.iterator();
        while (it.hasNext()) {
            if (!projectName.equals(it.next())) continue;
            it.remove();
        }
    }

    public void enableDetector(DetectorFactory factory, boolean enable) {
        this.detectorEnablementMap.put(factory.getShortName(), enable);
    }

    public boolean isDetectorEnabled(DetectorFactory factory) {
        String detectorName = factory.getShortName();
        Boolean enabled = this.detectorEnablementMap.get(detectorName);
        if (enabled == null) {
            enabled = factory.isDefaultEnabled();
            this.detectorEnablementMap.put(detectorName, enabled);
        }
        return enabled;
    }

    public void enableAllDetectors(boolean enable) {
        this.detectorEnablementMap.clear();
        Collection<Plugin> allPlugins = Plugin.getAllPlugins();
        for (Plugin plugin : allPlugins) {
            for (DetectorFactory factory : plugin.getDetectorFactories()) {
                this.detectorEnablementMap.put(factory.getShortName(), enable);
            }
        }
    }

    public void setProjectFilterSettings(ProjectFilterSettings filterSettings) {
        this.filterSettings = filterSettings;
    }

    public ProjectFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public int getUserDetectorThreshold() {
        return this.filterSettings.getMinPriorityAsInt();
    }

    public void setUserDetectorThreshold(int threshold) {
        String minPriority = ProjectFilterSettings.getIntPriorityAsString(threshold);
        this.filterSettings.setMinPriority(minPriority);
    }

    public void setRunAtFullBuild(boolean enable) {
        this.runAtFullBuild = enable;
    }

    public boolean isRunAtFullBuild() {
        return this.runAtFullBuild;
    }

    public void setUserDetectorThreshold(String threshold) {
        this.filterSettings.setMinPriority(threshold);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UserPreferences other = (UserPreferences)obj;
        return this.runAtFullBuild == other.runAtFullBuild && this.recentProjectsList.equals(other.recentProjectsList) && this.detectorEnablementMap.equals(other.detectorEnablementMap) && this.filterSettings.equals(other.filterSettings) && this.effort.equals(other.effort) && this.includeFilterFiles.equals(other.includeFilterFiles) && this.excludeFilterFiles.equals(other.excludeFilterFiles) && this.excludeBugsFiles.equals(other.excludeBugsFiles) && this.customPlugins.equals(other.customPlugins) && Util.nullSafeEquals(this.cloudId, other.cloudId);
    }

    public int hashCode() {
        return this.recentProjectsList.hashCode() + this.detectorEnablementMap.hashCode() + this.filterSettings.hashCode() + this.effort.hashCode() + this.includeFilterFiles.hashCode() + this.excludeFilterFiles.hashCode() + (this.runAtFullBuild ? 1 : 0) + Util.nullSafeHashcode(this.cloudId);
    }

    public UserPreferences clone() {
        try {
            UserPreferences dup = (UserPreferences)super.clone();
            dup.recentProjectsList = new LinkedList<String>(this.recentProjectsList);
            dup.detectorEnablementMap = new HashMap<String, Boolean>(this.detectorEnablementMap);
            dup.filterSettings = (ProjectFilterSettings)this.filterSettings.clone();
            dup.includeFilterFiles = new TreeMap<String, Boolean>(this.includeFilterFiles);
            dup.excludeFilterFiles = new TreeMap<String, Boolean>(this.excludeFilterFiles);
            dup.excludeBugsFiles = new TreeMap<String, Boolean>(this.excludeBugsFiles);
            dup.customPlugins = new TreeMap<String, Boolean>(this.customPlugins);
            return dup;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        if (!(EFFORT_MIN.equals(effort) || EFFORT_DEFAULT.equals(effort) || EFFORT_MAX.equals(effort))) {
            throw new IllegalArgumentException("Effort \"" + effort + "\" is not a valid effort value.");
        }
        this.effort = effort;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public Map<String, Boolean> getIncludeFilterFiles() {
        return this.includeFilterFiles;
    }

    public void setIncludeFilterFiles(Map<String, Boolean> includeFilterFiles) {
        if (includeFilterFiles == null) {
            throw new IllegalArgumentException("includeFilterFiles may not be null.");
        }
        this.includeFilterFiles = includeFilterFiles;
    }

    public Map<String, Boolean> getExcludeBugsFiles() {
        return this.excludeBugsFiles;
    }

    public void setExcludeBugsFiles(Map<String, Boolean> excludeBugsFiles) {
        if (excludeBugsFiles == null) {
            throw new IllegalArgumentException("excludeBugsFiles may not be null.");
        }
        this.excludeBugsFiles = excludeBugsFiles;
    }

    public void setExcludeFilterFiles(Map<String, Boolean> excludeFilterFiles) {
        if (excludeFilterFiles == null) {
            throw new IllegalArgumentException("excludeFilterFiles may not be null.");
        }
        this.excludeFilterFiles = excludeFilterFiles;
    }

    public Map<String, Boolean> getExcludeFilterFiles() {
        return this.excludeFilterFiles;
    }

    public void setCustomPlugins(Map<String, Boolean> customPlugins) {
        if (customPlugins == null) {
            throw new IllegalArgumentException("customPlugins may not be null.");
        }
        this.customPlugins = customPlugins;
    }

    public Map<String, Boolean> getCustomPlugins() {
        return this.customPlugins;
    }

    public Set<String> getCustomPlugins(boolean enabled) {
        Set<Map.Entry<String, Boolean>> entrySet = this.customPlugins.entrySet();
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            if (enabled) {
                if (entry.getValue() == null || !entry.getValue().booleanValue()) continue;
                result.add(entry.getKey());
                continue;
            }
            if (entry.getValue() != null && entry.getValue().booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private static Map<String, Boolean> readProperties(Properties props, String keyPrefix) {
        TreeMap<String, Boolean> filters = new TreeMap<String, Boolean>();
        int counter = 0;
        boolean keyFound = true;
        while (keyFound) {
            String property = props.getProperty(keyPrefix + counter);
            if (property != null) {
                int pipePos = property.indexOf(124);
                if (pipePos >= 0) {
                    String name = property.substring(0, pipePos);
                    String enabled = property.substring(pipePos + 1);
                    filters.put(name, Boolean.valueOf(enabled));
                } else {
                    filters.put(property, Boolean.TRUE);
                }
                ++counter;
                continue;
            }
            keyFound = false;
        }
        return filters;
    }

    private static void writeProperties(Properties props, String keyPrefix, Map<String, Boolean> filters) {
        int counter = 0;
        Set<Map.Entry<String, Boolean>> entrySet = filters.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            props.setProperty(keyPrefix + counter, entry.getKey() + '|' + entry.getValue());
            ++counter;
        }
        boolean keyFound = true;
        while (keyFound) {
            String key = keyPrefix + counter;
            String property = props.getProperty(key);
            if (property == null) {
                keyFound = false;
                continue;
            }
            props.remove(key);
        }
    }

    public AnalysisFeatureSetting[] getAnalysisFeatureSettings() {
        if (this.effort.equals(EFFORT_DEFAULT)) {
            return FindBugs.DEFAULT_EFFORT;
        }
        if (this.effort.equals(EFFORT_MIN)) {
            return FindBugs.MIN_EFFORT;
        }
        return FindBugs.MAX_EFFORT;
    }
}

