/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import javax.annotation.CheckForNull;

public class CheckReturnValueAnnotation
extends AnnotationEnumeration<CheckReturnValueAnnotation> {
    final int priority;
    final String pattern;
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_UNKNOWN = new CheckReturnValueAnnotation("UnknownCheckReturnValue", 0, 4);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_HIGH = new CheckReturnValueAnnotation("CheckReturnValueHigh", 1, 1);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_MEDIUM = new CheckReturnValueAnnotation("CheckReturnValue", 2, 2);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_LOW = new CheckReturnValueAnnotation("CheckReturnValueLow", 3, 3);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_IGNORE = new CheckReturnValueAnnotation("OkToIgnoreReturnValue", 4, 5);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_VERY_HIGH = new CheckReturnValueAnnotation("CheckReturnValueVeryHigh", 5, 0);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_LOW_BAD_PRACTICE = new CheckReturnValueAnnotation("CheckReturnValueLowBadPractice", 6, "RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", 3);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE = new CheckReturnValueAnnotation("CheckReturnValueMediumBadPractice", 7, "RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", 2);
    public static final CheckReturnValueAnnotation CHECK_RETURN_VALUE_INFERRED = new CheckReturnValueAnnotation("CheckReturnValueInferred", 8, "RV_RETURN_VALUE_IGNORED_INFERRED", 2);
    private static final CheckReturnValueAnnotation[] myValues = new CheckReturnValueAnnotation[]{CHECK_RETURN_VALUE_UNKNOWN, CHECK_RETURN_VALUE_HIGH, CHECK_RETURN_VALUE_MEDIUM, CHECK_RETURN_VALUE_LOW, CHECK_RETURN_VALUE_IGNORE, CHECK_RETURN_VALUE_VERY_HIGH, CHECK_RETURN_VALUE_LOW_BAD_PRACTICE, CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE, CHECK_RETURN_VALUE_INFERRED};

    @CheckForNull
    public static CheckReturnValueAnnotation parse(String priority) {
        if (priority == null) {
            return CHECK_RETURN_VALUE_MEDIUM;
        }
        if (priority.endsWith("HIGH")) {
            return CHECK_RETURN_VALUE_HIGH;
        }
        if (priority.endsWith("MEDIUM")) {
            return CHECK_RETURN_VALUE_MEDIUM;
        }
        if (priority.endsWith("LOW")) {
            return CHECK_RETURN_VALUE_LOW;
        }
        throw new IllegalArgumentException("Bad priority: " + priority);
    }

    public static CheckReturnValueAnnotation[] values() {
        return (CheckReturnValueAnnotation[])myValues.clone();
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPattern() {
        return this.pattern;
    }

    private CheckReturnValueAnnotation(String s, int i, int p) {
        super(s, i);
        this.pattern = "RV_RETURN_VALUE_IGNORED";
        this.priority = p;
    }

    private CheckReturnValueAnnotation(String s, int i, String pattern, int p) {
        super(s, i);
        this.pattern = pattern;
        this.priority = p;
    }
}

