/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractClassMember;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;

public abstract class AbstractMethod
extends AbstractClassMember
implements XMethod {
    protected AbstractMethod(@DottedClassName String className, String methodName, String methodSig, int accessFlags) {
        super(className, methodName, methodSig, accessFlags);
    }

    @Override
    public int getNumParams() {
        return new SignatureParser(this.getSignature()).getNumParameters();
    }

    @Override
    public boolean isNative() {
        return (this.getAccessFlags() & 0x100) != 0;
    }

    @Override
    public boolean isSynchronized() {
        return (this.getAccessFlags() & 0x20) != 0;
    }

    @Override
    public String toString() {
        return SignatureConverter.convertMethodSignature(this);
    }

    @Override
    public MethodDescriptor getMethodDescriptor() {
        return DescriptorFactory.instance().getMethodDescriptor(ClassName.toSlashedClassName(this.getClassName()), this.getName(), this.getSignature(), this.isStatic());
    }

    @Override
    public XMethod resolveAccessMethodForMethod() {
        MethodDescriptor access = this.getAccessMethodForMethod();
        if (access != null) {
            return XFactory.createXMethod(access);
        }
        return this;
    }
}

