/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.ComponentPlugin;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugsMain;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.IAnalysisEngineRegistrar;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Plugin {
    private static final String USE_FINDBUGS_VERSION = "USE_FINDBUGS_VERSION";
    static Map<URI, Plugin> allPlugins = new LinkedHashMap<URI, Plugin>();
    private final String pluginId;
    private final String version;
    private final Date releaseDate;
    private String provider;
    private URI website;
    @CheckForNull
    private URI updateUrl;
    private String shortDescription;
    private String detailedDescription;
    private final ArrayList<DetectorFactory> detectorFactoryList;
    private final Map<String, FindBugsMain> mainPlugins;
    private final LinkedHashSet<BugPattern> bugPatterns;
    private final LinkedHashSet<BugCode> bugCodeList;
    private final LinkedHashMap<String, BugCategory> bugCategories;
    private final LinkedHashSet<CloudPlugin> cloudList;
    private final HashMap<String, String> myGlobalOptions;
    private final DualKeyHashMap<Class<?>, String, ComponentPlugin<?>> componentPlugins;
    private BugRanker bugRanker;
    private final ArrayList<DetectorOrderingConstraint> interPassConstraintList;
    private final ArrayList<DetectorOrderingConstraint> intraPassConstraintList;
    private Class<? extends IAnalysisEngineRegistrar> engineRegistrarClass;
    private final PluginLoader pluginLoader;
    private final boolean enabledByDefault;
    private final boolean cannotDisable;
    private EnabledState enabled;

    public Plugin(String pluginId, String version, Date releaseDate, @Nonnull PluginLoader pluginLoader, boolean enabled, boolean cannotDisable) {
        this.pluginId = pluginId;
        if (version == null) {
            version = "";
        } else if (version.equals(USE_FINDBUGS_VERSION)) {
            version = Version.COMPUTED_RELEASE;
            releaseDate = Version.getReleaseDate();
        }
        assert (enabled || !cannotDisable);
        this.myGlobalOptions = new HashMap();
        this.cloudList = new LinkedHashSet();
        this.componentPlugins = new DualKeyHashMap();
        this.version = version;
        this.releaseDate = releaseDate;
        this.detectorFactoryList = new ArrayList();
        this.bugPatterns = new LinkedHashSet();
        this.bugCodeList = new LinkedHashSet();
        this.bugCategories = new LinkedHashMap();
        this.interPassConstraintList = new ArrayList();
        this.intraPassConstraintList = new ArrayList();
        this.mainPlugins = new HashMap<String, FindBugsMain>();
        this.pluginLoader = pluginLoader;
        this.enabledByDefault = enabled;
        this.cannotDisable = cannotDisable;
        this.enabled = EnabledState.PLUGIN_DEFAULT;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.pluginId;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    @CheckForNull
    public String getProvider() {
        return this.provider;
    }

    public void setUpdateUrl(String url) throws URISyntaxException {
        this.updateUrl = new URI(url);
    }

    @CheckForNull
    public URI getUpdateUrl() {
        return this.updateUrl;
    }

    public void setMyGlobalOption(String key, String value) {
        this.myGlobalOptions.put(key, value);
    }

    Map<String, String> getMyGlobalOptions() {
        return Collections.unmodifiableMap(this.myGlobalOptions);
    }

    public void setWebsite(String website) throws URISyntaxException {
        this.website = new URI(website);
    }

    @CheckForNull
    public String getWebsite() {
        if (this.website == null) {
            return null;
        }
        return this.website.toASCIIString();
    }

    @CheckForNull
    public URI getWebsiteURI() {
        return this.website;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public void setDetailedDescription(String detailedDescription) {
        this.detailedDescription = detailedDescription;
    }

    public void addDetectorFactory(DetectorFactory factory) {
        this.detectorFactoryList.add(factory);
    }

    public void addCloudPlugin(CloudPlugin cloudPlugin) {
        this.cloudList.add(cloudPlugin);
    }

    public void addBugPattern(BugPattern bugPattern) {
        this.bugPatterns.add(bugPattern);
    }

    public void addBugCode(BugCode bugCode) {
        this.bugCodeList.add(bugCode);
    }

    public void addBugCategory(BugCategory bugCategory) {
        BugCategory old = this.bugCategories.get(bugCategory.getCategory());
        if (old != null) {
            throw new IllegalArgumentException("Category already exists");
        }
        this.bugCategories.put(bugCategory.getCategory(), bugCategory);
    }

    public BugCategory addOrCreateBugCategory(String id) {
        BugCategory c = this.bugCategories.get(id);
        if (c != null) {
            return c;
        }
        c = new BugCategory(id);
        this.bugCategories.put(id, c);
        return c;
    }

    public void addInterPassOrderingConstraint(DetectorOrderingConstraint constraint) {
        this.interPassConstraintList.add(constraint);
    }

    public void addIntraPassOrderingConstraint(DetectorOrderingConstraint constraint) {
        this.intraPassConstraintList.add(constraint);
    }

    public DetectorFactory getFactoryByShortName(final String shortName) {
        return this.findFirstMatchingFactory(new FactoryChooser(){

            @Override
            public boolean choose(DetectorFactory factory) {
                return factory.getShortName().equals(shortName);
            }
        });
    }

    public DetectorFactory getFactoryByFullName(final String fullName) {
        return this.findFirstMatchingFactory(new FactoryChooser(){

            @Override
            public boolean choose(DetectorFactory factory) {
                return factory.getFullName().equals(fullName);
            }
        });
    }

    public Collection<DetectorFactory> getDetectorFactories() {
        return this.detectorFactoryList;
    }

    public Set<BugPattern> getBugPatterns() {
        return this.bugPatterns;
    }

    public Set<BugCode> getBugCodes() {
        return this.bugCodeList;
    }

    public Collection<BugCategory> getBugCategories() {
        return this.bugCategories.values();
    }

    @CheckForNull
    public BugCategory getBugCategory(String id) {
        return this.bugCategories.get(id);
    }

    public Set<CloudPlugin> getCloudPlugins() {
        return this.cloudList;
    }

    public Iterator<DetectorOrderingConstraint> interPassConstraintIterator() {
        return this.interPassConstraintList.iterator();
    }

    public Iterator<DetectorOrderingConstraint> intraPassConstraintIterator() {
        return this.intraPassConstraintList.iterator();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getShortPluginId() {
        int i = this.pluginId.lastIndexOf(46);
        return this.pluginId.substring(i + 1);
    }

    public void setEngineRegistrarClass(Class<? extends IAnalysisEngineRegistrar> engineRegistrarClass) {
        this.engineRegistrarClass = engineRegistrarClass;
    }

    public Class<? extends IAnalysisEngineRegistrar> getEngineRegistrarClass() {
        return this.engineRegistrarClass;
    }

    public PluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    @CheckForNull
    private DetectorFactory findFirstMatchingFactory(FactoryChooser chooser) {
        for (DetectorFactory factory : this.getDetectorFactories()) {
            if (!chooser.choose(factory)) continue;
            return factory;
        }
        return null;
    }

    public void setBugRanker(BugRanker ranker) {
        this.bugRanker = ranker;
    }

    public BugRanker getBugRanker() {
        return this.bugRanker;
    }

    <T> void addFindBugsMain(Class<?> mainClass, String cmd, String description, String kind, boolean analysis) throws SecurityException, NoSuchMethodException {
        FindBugsMain main = new FindBugsMain(mainClass, cmd, description, kind, analysis);
        this.mainPlugins.put(cmd, main);
    }

    @CheckForNull
    public FindBugsMain getFindBugsMain(String cmd) {
        return this.mainPlugins.get(cmd);
    }

    public Collection<FindBugsMain> getAllFindBugsMain() {
        return this.mainPlugins.values();
    }

    <T> void addComponentPlugin(Class<T> componentKind, ComponentPlugin<T> plugin) {
        Class<T> componentClass = plugin.getComponentClass();
        if (componentClass != null && !componentKind.isAssignableFrom(componentClass)) {
            throw new IllegalArgumentException();
        }
        this.componentPlugins.put(componentKind, plugin.getId(), plugin);
    }

    public <T> Iterable<ComponentPlugin<T>> getComponentPlugins(Class<T> componentClass) {
        Collection<ComponentPlugin<T>> values = this.componentPlugins.get(componentClass).values();
        return values;
    }

    public <T> ComponentPlugin<T> getComponentPlugin(Class<T> componentClass, String name) {
        return this.componentPlugins.get(componentClass, name);
    }

    @CheckForNull
    public static synchronized Plugin getByPluginId(String name) {
        if (name == null) {
            return null;
        }
        for (Plugin plugin : allPlugins.values()) {
            if (!name.equals(plugin.getPluginId())) continue;
            return plugin;
        }
        return null;
    }

    public static synchronized void removePlugin(URI uri) {
        allPlugins.remove(uri);
    }

    public static synchronized Collection<Plugin> getAllPlugins() {
        return new ArrayList<Plugin>(allPlugins.values());
    }

    public static synchronized Collection<String> getAllPluginIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (Plugin p : allPlugins.values()) {
            result.add(p.getPluginId());
        }
        return result;
    }

    public static synchronized Map<URI, Plugin> getAllPluginsMap() {
        return new LinkedHashMap<URI, Plugin>(allPlugins);
    }

    public static synchronized Set<URI> getAllPluginsURIs() {
        Collection<Plugin> plugins = Plugin.getAllPlugins();
        HashSet<URI> uris = new HashSet<URI>();
        for (Plugin plugin : plugins) {
            try {
                URI uri = plugin.getPluginLoader().getURL().toURI();
                uris.add(uri);
            }
            catch (URISyntaxException e) {
                AnalysisContext.logError("Unable to get URI", e);
            }
        }
        return uris;
    }

    @CheckForNull
    static synchronized Plugin getPlugin(URI uri) {
        return allPlugins.get(uri);
    }

    @CheckForNull
    static synchronized Plugin putPlugin(URI uri, Plugin plugin) {
        return allPlugins.put(uri, plugin);
    }

    public boolean isCorePlugin() {
        return this.pluginLoader.isCorePlugin();
    }

    public boolean cannotDisable() {
        return this.cannotDisable;
    }

    public boolean isGloballyEnabled() {
        if (this.isCorePlugin()) {
            return true;
        }
        switch (this.enabled) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
            case PLUGIN_DEFAULT: {
                return this.isEnabledByDefault();
            }
        }
        throw new IllegalStateException("Unknown state : " + (Object)((Object)this.enabled));
    }

    public void setGloballyEnabled(boolean enabled) {
        if (this.isCorePlugin()) {
            if (!enabled) {
                throw new IllegalArgumentException("Can't disable core plugin");
            }
            return;
        }
        if (this.cannotDisable) {
            if (enabled) {
                return;
            }
            throw new IllegalArgumentException("Cannot disable " + this.pluginId);
        }
        this.enabled = enabled ? (this.isEnabledByDefault() ? EnabledState.PLUGIN_DEFAULT : EnabledState.ENABLED) : (this.isEnabledByDefault() ? EnabledState.DISABLED : EnabledState.PLUGIN_DEFAULT);
    }

    public boolean isInitialPlugin() {
        return this.getPluginLoader().initialPlugin;
    }

    public URL getResource(String name) {
        return this.getPluginLoader().getResource(name);
    }

    public ClassLoader getClassLoader() {
        return this.getPluginLoader().getClassLoader();
    }

    @CheckForNull
    public Plugin getParentPlugin() {
        if (this.getPluginLoader().hasParent()) {
            return Plugin.getByPluginId(this.getPluginLoader().parentId);
        }
        return null;
    }

    public static Plugin loadCustomPlugin(File f, @CheckForNull Project project) throws PluginException {
        URL urlString;
        try {
            urlString = f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return Plugin.loadCustomPlugin(urlString, project);
    }

    public static Plugin loadCustomPlugin(URL urlString, @CheckForNull Project project) throws PluginException {
        Plugin plugin = Plugin.addCustomPlugin(urlString);
        if (project != null) {
            project.setPluginStatusTrinary(plugin.getPluginId(), true);
        }
        return plugin;
    }

    @CheckForNull
    public static Plugin addCustomPlugin(URL u) throws PluginException {
        return Plugin.addCustomPlugin(u, PluginLoader.class.getClassLoader());
    }

    @CheckForNull
    public static Plugin addCustomPlugin(URI u) throws PluginException {
        return Plugin.addCustomPlugin(u, PluginLoader.class.getClassLoader());
    }

    @CheckForNull
    public static Plugin addCustomPlugin(URL u, ClassLoader parent) throws PluginException {
        PluginLoader pluginLoader = PluginLoader.getPluginLoader(u, parent, false, true);
        Plugin plugin = pluginLoader.loadPlugin();
        if (plugin != null) {
            DetectorFactoryCollection.instance().loadPlugin(plugin);
        }
        return plugin;
    }

    @CheckForNull
    public static Plugin addCustomPlugin(URI u, ClassLoader parent) throws PluginException {
        URL url;
        try {
            url = u.toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginException("Unable to convert uri to url:" + u, e);
        }
        return Plugin.addCustomPlugin(url, parent);
    }

    public static synchronized void removeCustomPlugin(Plugin plugin) {
        Set<Map.Entry<URI, Plugin>> entrySet = allPlugins.entrySet();
        for (Map.Entry<URI, Plugin> entry : entrySet) {
            if (entry.getValue() != plugin) continue;
            allPlugins.remove(entry.getKey());
            PluginLoader.loadedPluginIds.remove(plugin.getPluginId());
            break;
        }
        DetectorFactoryCollection.instance().unLoadPlugin(plugin);
    }

    private static interface FactoryChooser {
        public boolean choose(DetectorFactory var1);
    }

    static enum EnabledState {
        PLUGIN_DEFAULT,
        ENABLED,
        DISABLED;

    }
}

