/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static void no_op() {
    }

    public static int compare(long v1, long v2) {
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public static int compare(double v1, double v2) {
        return Double.compare(v1, v2);
    }

    public static int compareIgnoreCase(@Nullable String s1, @Nullable String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static boolean equalsNullable(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void parseKeyValuePair(@NotNull HashMap<String, String> key2value, @NotNull String keyAndValue) {
        if (key2value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (keyAndValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int idx = keyAndValue.indexOf(61);
        if (idx == -1) {
            return;
        }
        String key = keyAndValue.substring(0, idx);
        String value = keyAndValue.substring(idx + 1);
        key2value.put(key, value);
    }

    public static int minInt(int a, long b) {
        return (int)Math.min((long)a, b);
    }

    public static int minInt(long a, int b) {
        return (int)Math.min(a, (long)b);
    }

    @NotNull
    public static String getStackTrace(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder();
        Util.printStackTrace(result, e);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private static void printStackTrace(@NotNull StringBuilder result, @NotNull Throwable e) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        result.append(e.toString());
        result.append('\n');
        StackTraceElement[] trace = e.getStackTrace();
        Util.printStackTraceElementArray(result, trace, 0);
        Throwable cause = e.getCause();
        if (cause != null) {
            Util.printStackTraceAsCause(result, cause, trace);
        }
    }

    public static void printStackTraceElementArray(@NotNull StringBuilder result, @NotNull StackTraceElement[] trace, int elementsToSkip) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (trace == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        for (int i = elementsToSkip; i < trace.length; ++i) {
            result.append("\tat ");
            result.append(trace[i].toString());
            result.append('\n');
        }
    }

    private static void printStackTraceAsCause(@NotNull StringBuilder result, @NotNull Throwable e, @NotNull StackTraceElement[] causedTrace) {
        Throwable ourCause;
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (causedTrace == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        StackTraceElement[] trace = e.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        result.append("Caused by: ");
        result.append(e.toString());
        result.append('\n');
        for (int i = 0; i <= m; ++i) {
            result.append("\tat ");
            result.append(trace[i].toString());
            result.append('\n');
        }
        if (framesInCommon != 0) {
            result.append("\t... ");
            result.append(String.valueOf(framesInCommon));
            result.append(" more");
            result.append('\n');
        }
        if ((ourCause = e.getCause()) != null) {
            Util.printStackTraceAsCause(result, ourCause, trace);
        }
    }
}

