/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.StringTokenizer;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
StackConsumer,
StackProducer {
    private static final long serialVersionUID = 6089031137856650442L;

    InvokeInstruction() {
    }

    protected InvokeInstruction(short opcode, int index) {
        super(opcode, index);
    }

    @Override
    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Constants.OPCODE_NAMES[this.opcode] + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    @Override
    public int consumeStack(ConstantPoolGen cpg) {
        int sum = this.opcode == 184 ? 0 : 1;
        String signature = this.getSignature(cpg);
        return sum += Type.getArgumentTypesSize(signature);
    }

    @Override
    public int produceStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        return Type.getReturnTypeSize(signature);
    }

    @Override
    public Type getType(ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public String getMethodName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public Type getReturnType(ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public Type[] getArgumentTypes(ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }

    @Override
    public Class<?>[] getExceptions() {
        return null;
    }

    @Override
    public void accept(Visitor v) {
    }
}

