/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterFactory;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.FilterMatcher;
import edu.umd.cs.findbugs.gui2.GuiUtil;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import edu.umd.cs.findbugs.gui2.Sortables;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class NewFilterFrame
extends FBDialog {
    private final JList<String> list = new JList();
    private static NewFilterFrame instance = null;

    public static void open() {
        if (instance == null) {
            instance = new NewFilterFrame();
            instance.setVisible(true);
            instance.toFront();
        }
    }

    public static void close() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    private NewFilterFrame() {
        super(PreferencesFrame.getInstance());
        this.setContentPane(new JPanel(){

            @Override
            public Insets getInsets() {
                return new Insets(3, 3, 3, 3);
            }
        });
        this.setLayout(new BorderLayout());
        JPanel north = new JPanel();
        north.setLayout(new BoxLayout(north, 0));
        north.add(Box.createHorizontalStrut(3));
        north.add(new JLabel(L10N.getLocalString("dlg.filter_bugs_lbl", "Filter out all bugs whose") + " "));
        Sortables[] sortables = MainFrame.getInstance().getAvailableSortables();
        Sortables[] valuesWithoutDivider = new Sortables[sortables.length - 1];
        int index = 0;
        for (int x = 0; x < sortables.length; ++x) {
            if (sortables[x] == Sortables.DIVIDER) continue;
            valuesWithoutDivider[index] = sortables[x];
            ++index;
        }
        final JComboBox<Sortables> comboBox = new JComboBox<Sortables>(valuesWithoutDivider);
        comboBox.setRenderer(new ListCellRenderer<Sortables>(){
            final Color SELECTED_BACKGROUND = new Color(183, 184, 204);

            @Override
            public Component getListCellRendererComponent(JList<? extends Sortables> list, Sortables value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = new JLabel();
                result.setFont(result.getFont().deriveFont(Driver.getFontSize()));
                result.setOpaque(true);
                result.setText(value.toString().toLowerCase());
                if (isSelected) {
                    result.setBackground(this.SELECTED_BACKGROUND);
                }
                return result;
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sortables filterBy = (Sortables)comboBox.getSelectedItem();
                String[] listData = filterBy.getAllSorted();
                for (int i = 0; i < listData.length; ++i) {
                    listData[i] = filterBy.formatValue(listData[i]);
                }
                NewFilterFrame.this.list.setListData(listData);
            }
        });
        comboBox.validate();
        north.add(comboBox);
        north.add(new JLabel(" " + L10N.getLocalString("dlg.is", "is") + " "));
        String[] filterModes = new String[]{L10N.getLocalString("mode.equal_to", "equal to"), L10N.getLocalString("mode.at_or_after", "at or after"), L10N.getLocalString("mode.at_or_before", "at or before")};
        JComboBox<String> filterModeComboBox = new JComboBox<String>(filterModes);
        north.add(filterModeComboBox);
        north.add(new JLabel(":"));
        north.add(Box.createHorizontalGlue());
        JPanel south = new JPanel();
        JButton okButton = new JButton(L10N.getLocalString("dlg.ok_btn", "OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sortables key = (Sortables)comboBox.getSelectedItem();
                String[] values = key.getAllSorted();
                ArrayList<BugAspects.SortableValue> filterMe = new ArrayList<BugAspects.SortableValue>();
                for (int i : NewFilterFrame.this.list.getSelectedIndices()) {
                    filterMe.add(new BugAspects.SortableValue(key, values[i]));
                }
                try {
                    MainFrame.getInstance().getProject().getSuppressionFilter().addChild(FilterFactory.makeOrMatcher(filterMe));
                }
                catch (RuntimeException e) {
                    MainFrame.getInstance().showMessageDialog("Unable to create filter: " + e.getMessage());
                    NewFilterFrame.close();
                    return;
                }
                FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
                PreferencesFrame.getInstance().updateFilterPanel();
                MainFrame.getInstance().setProjectChanged(true);
                NewFilterFrame.close();
            }
        });
        JButton cancelButton = new JButton(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewFilterFrame.close();
            }
        });
        GuiUtil.addOkAndCancelButtons(south, okButton, cancelButton);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    Sortables key = (Sortables)comboBox.getSelectedItem();
                    String[] values = key.getAllSorted();
                    FilterMatcher[] newFilters = new FilterMatcher[NewFilterFrame.this.list.getSelectedIndices().length];
                    for (int i = 0; i < newFilters.length; ++i) {
                        newFilters[i] = new FilterMatcher(key, values[NewFilterFrame.this.list.getSelectedIndices()[i]]);
                    }
                    ProjectSettings.getInstance().addFilters(newFilters);
                    PreferencesFrame.getInstance().updateFilterPanel();
                    NewFilterFrame.close();
                }
            }
        });
        this.add((Component)north, "North");
        this.add(Box.createHorizontalStrut(2), "West");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add(Box.createHorizontalStrut(2), "East");
        this.add((Component)south, "South");
        comboBox.getActionListeners()[0].actionPerformed(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                NewFilterFrame.close();
            }
        });
        this.setTitle(L10N.getLocalString("dlg.create_new_filter_ttl", "Create New Filter"));
        this.pack();
    }

    public static void main(String[] args) {
        new NewFilterFrame().setDefaultCloseOperation(3);
    }
}

