/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class BugRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Color c;
        Component toReturn = super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
        if (!(node instanceof BugLeafNode)) {
            return toReturn;
        }
        BugInstance bug = ((BugLeafNode)node).getBug();
        switch (bug.getPriority()) {
            case 3: {
                c = new Color(0.4f, 0.4f, 0.6f);
                break;
            }
            case 2: {
                if (bug.isDead()) {
                    c = new Color(0.2f, 0.2f, 0.2f);
                    break;
                }
                c = new Color(255, 204, 0);
                break;
            }
            case 1: {
                if (bug.isDead()) {
                    c = new Color(0.65f, 0.2f, 0.2f);
                    break;
                }
                c = new Color(0.85f, 0.0f, 0.0f);
                break;
            }
            default: {
                c = Color.blue;
            }
        }
        if (leaf) {
            Icon icon = new Icon(){

                @Override
                public void paintIcon(Component comp, Graphics g, int x, int y) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(c);
                    g2.fillOval(2, 2, 12, 12);
                    g2.setColor(Color.BLACK);
                    g2.drawOval(2, 2, 12, 12);
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public int getIconHeight() {
                    return 16;
                }
            };
            ((BugRenderer)toReturn).setLeafIcon(icon);
        }
        return toReturn;
    }
}

