/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import org.apache.bcel.classfile.Code;

public class BadUseOfReturnValue
extends BytecodeScanningDetector {
    BugAccumulator bugAccumulator;
    boolean readLineOnTOS = false;
    boolean stringIndexOfOnTOS = false;

    public BadUseOfReturnValue(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        this.stringIndexOfOnTOS = false;
        this.readLineOnTOS = false;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 && this.getNameConstantOperand().equals("indexOf") && this.getClassConstantOperand().equals("java/lang/String") && this.getSigConstantOperand().equals("(Ljava/lang/String;)I")) {
            this.stringIndexOfOnTOS = true;
        } else if (this.stringIndexOfOnTOS) {
            if (seen == 158 || seen == 157) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_CHECK_FOR_POSITIVE_INDEXOF", 3).addClassAndMethod(this), this);
            }
            this.stringIndexOfOnTOS = false;
        }
        if (seen == 182 && this.getNameConstantOperand().equals("readLine") && this.getSigConstantOperand().equals("()Ljava/lang/String;") && this.getClassConstantOperand().startsWith("java/io") && !this.getClassConstantOperand().equals("java/io/LineNumberReader")) {
            this.readLineOnTOS = true;
        } else if (this.readLineOnTOS) {
            if (seen == 198 || seen == 199) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_DONT_JUST_NULL_CHECK_READLINE", 2).addClassAndMethod(this), this);
            }
            this.readLineOnTOS = false;
        }
    }
}

