/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBaseEntry;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class ZipInputStreamCodeBaseEntry
extends AbstractScannableCodeBaseEntry {
    private final ZipInputStreamCodeBase codeBase;
    private final ZipEntry zipEntry;
    private final byte[] bytes;

    public ZipInputStreamCodeBaseEntry(ZipInputStreamCodeBase codeBase, ZipEntry zipEntry, byte[] bytes) {
        this.codeBase = codeBase;
        this.zipEntry = zipEntry;
        this.bytes = bytes;
    }

    @Override
    public int getNumBytes() {
        return (int)this.zipEntry.getSize();
    }

    @Override
    public InputStream openResource() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public AbstractScannableCodeBase getCodeBase() {
        return this.codeBase;
    }

    @Override
    public String getRealResourceName() {
        return this.zipEntry.getName();
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return DescriptorFactory.createClassDescriptorFromResourceName(this.getResourceName());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ZipInputStreamCodeBaseEntry other = (ZipInputStreamCodeBaseEntry)obj;
        return this.codeBase.equals(other.codeBase) && this.zipEntry.equals(other.zipEntry);
    }

    public int hashCode() {
        return 7919 * this.codeBase.hashCode() + this.zipEntry.hashCode();
    }

    public String toString() {
        return this.getCodeBase() + ":" + this.getResourceName();
    }
}

