/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ch;

import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.SupertypeTraversalVisitor;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;

public abstract class OverriddenMethodsVisitor
implements SupertypeTraversalVisitor {
    private final XMethod xmethod;

    public OverriddenMethodsVisitor(XMethod xmethod) {
        assert (!xmethod.isStatic());
        this.xmethod = xmethod;
    }

    public XMethod getXmethod() {
        return this.xmethod;
    }

    @Override
    public boolean visitClass(ClassDescriptor classDescriptor, XClass xclass) {
        assert (xclass != null);
        XMethod bridgedFrom = this.xmethod.bridgeFrom();
        String methodSignature = bridgedFrom != null && !classDescriptor.equals(this.xmethod.getClassDescriptor()) ? bridgedFrom.getSignature() : this.xmethod.getSignature();
        XMethod xm = xclass.findMethod(this.xmethod.getName(), methodSignature, false);
        if (xm == null && bridgedFrom != null && xclass.isInterface()) {
            xm = xclass.findMethod(this.xmethod.getName(), this.xmethod.getSignature(), false);
        }
        if (xm != null) {
            return this.visitOverriddenMethod(xm) || bridgedFrom != null;
        }
        return true;
    }

    protected abstract boolean visitOverriddenMethod(XMethod var1);
}

