/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.apache.bcel.generic.Type;

public class TypeAnnotation
extends BugAnnotationWithSourceLines {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "TYPE_DEFAULT";
    public static final String EXPECTED_ROLE = "TYPE_EXPECTED";
    public static final String FOUND_ROLE = "TYPE_FOUND";
    public static final String CLOSEIT_ROLE = "TYPE_CLOSEIT";
    public static final String UNHASHABLE_ROLE = "TYPE_UNHASHABLE";
    private final String descriptor;
    private String roleDescription;
    private String typeParameters;
    private static final String ELEMENT_NAME = "Type";

    public TypeAnnotation(String typeDescriptor) {
        this(typeDescriptor, DEFAULT_ROLE);
    }

    public TypeAnnotation(Type objectType) {
        this(objectType, DEFAULT_ROLE);
    }

    public TypeAnnotation(Type objectType, String roleDescription) {
        this(objectType.getSignature(), roleDescription);
        GenericObjectType genericObjectType;
        if (objectType instanceof GenericObjectType && (genericObjectType = (GenericObjectType)objectType).getTypeCategory() == GenericUtilities.TypeCategory.PARAMETERIZED) {
            this.typeParameters = genericObjectType.getGenericParametersAsString();
        }
    }

    public TypeAnnotation(String typeDescriptor, String roleDescription) {
        this.descriptor = typeDescriptor;
        this.roleDescription = roleDescription;
        if (this.descriptor.startsWith("L")) {
            String className = typeDescriptor.substring(1, typeDescriptor.length() - 1).replace('/', '.');
            AnalysisContext context = AnalysisContext.currentAnalysisContext();
            if (context != null) {
                this.sourceFileName = context.lookupSourceFile(className);
                this.sourceLines = ClassAnnotation.getSourceLinesForClass(className, this.sourceFileName);
            } else {
                this.sourceFileName = "<Unknown>";
            }
        }
    }

    public String getTypeDescriptor() {
        return this.descriptor;
    }

    @Override
    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitTypeAnnotation(this);
    }

    @Override
    public String format(String key, ClassAnnotation primaryClass) {
        String name = new SignatureConverter(this.descriptor).parseNext().replace("java.lang.", "");
        if (key.equals("givenClass")) {
            name = PackageMemberAnnotation.shorten(primaryClass.getPackageName(), name);
        } else if (key.equals("excludingPackage")) {
            name = PackageMemberAnnotation.removePackage(name);
        }
        if (this.typeParameters != null && !key.equals("hash")) {
            name = name + this.typeParameters;
        }
        return name;
    }

    @Override
    public void setDescription(String roleDescription) {
        this.roleDescription = roleDescription.intern();
    }

    @Override
    public String getDescription() {
        return this.roleDescription;
    }

    public void setTypeParameters(String typeParameters) {
        this.typeParameters = typeParameters;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeAnnotation)) {
            return false;
        }
        return this.descriptor.equals(((TypeAnnotation)o).descriptor);
    }

    @Override
    public int compareTo(BugAnnotation o) {
        if (!(o instanceof TypeAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.descriptor.compareTo(((TypeAnnotation)o).descriptor);
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.roleDescription);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("descriptor", this.descriptor);
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        if (this.typeParameters != null) {
            attributeList.addAttribute("typeParameters", this.typeParameters);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    @Override
    public boolean isSignificant() {
        return true;
    }
}

