/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.JavaClass;

public class EmacsBugReporter
extends TextUIBugReporter {
    private final HashSet<BugInstance> seenAlready = new HashSet();
    private final HashMap<String, String> sourceFileNameCache = new HashMap();

    @Override
    public void observeClass(ClassDescriptor classDescriptor) {
        try {
            JavaClass javaClass = AnalysisContext.currentAnalysisContext().lookupClass(classDescriptor.toDottedClassName());
            String sourceFileName = this.fileNameFor(javaClass.getPackageName(), javaClass.getSourceFileName());
            this.sourceFileNameCache.put(javaClass.getClassName(), sourceFileName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private String fileNameFor(String packageName, String sourceName) {
        String result;
        SourceFinder sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
        try {
            result = sourceFinder.findSourceFile(packageName, sourceName).getFullFileName();
        }
        catch (IOException e) {
            result = packageName.replace('.', File.separatorChar) + File.separatorChar + sourceName;
        }
        return result;
    }

    @Override
    protected void printBug(BugInstance bugInstance) {
        int lineStart = 0;
        int lineEnd = 0;
        String fullPath = "???";
        SourceLineAnnotation line = bugInstance.getPrimarySourceLineAnnotation();
        lineStart = line.getStartLine();
        lineEnd = line.getEndLine();
        SourceFinder sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
        String pkgName = line.getPackageName();
        try {
            fullPath = sourceFinder.findSourceFile(pkgName, line.getSourceFile()).getFullFileName();
        }
        catch (IOException e) {
            fullPath = pkgName.equals("") ? line.getSourceFile() : pkgName.replace('.', '/') + "/" + line.getSourceFile();
        }
        this.outputStream.print(fullPath + ":" + lineStart + ":" + lineEnd + " " + bugInstance.getMessage());
        switch (bugInstance.getPriority()) {
            case 4: {
                this.outputStream.print(" (E) ");
                break;
            }
            case 3: {
                this.outputStream.print(" (L) ");
                break;
            }
            case 2: {
                this.outputStream.print(" (M) ");
                break;
            }
            case 1: {
                this.outputStream.print(" (H) ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid priority " + bugInstance.getPriority() + " for " + bugInstance);
            }
        }
        this.outputStream.println();
    }

    @Override
    protected void doReportBug(BugInstance bugInstance) {
        if (this.seenAlready.add(bugInstance)) {
            this.printBug(bugInstance);
            this.notifyObservers(bugInstance);
        }
    }

    @Override
    public void finish() {
        this.outputStream.close();
    }

    @Override
    @CheckForNull
    public BugCollection getBugCollection() {
        return null;
    }
}

