/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DuplicateClassPrinter;
import proguard.classfile.ClassPool;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.io.ClassFilter;
import proguard.io.ClassReader;
import proguard.io.DataEntryReader;
import proguard.io.DirectoryPump;

public class InputReader {
    private final Configuration configuration;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2;
        if (this.configuration.programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options");
        }
        this.checkInputOutput(this.configuration.libraryJars, this.configuration.programJars);
        this.checkInputOutput(this.configuration.programJars, this.configuration.programJars);
        WarningPrinter warningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter warningPrinter2 = new WarningPrinter(System.out, this.configuration.note);
        DuplicateClassPrinter duplicateClassPrinter = new DuplicateClassPrinter(warningPrinter2);
        this.readInput("Reading program ", this.configuration.programJars, (DataEntryReader)new ClassFilter(new ClassReader(false, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter, new ClassPresenceFilter(classPool, duplicateClassPrinter, new ClassPoolFiller(classPool)))));
        if (classPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFilter(new ClassReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter, new ClassPresenceFilter(classPool, duplicateClassPrinter, new ClassPresenceFilter(classPool2, duplicateClassPrinter, new ClassPoolFiller(classPool2))))));
        }
        if ((n2 = warningPrinter2.getWarningCount()) > 0) {
            System.err.println("Note: there were " + n2 + " duplicate class definitions.");
            System.err.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#duplicateclass)");
        }
        if ((n = warningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " classes in incorrectly named files.");
            System.err.println("         You should make sure all file names correspond to their class names.");
            System.err.println("         The directory hierarchies must correspond to the package hierarchies.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unexpectedclass)");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you don't mind the mentioned classes not being written out,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }

    private void checkInputOutput(ClassPath classPath, ClassPath classPath2) throws IOException {
        if (classPath == null || classPath2 == null) {
            return;
        }
        for (int i = 0; i < classPath.size(); ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            for (int j = 0; j < classPath2.size(); ++j) {
                ClassPathEntry classPathEntry2 = classPath2.get(j);
                if (!classPathEntry2.isOutput() || !classPathEntry2.getName().equals(classPathEntry.getName())) continue;
                throw new IOException("Input jars and output jars must be different [" + classPathEntry.getName() + "]");
            }
        }
    }

    private void readInput(String string, ClassPath classPath, DataEntryReader dataEntryReader) throws IOException {
        this.readInput(string, classPath, 0, classPath.size(), dataEntryReader);
    }

    public void readInput(String string, ClassPath classPath, int n, int n2, DataEntryReader dataEntryReader) throws IOException {
        for (int i = n; i < n2; ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            this.readInput(string, classPathEntry, dataEntryReader);
        }
    }

    private void readInput(String string, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader dataEntryReader2 = DataEntryReaderFactory.createDataEntryReader(string, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(classPathEntry.getFile());
            directoryPump.pumpDataEntries(dataEntryReader2);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Can't read [" + classPathEntry + "] (" + iOException.getMessage() + ")").initCause(iOException);
        }
    }
}

