/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapChooser
extends JComponent
implements DownloadSelection {
    private static final int MAX_ZOOMLEVEL = 20;
    private static final int MIN_ZOOMLEVEL = 1;
    private TileDB iTileDB;
    private DownloadDialog iGui;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;
    int iOffsetX = 0;
    int iOffsetY = 0;
    static int iZoomlevel = 3;
    private boolean iFirstPaint = true;
    private LatLon iFirstPaintCenter = new LatLon(51.0, 7.0);
    private SizeButton iSizeButton = new SizeButton();
    private Dimension iDownloadDialogDimension;
    private Dimension iScreenSize;
    private LatLon iScreenCenterBeforeResize;
    private LatLon iSelectionStartBeforeResize;
    private LatLon iSelectionEndBeforeResize;
    private boolean isJustResized = false;
    private int iVisibleTilesX = 2;
    private int iVisibleTilesY = 3;

    public SlippyMapChooser() {
        this.iTileDB = new TileDB(this);
        this.setMinimumSize(new Dimension(350, 175));
    }

    public void addGui(DownloadDialog downloadDialog) {
        this.iGui = downloadDialog;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this, "Center");
        jPanel.add((Component)new JLabel(I18n.tr((String)"Zoom: Mousewheel or double click.   Move map: Hold right mousebutton and move mouse.")), "South");
        this.iGui.tabpane.add((Component)jPanel, "Slippy map");
        new OsmMapControl(this, jPanel, this.iSizeButton);
        this.repaint();
    }

    public void resizeSlippyMap() {
        Dimension dimension;
        Container container;
        if (this.iScreenSize == null) {
            container = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent();
            this.iDownloadDialogDimension = container.getSize();
            this.iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        this.iScreenCenterBeforeResize = this.getLatLonOfScreenPoint(new Point(this.getWidth() / 2, this.getHeight() / 2));
        if (this.iSelectionRectEnd != null && this.iSelectionRectStart != null) {
            this.iSelectionStartBeforeResize = this.getLatLonOfScreenPoint(this.iSelectionRectStart);
            this.iSelectionEndBeforeResize = this.getLatLonOfScreenPoint(this.iSelectionRectEnd);
        }
        if ((dimension = (container = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent()).getSize()).equals(this.iDownloadDialogDimension)) {
            int n = this.iScreenSize.width * 90 / 100;
            int n2 = this.iScreenSize.height * 90 / 100;
            container.setBounds((this.iScreenSize.width - n) / 2, (this.iScreenSize.height - n2) / 2, n, n2);
        } else {
            int n = this.iDownloadDialogDimension.width;
            int n3 = this.iDownloadDialogDimension.height;
            container.setBounds((this.iScreenSize.width - n) / 2, (this.iScreenSize.height - n3) / 2, n, n3);
        }
        this.isJustResized = true;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.iFirstPaint) {
            this.calcVisibleTiles();
            LatLon latLon = null;
            LatLon latLon2 = null;
            if (this.iSelectionRectEnd != null && this.iSelectionRectStart != null) {
                latLon = this.getLatLonOfScreenPoint(this.iSelectionRectStart);
                latLon2 = this.getLatLonOfScreenPoint(this.iSelectionRectEnd);
            }
            this.centerOnLatLon(this.iFirstPaintCenter);
            if (latLon != null && latLon2 != null) {
                this.iSelectionRectStart = this.getScreenPointForLatLon(latLon);
                this.iSelectionRectEnd = this.getScreenPointForLatLon(latLon2);
            }
            this.loadVisibleTiles();
            this.iFirstPaint = false;
            this.repaint();
        }
        if (this.isJustResized) {
            this.centerOnLatLon(this.iScreenCenterBeforeResize);
            if (this.iSelectionEndBeforeResize != null && this.iSelectionStartBeforeResize != null) {
                this.iSelectionRectStart = this.getScreenPointForLatLon(this.iSelectionStartBeforeResize);
                this.iSelectionRectEnd = this.getScreenPointForLatLon(this.iSelectionEndBeforeResize);
            }
            this.calcVisibleTiles();
            this.loadVisibleTiles();
            this.isJustResized = false;
        }
        graphics.translate(this.iOffsetX, this.iOffsetY);
        for (int i = 0; i < this.iVisibleTilesY; ++i) {
            for (int j = 0; j < this.iVisibleTilesX; ++j) {
                OsmTile osmTile = this.iTileDB.get(OsmTile.key(iZoomlevel, (-this.iOffsetX + j * 256) / 256, (-this.iOffsetY + i * 256) / 256));
                if (osmTile == null) continue;
                osmTile.paint(graphics, this.iTileDB);
            }
        }
        graphics.translate(-this.iOffsetX, -this.iOffsetY);
        if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
            graphics.setColor(Color.black);
            graphics.drawRect(this.iSelectionRectStart.x, this.iSelectionRectStart.y, this.iSelectionRectEnd.x - this.iSelectionRectStart.x, this.iSelectionRectEnd.y - this.iSelectionRectStart.y);
            graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
            graphics.fillRect(this.iSelectionRectStart.x + 1, this.iSelectionRectStart.y + 1, this.iSelectionRectEnd.x - this.iSelectionRectStart.x - 1, this.iSelectionRectEnd.y - this.iSelectionRectStart.y - 1);
        }
        this.iSizeButton.paint(graphics);
        if (SlippyMapChooserPlugin.DEBUG_MODE) {
            graphics.setColor(Color.black);
            graphics.drawString("Free Memory: " + Runtime.getRuntime().freeMemory() / 1024L + "/" + Runtime.getRuntime().totalMemory() / 1024L + "kB", 5, 50);
            graphics.drawString("Tiles in DB: " + this.iTileDB.getCachedTilesSize(), 5, 65);
            graphics.drawString("Loading Queue Size: " + this.iTileDB.getLoadingQueueSize(), 5, 80);
        }
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        int n = OsmMercator.LonToX(downloadDialog.minlon, iZoomlevel);
        int n2 = OsmMercator.LonToX(downloadDialog.maxlon, iZoomlevel);
        int n3 = OsmMercator.LatToY(downloadDialog.minlat, iZoomlevel);
        int n4 = OsmMercator.LatToY(downloadDialog.maxlat, iZoomlevel);
        this.iSelectionRectStart = new Point(Math.min(n, n2) + this.iOffsetX, Math.min(n3, n4) + this.iOffsetY);
        this.iSelectionRectEnd = new Point(Math.max(n, n2) + this.iOffsetX, Math.max(n3, n4) + this.iOffsetY);
        double d = Math.abs(downloadDialog.maxlat - downloadDialog.minlat);
        double d2 = Math.abs(downloadDialog.maxlon - downloadDialog.minlon);
        int n5 = (int)(Math.log(90.0 / d) / Math.log(2.0));
        int n6 = (int)(Math.log(90.0 / d2) / Math.log(2.0));
        iZoomlevel = Math.max(n5, n6);
        if (downloadDialog.minlat != 0.0 && downloadDialog.maxlat != 0.0 && downloadDialog.minlon != 0.0 && downloadDialog.maxlat != 0.0) {
            this.iFirstPaintCenter = new LatLon((downloadDialog.minlat + downloadDialog.maxlat) / 2.0, (downloadDialog.minlon + downloadDialog.maxlon) / 2.0);
            this.iFirstPaint = true;
        }
        this.repaint();
    }

    void loadVisibleTiles() {
        for (int i = this.iVisibleTilesY - 1; i >= 0; --i) {
            for (int j = 0; j < this.iVisibleTilesX; ++j) {
                if (i > 0 && i < this.iVisibleTilesX - 2) {
                    this.iTileDB.loadTile(iZoomlevel, (-this.iOffsetX + j * 256) / 256, (-this.iOffsetY + i * 256) / 256, 1);
                    continue;
                }
                this.iTileDB.loadTile(iZoomlevel, (-this.iOffsetX + j * 256) / 256, (-this.iOffsetY + i * 256) / 256, 2);
            }
        }
    }

    void setSelection(Point point, Point point2) {
        if (point == null || point2 == null) {
            return;
        }
        this.iSelectionRectEnd = new Point(Math.max(point2.x, point.x), Math.max(point2.y, point.y));
        this.iSelectionRectStart = new Point(Math.min(point2.x, point.x), Math.min(point2.y, point.y));
        LatLon latLon = this.getLatLonOfScreenPoint(point);
        LatLon latLon2 = this.getLatLonOfScreenPoint(point2);
        this.iGui.minlat = Math.min(latLon.lat(), latLon2.lat());
        this.iGui.minlon = Math.min(latLon.lon(), latLon2.lon());
        this.iGui.maxlat = Math.max(latLon.lat(), latLon2.lat());
        this.iGui.maxlon = Math.max(latLon.lon(), latLon2.lon());
        this.iGui.boundingBoxChanged((DownloadSelection)this);
        this.repaint();
    }

    void moveMap(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.iOffsetX - n;
        int n6 = this.iOffsetY - n2;
        int n7 = OsmMercator.getMaxPixels(iZoomlevel);
        if (n3 != 0) {
            if (n7 < this.getWidth()) {
                this.iOffsetX = (this.getWidth() - n7) / 2;
                n3 = 0;
            } else if (n5 > 30) {
                if (n3 < 0) {
                    n3 = 0;
                    this.iOffsetX = 30;
                }
            } else if (-n5 > n7 + 30 - this.getWidth() && n3 > 0) {
                n3 = 0;
                this.iOffsetX = -(n7 + 30 - this.getWidth());
            }
        }
        if (n4 != 0) {
            if (n7 < this.getHeight()) {
                this.iOffsetY = (this.getHeight() - n7) / 2;
                n4 = 0;
            } else if (n6 > 30) {
                if (n4 < 0) {
                    n4 = 0;
                    this.iOffsetY = 30;
                }
            } else if (-n6 > n7 + 30 - this.getHeight() && n4 > 0) {
                n4 = 0;
                this.iOffsetY = -(n7 + 30 - this.getHeight());
            }
        }
        this.iOffsetX -= n3;
        this.iOffsetY -= n4;
        if (this.iSelectionRectEnd != null && this.iSelectionRectStart != null) {
            this.iSelectionRectEnd.x -= n3;
            this.iSelectionRectEnd.y -= n4;
            this.iSelectionRectStart.x -= n3;
            this.iSelectionRectStart.y -= n4;
        }
        this.loadVisibleTiles();
        this.repaint();
    }

    void zoomIn(Point point) {
        LatLon latLon = this.getLatLonOfScreenPoint(point);
        LatLon latLon2 = null;
        LatLon latLon3 = null;
        if (this.iSelectionRectEnd != null && this.iSelectionRectStart != null) {
            latLon2 = this.getLatLonOfScreenPoint(this.iSelectionRectStart);
            latLon3 = this.getLatLonOfScreenPoint(this.iSelectionRectEnd);
        }
        if (++iZoomlevel > 20) {
            iZoomlevel = 20;
            return;
        }
        this.setLatLonAtPoint(latLon, point);
        if (latLon2 != null && latLon3 != null) {
            this.iSelectionRectStart = this.getScreenPointForLatLon(latLon2);
            this.iSelectionRectEnd = this.getScreenPointForLatLon(latLon3);
        }
        this.loadVisibleTiles();
        this.centerMap();
        this.repaint();
    }

    void zoomOut(Point point) {
        LatLon latLon = this.getLatLonOfScreenPoint(point);
        LatLon latLon2 = null;
        LatLon latLon3 = null;
        if (this.iSelectionRectEnd != null && this.iSelectionRectStart != null) {
            latLon2 = this.getLatLonOfScreenPoint(this.iSelectionRectStart);
            latLon3 = this.getLatLonOfScreenPoint(this.iSelectionRectEnd);
        }
        if (--iZoomlevel < 1) {
            iZoomlevel = 1;
            return;
        }
        this.setLatLonAtPoint(latLon, point);
        if (latLon2 != null && latLon3 != null) {
            this.iSelectionRectStart = this.getScreenPointForLatLon(latLon2);
            this.iSelectionRectEnd = this.getScreenPointForLatLon(latLon3);
        }
        this.loadVisibleTiles();
        this.centerMap();
        this.repaint();
    }

    private LatLon getLatLonOfPoint(Point point) {
        return new LatLon(OsmMercator.YToLat(point.y, iZoomlevel), OsmMercator.XToLon(point.x, iZoomlevel));
    }

    private Point getPointForLatLon(LatLon latLon) {
        Point point = new Point();
        point.y = OsmMercator.LatToY(latLon.lat(), iZoomlevel);
        point.x = OsmMercator.LonToX(latLon.lon(), iZoomlevel);
        return point;
    }

    LatLon getLatLonOfScreenPoint(Point point) {
        Point point2 = new Point(point);
        point2.x -= this.iOffsetX;
        point2.y -= this.iOffsetY;
        return this.getLatLonOfPoint(point2);
    }

    Point getScreenPointForLatLon(LatLon latLon) {
        Point point = this.getPointForLatLon(latLon);
        point.x += this.iOffsetX;
        point.y += this.iOffsetY;
        return point;
    }

    void centerOnScreenPoint(Point point) {
        this.moveMap(point.x - this.getWidth() / 2, point.y - this.getHeight() / 2);
    }

    private void centerOnLatLon(LatLon latLon) {
        this.setLatLonAtPoint(latLon, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    private void setLatLonAtPoint(LatLon latLon, Point point) {
        int n = OsmMercator.LonToX(latLon.lon(), iZoomlevel);
        int n2 = OsmMercator.LatToY(latLon.lat(), iZoomlevel);
        this.iOffsetX = -n + point.x;
        this.iOffsetY = -n2 + point.y;
        this.repaint();
    }

    private void calcVisibleTiles() {
        if (this.iGui != null) {
            this.iVisibleTilesX = this.iGui.getWidth() / 256 + 2;
            this.iVisibleTilesY = this.iGui.getHeight() / 256 + 2;
        }
    }

    private void centerMap() {
        int n = OsmMercator.getMaxPixels(iZoomlevel);
        if (n < this.getWidth()) {
            this.iOffsetX = (this.getWidth() - n) / 2;
        }
        if (n < this.getHeight()) {
            this.iOffsetY = (this.getHeight() - n) / 2;
        }
    }
}

