/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.util.ArrayList;
import java.util.Hashtable;
import org.javacc.jjtree.ASTGrammar;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.CPPJJTreeState;
import org.javacc.jjtree.CPPNodeFiles;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeIOException;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.JJTreeState;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.ParseException;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Main;

public class JJTree {
    private IO io;

    private void p(String s) {
        this.io.getMsg().println(s);
    }

    private void help_message() {
        this.p("Usage:");
        this.p("    jjtree option-settings inputfile");
        this.p("");
        this.p("\"option-settings\" is a sequence of settings separated by spaces.");
        this.p("Each option setting must be of one of the following forms:");
        this.p("");
        this.p("    -optionname=value (e.g., -STATIC=false)");
        this.p("    -optionname:value (e.g., -STATIC:false)");
        this.p("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        this.p("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        this.p("");
        this.p("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        this.p("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        this.p("option, and must be either an integer or a string value.");
        this.p("");
        this.p("The boolean valued options are:");
        this.p("");
        this.p("    STATIC                   (default true)");
        this.p("    MULTI                    (default false)");
        this.p("    NODE_DEFAULT_VOID        (default false)");
        this.p("    NODE_SCOPE_HOOK          (default false)");
        this.p("    NODE_USES_PARSER         (default false)");
        this.p("    BUILD_NODE_FILES         (default true)");
        this.p("    TRACK_TOKENS             (default false)");
        this.p("    VISITOR                  (default false)");
        this.p("");
        this.p("The string valued options are:");
        this.p("");
        this.p("    JDK_VERSION              (default \"1.5\")");
        this.p("    NODE_CLASS               (default \"\")");
        this.p("    NODE_PREFIX              (default \"AST\")");
        this.p("    NODE_PACKAGE             (default \"\")");
        this.p("    NODE_EXTENDS             (default \"\")");
        this.p("    NODE_FACTORY             (default \"\")");
        this.p("    OUTPUT_FILE              (default remove input file suffix, add .jj)");
        this.p("    OUTPUT_DIRECTORY         (default \"\")");
        this.p("    JJTREE_OUTPUT_DIRECTORY  (default value of OUTPUT_DIRECTORY option)");
        this.p("    VISITOR_DATA_TYPE        (default \"\")");
        this.p("    VISITOR_RETURN_TYPE      (default \"Object\")");
        this.p("    VISITOR_EXCEPTION        (default \"\")");
        this.p("");
        this.p("JJTree also accepts JavaCC options, which it inserts into the generated file.");
        this.p("");
        this.p("EXAMPLES:");
        this.p("    jjtree -STATIC=false mygrammar.jjt");
        this.p("");
        this.p("ABOUT JJTree:");
        this.p("    JJTree is a preprocessor for JavaCC that inserts actions into a");
        this.p("    JavaCC grammar to build parse trees for the input.");
        this.p("");
        this.p("    For more information, see the online JJTree documentation at ");
        this.p("    https://javacc.dev.java.net/doc/JJTree.html ");
        this.p("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(String[] args) {
        ASTNodeDescriptor.nodeIds = new ArrayList();
        ASTNodeDescriptor.nodeNames = new ArrayList();
        ASTNodeDescriptor.nodeSeen = new Hashtable();
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Tree Builder", "");
        this.io = new IO();
        try {
            this.initializeOptions();
            if (args.length == 0) {
                this.p("");
                this.help_message();
                int n = 1;
                return n;
            }
            this.p("(type \"jjtree\" with no arguments for help)");
            String fn = args[args.length - 1];
            if (JJTreeOptions.isOption(fn)) {
                this.p("Last argument \"" + fn + "\" is not a filename");
                int n = 1;
                return n;
            }
            for (int arg = 0; arg < args.length - 1; ++arg) {
                if (!JJTreeOptions.isOption(args[arg])) {
                    this.p("Argument \"" + args[arg] + "\" must be an option setting.");
                    int n = 1;
                    return n;
                }
                JJTreeOptions.setCmdLineOption(args[arg]);
            }
            JJTreeOptions.validate();
            try {
                this.io.setInput(fn);
            }
            catch (JJTreeIOException ioe) {
                this.p("Error setting input: " + ioe.getMessage());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            this.p("Reading from file " + this.io.getInputFileName() + " . . .");
            JJTreeGlobals.toolList = JavaCCGlobals.getToolNames(fn);
            JJTreeGlobals.toolList.add("JJTree");
            JJTreeParser parser = new JJTreeParser(this.io.getIn());
            parser.javacc_input();
            ASTGrammar root = (ASTGrammar)parser.jjtree.rootNode();
            if (Boolean.getBoolean("jjtree-dump")) {
                root.dump(" ");
            }
            try {
                this.io.setOutput();
            }
            catch (JJTreeIOException ioe) {
                this.p("Error setting output: " + ioe.getMessage());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            root.generate(this.io);
            this.io.getOut().close();
            String outputLanguage = JJTreeOptions.getOutputLanguage();
            if (JJTreeOptions.isOutputLanguageJava()) {
                NodeFiles.generateTreeConstants_java();
                NodeFiles.generateVisitor_java();
                NodeFiles.generateDefaultVisitor_java();
                JJTreeState.generateTreeState_java();
            } else if (JJTreeOptions.isOutputLanguageCPP()) {
                CPPNodeFiles.generateTreeConstants();
                CPPNodeFiles.generateVisitors();
                CPPJJTreeState.generateTreeState();
            } else {
                this.p("Unsupported JJTree output language : " + outputLanguage);
                int n = 1;
                return n;
            }
            try {
                this.p("Annotated grammar generated successfully in " + this.io.getOutputFileName());
            }
            catch (ParseException pe) {
                this.p("Error parsing input: " + pe.toString());
                int n = 1;
                return n;
            }
            catch (Exception e) {
                this.p("Error parsing input: " + e.toString());
                e.printStackTrace(this.io.getMsg());
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.io.closeAll();
        }
    }

    private void initializeOptions() {
        JJTreeOptions.init();
        JJTreeGlobals.initialize();
    }
}

