/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.javacc.Version;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

public class OutputFile {
    private static final String MD5_LINE_PART_1 = "/* JavaCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_1q = "/\\* JavaCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_2 = " (do not edit this line) */";
    private static final String MD5_LINE_PART_2q = " \\(do not edit this line\\) \\*/";
    TrapClosePrintWriter pw;
    DigestOutputStream dos;
    String toolName = "JavaCC";
    final File file;
    final String compatibleVersion;
    final String[] options;
    public boolean needToWrite = true;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public OutputFile(File file, String compatibleVersion, String[] options) throws IOException {
        this.file = file;
        this.compatibleVersion = compatibleVersion;
        this.options = options;
        if (file.exists()) {
            String line;
            MessageDigest digest;
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw (IOException)new IOException("No MD5 implementation").initCause(e);
            }
            DigestOutputStream digestStream = new DigestOutputStream(new NullOutputStream(), digest);
            PrintWriter pw = new PrintWriter(digestStream);
            String existingMD5 = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(MD5_LINE_PART_1)) {
                    existingMD5 = line.replaceAll(MD5_LINE_PART_1q, "").replaceAll(MD5_LINE_PART_2q, "");
                    continue;
                }
                pw.println(line);
            }
            pw.close();
            String calculatedDigest = OutputFile.toHexString(digestStream.getMessageDigest().digest());
            if (existingMD5 == null || !existingMD5.equals(calculatedDigest)) {
                this.needToWrite = false;
                if (compatibleVersion != null) {
                    this.checkVersion(file, compatibleVersion);
                }
                if (options != null) {
                    this.checkOptions(file, options);
                }
            } else {
                System.out.println("File \"" + file.getName() + "\" is being rebuilt.");
                this.needToWrite = true;
            }
        } else {
            System.out.println("File \"" + file.getName() + "\" does not exist.  Will create one.");
            this.needToWrite = true;
        }
    }

    public OutputFile(File file) throws IOException {
        this(file, null, null);
    }

    private void checkVersion(File file, String versionId) {
        String firstLine = "/* " + JavaCCGlobals.getIdString(this.toolName, file.getName()) + " Version ";
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(firstLine)) continue;
                String version = firstLine.replaceFirst(".* Version ", "").replaceAll(" \\*/", "");
                if (version != versionId) {
                    JavaCCErrors.warning(file.getName() + ": File is obsolete.  Please rename or delete this file so" + " that a new one can be generated for you.");
                }
                return;
            }
        }
        catch (FileNotFoundException e1) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new Error();
        }
        catch (IOException e2) {
            // empty catch block
        }
    }

    private void checkOptions(File file, String[] options) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("/* JavaCCOptions:")) continue;
                String currentOptions = Options.getOptionsString(options);
                if (line.indexOf(currentOptions) == -1) {
                    JavaCCErrors.warning(file.getName() + ": Generated using incompatible options. Please rename or delete this file so" + " that a new one can be generated for you.");
                }
                return;
            }
        }
        catch (FileNotFoundException e1) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new Error();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (this.pw == null) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw (IOException)new IOException("No MD5 implementation").initCause(e);
            }
            this.dos = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)), digest);
            this.pw = new TrapClosePrintWriter(this.dos);
            String version = this.compatibleVersion == null ? Version.versionNumber : this.compatibleVersion;
            this.pw.println("/* " + JavaCCGlobals.getIdString(this.toolName, this.file.getName()) + " Version " + version + " */");
            if (this.options != null) {
                this.pw.println("/* JavaCCOptions:" + Options.getOptionsString(this.options) + " */");
            }
        }
        return this.pw;
    }

    public void close() throws IOException {
        if (this.pw != null) {
            this.pw.println(MD5_LINE_PART_1 + this.getMD5sum() + MD5_LINE_PART_2);
            this.pw.closePrintWriter();
        }
    }

    private String getMD5sum() {
        this.pw.flush();
        byte[] digest = this.dos.getMessageDigest().digest();
        return OutputFile.toHexString(digest);
    }

    private static final String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(HEX_DIGITS[(b & 0xF0) >> 4]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    private class TrapClosePrintWriter
    extends PrintWriter {
        public TrapClosePrintWriter(OutputStream os) {
            super(os);
        }

        public void closePrintWriter() {
            super.close();
        }

        public void close() {
            try {
                OutputFile.this.close();
            }
            catch (IOException e) {
                System.err.println("Could not close " + OutputFile.this.file.getAbsolutePath());
            }
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        }

        public void write(byte[] arg0) throws IOException {
        }

        public void write(int arg0) throws IOException {
        }
    }
}

