/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeScope;
import org.javacc.jjtree.SimpleNode;
import org.javacc.jjtree.Token;
import org.javacc.jjtree.TokenUtils;

public class JJTreeNode
extends SimpleNode {
    private int myOrdinal;
    private Token first;
    private Token last;
    private boolean whitingOut = false;

    public JJTreeNode(int id) {
        super(id);
    }

    public JJTreeNode(JJTreeParser p, int i) {
        this(i);
    }

    public static Node jjtCreate(int id) {
        return new JJTreeNode(id);
    }

    public void jjtAddChild(Node n, int i) {
        super.jjtAddChild(n, i);
        ((JJTreeNode)n).setOrdinal(i);
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public void setOrdinal(int o) {
        this.myOrdinal = o;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public void setFirstToken(Token t) {
        this.first = t;
    }

    public Token getLastToken() {
        return this.last;
    }

    public void setLastToken(Token t) {
        this.last = t;
    }

    String translateImage(Token t) {
        return t.image;
    }

    String whiteOut(Token t) {
        StringBuffer sb = new StringBuffer(t.image.length());
        for (int i = 0; i < t.image.length(); ++i) {
            char ch = t.image.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    protected void print(Token t, IO io) {
        NodeScope s;
        Token tt = t.specialToken;
        if (tt != null) {
            while (tt.specialToken != null) {
                tt = tt.specialToken;
            }
            while (tt != null) {
                io.print(TokenUtils.addUnicodeEscapes(this.translateImage(tt)));
                tt = tt.next;
            }
        }
        if ((s = NodeScope.getEnclosingNodeScope(this)) == null) {
            io.print(TokenUtils.addUnicodeEscapes(this.translateImage(t)));
            return;
        }
        if (t.image.equals("jjtThis")) {
            io.print(s.getNodeVariable());
            return;
        }
        if (t.image.equals("jjtree") && t.next.image.equals(".") && t.next.next.image.equals("currentNode") && t.next.next.next.image.equals("(") && t.next.next.next.next.image.equals(")")) {
            this.whitingOut = true;
        }
        if (this.whitingOut) {
            if (t.image.equals("jjtree")) {
                io.print(s.getNodeVariable());
                io.print(" ");
            } else if (t.image.equals(")")) {
                io.print(" ");
                this.whitingOut = false;
            } else {
                for (int i = 0; i < t.image.length(); ++i) {
                    io.print(" ");
                }
            }
            return;
        }
        io.print(TokenUtils.addUnicodeEscapes(this.translateImage(t)));
    }
}

