/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javacc.Version;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.parser.Options;
import org.javacc.parser.OtherFilesGenCPP;
import org.javacc.parser.OutputFile;
import org.javacc.utils.JavaFileGenerator;

final class CPPNodeFiles {
    private static List headersForJJTreeH = new ArrayList();
    static final String nodeVersion = Version.majorDotMinor;
    static Set nodesToGenerate = new HashSet();

    private CPPNodeFiles() {
    }

    static void addType(String type) {
        if (!type.equals("Node") && !type.equals("SimpleNode")) {
            nodesToGenerate.add(type);
        }
    }

    public static String nodeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), "Node.h").getAbsolutePath();
    }

    public static String jjtreeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeGlobals.parserName + "Tree.h").getAbsolutePath();
    }

    public static String jjtreeImplFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeGlobals.parserName + "Tree.cc").getAbsolutePath();
    }

    private static String visitorIncludeFile() {
        String name = CPPNodeFiles.visitorClass();
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), name + ".h").getAbsolutePath();
    }

    static void generateTreeClasses() {
        CPPNodeFiles.generateNodeHeader();
        CPPNodeFiles.generateTreeInterface();
        CPPNodeFiles.generateTreeImpl();
    }

    private static void generateNodeHeader() {
        File file = new File(CPPNodeFiles.nodeIncludeFile());
        OutputFile outputFile = null;
        try {
            String[] options = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            outputFile = new OutputFile(file, nodeVersion, options);
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            HashMap<String, Object> optionMap = new HashMap<String, Object>(Options.getOptions());
            optionMap.put("PARSER_NAME", JJTreeGlobals.parserName);
            optionMap.put("VISITOR_RETURN_TYPE", CPPNodeFiles.getVisitorReturnType());
            optionMap.put("VISITOR_DATA_TYPE", CPPNodeFiles.getVisitorArgumentType());
            optionMap.put("VISITOR_RETURN_TYPE_VOID", CPPNodeFiles.getVisitorReturnType().equals("void"));
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/Node.h.template", optionMap, false);
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
        finally {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static void generateTreeInterface() {
        File file = new File(CPPNodeFiles.jjtreeIncludeFile());
        OutputFile outputFile = null;
        try {
            boolean hasNamespace;
            String[] options = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            outputFile = new OutputFile(file, nodeVersion, options);
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            HashMap<String, Object> optionMap = new HashMap<String, Object>(Options.getOptions());
            optionMap.put("PARSER_NAME", JJTreeGlobals.parserName);
            optionMap.put("VISITOR_RETURN_TYPE", CPPNodeFiles.getVisitorReturnType());
            optionMap.put("VISITOR_DATA_TYPE", CPPNodeFiles.getVisitorArgumentType());
            optionMap.put("VISITOR_RETURN_TYPE_VOID", CPPNodeFiles.getVisitorReturnType().equals("void"));
            PrintWriter ostr = outputFile.getPrintWriter();
            ostr.println("#ifndef " + file.getName().replace('.', '_').toUpperCase());
            ostr.println("#define " + file.getName().replace('.', '_').toUpperCase());
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/TreeIncludeHeader.template", optionMap, false);
            boolean bl = hasNamespace = JJTreeOptions.stringValue("NAMESPACE").length() > 0;
            if (hasNamespace) {
                ostr.println("namespace " + JJTreeOptions.stringValue("NAMESPACE_OPEN"));
            }
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/SimpleNodeInterface.template", optionMap, false);
            for (String s : nodesToGenerate) {
                optionMap.put("NODE_TYPE", s);
                CPPNodeFiles.generateFile(outputFile, "/templates/cpp/MultiNodeInterface.template", optionMap, false);
            }
            if (hasNamespace) {
                ostr.println(JJTreeOptions.stringValue("NAMESPACE_CLOSE"));
            }
            ostr.println("#endif ");
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
        finally {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static void generateTreeImpl() {
        File file = new File(CPPNodeFiles.jjtreeImplFile());
        OutputFile outputFile = null;
        try {
            boolean hasNamespace;
            String[] options = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            outputFile = new OutputFile(file, nodeVersion, options);
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            HashMap<String, Object> optionMap = new HashMap<String, Object>(Options.getOptions());
            optionMap.put("PARSER_NAME", JJTreeGlobals.parserName);
            optionMap.put("VISITOR_RETURN_TYPE", CPPNodeFiles.getVisitorReturnType());
            optionMap.put("VISITOR_DATA_TYPE", CPPNodeFiles.getVisitorArgumentType());
            optionMap.put("VISITOR_RETURN_TYPE_VOID", CPPNodeFiles.getVisitorReturnType().equals("void"));
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/TreeImplHeader.template", optionMap, false);
            boolean bl = hasNamespace = JJTreeOptions.stringValue("NAMESPACE").length() > 0;
            if (hasNamespace) {
                outputFile.getPrintWriter().println("namespace " + JJTreeOptions.stringValue("NAMESPACE_OPEN"));
            }
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/SimpleNodeImpl.template", optionMap, false);
            for (String s : nodesToGenerate) {
                optionMap.put("NODE_TYPE", s);
                CPPNodeFiles.generateFile(outputFile, "/templates/cpp/MultiNodeImpl.template", optionMap, false);
            }
            if (hasNamespace) {
                outputFile.getPrintWriter().println(JJTreeOptions.stringValue("NAMESPACE_CLOSE"));
            }
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
        finally {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static void generatePrologue(PrintWriter ostr) {
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants() {
        String name = CPPNodeFiles.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), name + ".h");
        headersForJJTreeH.add(file.getName());
        try {
            String n;
            int i;
            boolean hasNamespace;
            OutputFile outputFile = new OutputFile(file);
            PrintWriter ostr = outputFile.getPrintWriter();
            List nodeIds = ASTNodeDescriptor.getNodeIds();
            List nodeNames = ASTNodeDescriptor.getNodeNames();
            CPPNodeFiles.generatePrologue(ostr);
            ostr.println("#ifndef " + file.getName().replace('.', '_').toUpperCase());
            ostr.println("#define " + file.getName().replace('.', '_').toUpperCase());
            ostr.println("\n#include \"JavaCC.h\"");
            boolean bl = hasNamespace = JJTreeOptions.stringValue("NAMESPACE").length() > 0;
            if (hasNamespace) {
                ostr.println("namespace " + JJTreeOptions.stringValue("NAMESPACE_OPEN"));
            }
            ostr.println("  enum {");
            for (i = 0; i < nodeIds.size(); ++i) {
                n = (String)nodeIds.get(i);
                ostr.println("  " + n + " = " + i + ",");
            }
            ostr.println("};");
            ostr.println();
            for (i = 0; i < nodeNames.size(); ++i) {
                ostr.println("  static JAVACC_CHAR_TYPE jjtNodeName_arr_" + i + "[] = ");
                n = (String)nodeNames.get(i);
                OtherFilesGenCPP.printCharArray(ostr, n);
                ostr.println(";");
            }
            ostr.println("  static JAVACC_STRING_TYPE jjtNodeName[] = {");
            for (i = 0; i < nodeNames.size(); ++i) {
                ostr.println("jjtNodeName_arr_" + i + ", ");
            }
            ostr.println("  };");
            if (hasNamespace) {
                ostr.println(JJTreeOptions.stringValue("NAMESPACE_CLOSE"));
            }
            ostr.println("#endif");
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    private static String getVisitMethodName(String className) {
        StringBuffer sb = new StringBuffer("visit");
        if (JJTreeOptions.booleanValue("VISITOR_METHOD_NAME_INCLUDES_TYPE_NAME")) {
            sb.append(Character.toUpperCase(className.charAt(0)));
            for (int i = 1; i < className.length(); ++i) {
                sb.append(className.charAt(i));
            }
        }
        return sb.toString();
    }

    private static String getVisitorArgumentType() {
        String ret = JJTreeOptions.stringValue("VISITOR_DATA_TYPE");
        return ret == null || ret.equals("") || ret.equals("Object") ? "void *" : ret;
    }

    private static String getVisitorReturnType() {
        String ret = JJTreeOptions.stringValue("VISITOR_RETURN_TYPE");
        return ret == null || ret.equals("") || ret.equals("Object") ? "void " : ret;
    }

    static void generateVisitors() {
        if (!JJTreeOptions.getVisitor()) {
            return;
        }
        try {
            boolean hasNamespace;
            String name = CPPNodeFiles.visitorClass();
            File file = new File(CPPNodeFiles.visitorIncludeFile());
            OutputFile outputFile = new OutputFile(file);
            PrintWriter ostr = outputFile.getPrintWriter();
            CPPNodeFiles.generatePrologue(ostr);
            ostr.println("#ifndef " + file.getName().replace('.', '_').toUpperCase().toUpperCase());
            ostr.println("#define " + file.getName().replace('.', '_').toUpperCase().toUpperCase());
            ostr.println("\n#include \"JavaCC.h\"");
            ostr.println("#include \"" + JJTreeGlobals.parserName + "Tree.h" + "\"");
            boolean bl = hasNamespace = JJTreeOptions.stringValue("NAMESPACE").length() > 0;
            if (hasNamespace) {
                ostr.println("namespace " + JJTreeOptions.stringValue("NAMESPACE_OPEN"));
            }
            CPPNodeFiles.generateVisitorInterface(ostr);
            CPPNodeFiles.generateDefaultVisitor(ostr);
            if (hasNamespace) {
                ostr.println(JJTreeOptions.stringValue("NAMESPACE_CLOSE"));
            }
            ostr.println("#endif");
            ostr.close();
        }
        catch (IOException ioe) {
            throw new Error(ioe.toString());
        }
    }

    private static void generateVisitorInterface(PrintWriter ostr) {
        String name = CPPNodeFiles.visitorClass();
        List nodeNames = ASTNodeDescriptor.getNodeNames();
        ostr.println("class " + name);
        ostr.println("{");
        String argumentType = CPPNodeFiles.getVisitorArgumentType();
        String returnType = CPPNodeFiles.getVisitorReturnType();
        if (!JJTreeOptions.getVisitorDataType().equals("")) {
            argumentType = JJTreeOptions.getVisitorDataType();
        }
        ostr.println("  public: virtual " + returnType + " visit(const SimpleNode *node, " + argumentType + " data) = 0;");
        if (JJTreeOptions.getMulti()) {
            for (int i = 0; i < nodeNames.size(); ++i) {
                String n = (String)nodeNames.get(i);
                if (n.equals("void")) continue;
                String nodeType = JJTreeOptions.getNodePrefix() + n;
                ostr.println("  public: virtual " + returnType + " " + CPPNodeFiles.getVisitMethodName(nodeType) + "(const " + nodeType + " *node, " + argumentType + " data) = 0;");
            }
        }
        ostr.println("  public: virtual ~" + name + "() { }");
        ostr.println("};");
    }

    static String defaultVisitorClass() {
        return JJTreeGlobals.parserName + "DefaultVisitor";
    }

    private static void generateDefaultVisitor(PrintWriter ostr) {
        String className = CPPNodeFiles.defaultVisitorClass();
        List nodeNames = ASTNodeDescriptor.getNodeNames();
        ostr.println("class " + className + " : public " + CPPNodeFiles.visitorClass() + " {");
        String argumentType = CPPNodeFiles.getVisitorArgumentType();
        String ret = CPPNodeFiles.getVisitorReturnType();
        ostr.println("  public:");
        ostr.println("  virtual " + ret + " defaultVisit(const SimpleNode *node, " + argumentType + " data) = 0;");
        ostr.println("  virtual " + ret + " visit(const SimpleNode *node, " + argumentType + " data) {");
        ostr.println("    " + (ret.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
        ostr.println("  }");
        if (JJTreeOptions.getMulti()) {
            for (int i = 0; i < nodeNames.size(); ++i) {
                String n = (String)nodeNames.get(i);
                if (n.equals("void")) continue;
                String nodeType = JJTreeOptions.getNodePrefix() + n;
                ostr.println("  virtual " + ret + " " + CPPNodeFiles.getVisitMethodName(nodeType) + "(const " + nodeType + " *node, " + argumentType + " data) {");
                ostr.println("    " + (ret.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
                ostr.println("  }");
            }
        }
        ostr.println("  public: ~" + className + "() { }");
        ostr.println("};");
    }

    public static void generateFile(OutputFile outputFile, String template, Map options) throws IOException {
        CPPNodeFiles.generateFile(outputFile, template, options, true);
    }

    public static void generateFile(OutputFile outputFile, String template, Map options, boolean close) throws IOException {
        PrintWriter ostr = outputFile.getPrintWriter();
        CPPNodeFiles.generatePrologue(ostr);
        JavaFileGenerator generator = new JavaFileGenerator(template, options);
        generator.generate(ostr);
        if (close) {
            ostr.close();
        }
    }
}

