/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class OsmTile {
    public static final int WIDTH = 256;
    public static final int HEIGHT = 256;
    private int iX = 0;
    private int iY = 0;
    public static final int TileBackgroundColor = 15324081;
    private BufferedImage iMapImage;
    private int iZoomLevel = -1;
    private int iIndexY = -1;
    private int iIndexX = -1;
    private boolean isInvalid = false;
    private int iHash;

    public OsmTile(int n, int n2, int n3) {
        this.iZoomLevel = n;
        this.iIndexX = n2;
        this.iIndexY = n3;
        this.iX = 256 * this.iIndexX;
        this.iY = 256 * this.iIndexY;
        this.iHash = this.toString().hashCode();
    }

    public int getZoomlevel() {
        return this.iZoomLevel;
    }

    public void paint(Graphics graphics) {
        if (this.iMapImage != null && !this.isInvalid) {
            graphics.drawImage(this.iMapImage, this.iX, this.iY, null);
        } else if (!this.isInvalid) {
            graphics.setColor(Color.RED);
            graphics.drawLine(this.iX, this.iY, this.iX + 256 - 1, this.iY + 256 - 1);
            graphics.drawLine(this.iX, this.iY + 256 - 1, this.iX + 256 - 1, this.iY);
            graphics.drawRect(this.iX, this.iY, 255, 255);
        }
    }

    public String toString() {
        return String.valueOf(this.iZoomLevel) + "/" + String.valueOf(this.iIndexX) + "/" + String.valueOf(this.iIndexY);
    }

    public static String key(int n, int n2, int n3) {
        return String.valueOf(n) + "/" + String.valueOf(n2) + "/" + String.valueOf(n3);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.iMapImage = bufferedImage;
        if (this.iMapImage == null) {
            this.isInvalid = true;
        }
    }

    public String getRemotePath() {
        return "/" + this.toString() + ".png";
    }
}

