/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSPlugin;

public class WMSLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms_small.png")));
    protected ArrayList<GeorefImage> images = new ArrayList();
    protected Grabber grabber;
    protected final int serializeFormatVersion = 2;

    public WMSLayer() {
        this("Blank Layer", null);
    }

    public WMSLayer(String name, Grabber grabber) {
        super(name);
        this.grabber = grabber;
    }

    public void grab(Bounds b, double pixelPerDegree) throws IOException {
        if (this.grabber == null) {
            return;
        }
        this.images.add(this.grabber.grab(b, Main.proj, pixelPerDegree));
        Main.map.mapView.repaint();
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        return I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.name, this.images.size()});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics g, MapView mv) {
        for (GeorefImage img : this.images) {
            img.paint(g, (NavigatableComponent)mv);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (GeorefImage img : this.images) {
            v.visit(img.min);
            v.visit(img.max);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            if (!this.images.get(i).contains(eastNorth)) continue;
            return this.images.get(i);
        }
        return null;
    }

    protected static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        fc.setMultiSelectionEnabled(multiple);
        for (int i = 0; i < ExtensionFileFilter.filters.length; ++i) {
            fc.addChoosableFileFilter((FileFilter)ExtensionFileFilter.filters[i]);
        }
        fc.setAcceptAllFileFilterUsed(true);
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && ((file = fc.getSelectedFile()) == null || file.exists() && 0 != JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"File exists. Overwrite?"), I18n.tr((String)"Overwrite"), 0))) {
            return null;
        }
        return fc;
    }

    public static File openFileDialog(boolean open) {
        JFileChooser fc = WMSLayer.createAndOpenFileChooser(open, false);
        if (fc == null) {
            return null;
        }
        File file = fc.getSelectedFile();
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            FileFilter ff = fc.getFileFilter();
            fn = ff instanceof ExtensionFileFilter ? "." + ((ExtensionFileFilter)ff).defaultExtension : fn + ".osm";
            file = new File(fn);
        }
        return file;
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(true);
            if (f == null) {
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 2}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                int numImg = ois.readInt();
                for (int i = 0; i < numImg; ++i) {
                    GeorefImage img = (GeorefImage)ois.readObject();
                    WMSLayer.this.images.add(img);
                }
                ois.close();
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(false);
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeInt(2);
                oos.writeInt(WMSLayer.this.images.size());
                for (GeorefImage img : WMSLayer.this.images) {
                    oos.writeObject(img);
                }
                oos.close();
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }
}

