/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.plugins.lakewalker.Configurer;

public class BooleanConfigurer
extends Configurer {
    private JCheckBox box;

    public BooleanConfigurer() {
        this(false);
    }

    public BooleanConfigurer(boolean val) {
        this((String)null, "", val);
    }

    public BooleanConfigurer(String key, String name, Boolean val) {
        super(key, name, val);
    }

    public BooleanConfigurer(String key, String name, boolean val) {
        super(key, name, val ? Boolean.TRUE : Boolean.FALSE);
    }

    public BooleanConfigurer(String key, String name) {
        this(key, name, Boolean.FALSE);
    }

    public String getValueString() {
        return this.booleanValue().toString();
    }

    public void setValue(Object o) {
        super.setValue(o);
        if (this.box != null && !o.equals(new Boolean(this.box.isSelected()))) {
            this.box.setSelected(this.booleanValue());
        }
    }

    public void setValue(String s) {
        this.setValue(Boolean.valueOf(s));
    }

    public void setName(String s) {
        super.setName(s);
        if (this.box != null) {
            this.box.setText(s);
        }
    }

    public Component getControls() {
        if (this.box == null) {
            this.box = new JCheckBox(this.getName());
            this.box.setSelected(this.booleanValue());
            this.box.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    BooleanConfigurer.this.setValue(new Boolean(BooleanConfigurer.this.box.isSelected()));
                }
            });
        }
        return this.box;
    }

    public Boolean booleanValue() {
        return (Boolean)this.value;
    }
}

