/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerException;

public class LakewalkerWMS {
    private BufferedImage image;
    private int imagex;
    private int imagey;
    public BufferedImage image2 = new BufferedImage(2000, 2000, 1);
    private int resolution;
    private int tilesize;
    private String wmslayer;
    private File working_dir;

    public LakewalkerWMS() {
    }

    public LakewalkerWMS(int resolution, int tilesize, String wmslayer, File workdir) {
        this.resolution = resolution;
        this.tilesize = tilesize;
        this.working_dir = workdir;
        this.wmslayer = wmslayer;
    }

    public BufferedImage getTile(int x, int y) throws LakewalkerException {
        String layer = "global_mosaic_base";
        int[] bottom_left_xy = new int[]{x / this.tilesize * this.tilesize, y / this.tilesize * this.tilesize};
        int[] top_right_xy = new int[]{bottom_left_xy[0] + this.tilesize, bottom_left_xy[1] + this.tilesize};
        double[] topright_geo = this.xy_to_geo(top_right_xy[0], top_right_xy[1]);
        double[] bottomleft_geo = this.xy_to_geo(bottom_left_xy[0], bottom_left_xy[1]);
        String filename = this.wmslayer + "/landsat_" + this.resolution + "_" + this.tilesize + "_xy_" + bottom_left_xy[0] + "_" + bottom_left_xy[1] + ".png";
        String urlloc = String.format("http://onearth.jpl.nasa.gov/wms.cgi?request=GetMap&layers=" + layer + "&styles=" + this.wmslayer + "&srs=EPSG:4326&format=image/png" + "&bbox=%.6f,%.6f,%.6f,%.6f&width=%d&height=%d", bottomleft_geo[1], bottomleft_geo[0], topright_geo[1], topright_geo[0], this.tilesize, this.tilesize);
        File file = new File(this.working_dir, filename);
        if (this.image != null) {
            if (this.imagex != bottom_left_xy[0] || this.imagey != bottom_left_xy[1]) {
                this.image = null;
            } else {
                return this.image;
            }
        }
        try {
            System.out.println("Looking for image in cache: " + filename);
            this.image = ImageIO.read(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find cached image, downloading.");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (this.image == null) {
            try {
                System.out.println("Downloading from " + urlloc);
                URL url = new URL(urlloc);
                this.image = ImageIO.read(url);
            }
            catch (MalformedURLException e) {
                System.out.println(e.getMessage());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            this.saveimage(file, this.image);
        }
        this.imagex = bottom_left_xy[0];
        this.imagey = bottom_left_xy[1];
        if (this.image == null) {
            throw new LakewalkerException("Could not acquire image");
        }
        return this.image;
    }

    public void saveimage(File file, BufferedImage image) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
            System.out.println("Saved image to cache");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public int getPixel(int x, int y, int pixcol) {
        BufferedImage image = null;
        try {
            image = this.getTile(x, y);
        }
        catch (LakewalkerException e) {
            System.out.println(e.getError());
            return -1;
        }
        int tx = (int)(Math.floor(x / this.tilesize) * (double)this.tilesize);
        int ty = (int)(Math.floor(y / this.tilesize) * (double)this.tilesize);
        int pixel_x = x - tx;
        int pixel_y = this.tilesize - 1 - (y - ty);
        int rgb = image.getRGB(pixel_x, pixel_y);
        this.image2.setRGB(pixel_x, pixel_y, pixcol);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        int pixel2 = (int)(0.212671 * (double)r + 0.71516 * (double)b + 0.072169 * (double)b);
        int pixel = (int)(0.3 * (double)r + 0.59 * (double)b + 0.11 * (double)g);
        return pixel;
    }

    private int rgbToGrey(int color) {
        Color c = new Color(color);
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int tot = (red + green + blue) / 3;
        return tot;
    }

    private void printarr(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(i + ": " + a[i]);
        }
    }

    private double[] xy_to_geo(int x, int y) {
        double[] geo = new double[]{(double)y / (double)this.resolution, (double)x / (double)this.resolution};
        return geo;
    }

    private int[] geo_to_xy(double lat, double lon) {
        int[] xy = new int[]{(int)(Math.floor(lon * (double)this.resolution) + 0.5), (int)(Math.floor(lat * (double)this.resolution) + 0.5)};
        return xy;
    }
}

