/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

class LakewalkerAction
extends JosmAction
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Cursor oldCursor;
    protected List<Node> selectedNodes;
    protected Thread executeThread;

    public LakewalkerAction(String name) {
        super(name, "lakewalker-sml", I18n.tr((String)"Lake Walker."), 76, 3, true);
        this.name = name;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        Main.map.mapView.setCursor(this.oldCursor);
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded."));
            return;
        }
        this.selectedNodes = new ArrayList<Node>();
        for (OsmPrimitive osm : Main.ds.getSelected()) {
            if (!(osm instanceof Node)) continue;
            Node node = (Node)osm;
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.isEmpty()) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(ImageProvider.getCursor((String)"crosshair", (String)"lakewalker-sml"));
            Main.map.mapView.addMouseListener((MouseListener)this);
        } else {
            this.lakewalk(this.selectedNodes);
        }
    }

    protected void lakewalk(Point clickPoint) {
        LatLon pos = Main.map.mapView.getLatLon(clickPoint.x, clickPoint.y);
        File working_dir = new File(Main.pref.getPreferencesDir(), "plugins");
        working_dir = new File(working_dir, "Lakewalker");
        String target = Main.pref.get("lakewalker.python") + " lakewalker.py";
        LatLon topLeft = Main.map.mapView.getLatLon(0, 0);
        LatLon botRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), Main.map.mapView.getHeight());
        target = target + " --lat=" + pos.lat();
        target = target + " --lon=" + pos.lon();
        target = target + " --left=" + topLeft.lon();
        target = target + " --right=" + botRight.lon();
        target = target + " --top=" + topLeft.lat();
        target = target + " --bottom=" + botRight.lat();
        target = target + " --waylength=" + Main.pref.get("lakewalker.max_segs_in_way", "500");
        target = target + " --maxnodes=" + Main.pref.get("lakewalker.max_nodes", "50000");
        target = target + " --threshold=" + Main.pref.get("lakewalker.threshold", "35");
        target = target + " --dp-epsilon=" + Main.pref.get("lakewalker.epsilon", "0.0003");
        target = target + " --landsat-res=" + Main.pref.get("lakewalker.landsat_res", "4000");
        target = target + " --tilesize=" + Main.pref.get("lakewalker.landsat_size", "2000");
        target = target + " --startdir=" + Main.pref.get("lakewalker.startdir", "east");
        target = target + " --wms=" + Main.pref.get("lakewalker.wms", "IR1");
        target = target + " --josm";
        try {
            Runtime rt = Runtime.getRuntime();
            System.out.println("dir: " + working_dir + ", target: " + target);
            final Process p = rt.exec(target, null, working_dir);
            final BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            final LakewalkerReader reader = new LakewalkerReader();
            PleaseWaitRunnable lakewalkerTask = new PleaseWaitRunnable(I18n.tr((String)"Tracing")){

                protected void realRun() throws SAXException {
                    reader.read(input);
                }

                protected void finish() {
                }

                protected void cancel() {
                    reader.cancel();
                    LakewalkerAction.this.executeThread.interrupt();
                    p.destroy();
                }
            };
            Thread executeThread = new Thread((Runnable)lakewalkerTask);
            executeThread.start();
        }
        catch (Exception ex) {
            System.out.println("Exception caught: " + ex.getMessage());
        }
    }

    protected void lakewalk(List nodes) {
    }

    public void mouseClicked(MouseEvent e) {
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.setCursor(this.oldCursor);
        this.lakewalk(e.getPoint());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

