/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.text.DecimalFormat;
import org.openstreetmap.josm.plugins.lakewalker.StringConfigurer;

public class DoubleConfigurer
extends StringConfigurer {
    static final DecimalFormat df = new DecimalFormat("#0.0##########");

    public DoubleConfigurer() {
    }

    public DoubleConfigurer(String key, String name) {
        this(key, name, new Double(0.0));
    }

    public DoubleConfigurer(String key, String name, Double val) {
        super(key, name, val == null ? null : df.format(val));
    }

    public void setValue(String s) {
        Double d = null;
        try {
            d = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            this.setValue(d);
        }
        if (!this.noUpdate && this.nameField != null) {
            this.nameField.setText(df.format(d));
        }
    }

    public String getValueString() {
        if (this.value == null || this.value.equals("")) {
            return (String)this.value;
        }
        return df.format(this.value);
    }
}

