/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.OSGBLayer;
import wmsplugin.WMSLayer;

public class DownloadWMSTask
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private Bounds bounds;

    public DownloadWMSTask(WMSLayer wmsLayer, Bounds bounds) {
        super(I18n.tr((String)("Downloading " + wmsLayer.name)));
        this.wmsLayer = wmsLayer;
        this.bounds = bounds;
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        this.wmsLayer.grab(this.bounds.min.lat(), this.bounds.min.lon(), this.bounds.max.lat(), this.bounds.max.lon());
    }

    protected void cancel() {
    }

    protected void finish() {
    }

    public static void download(String name, String wmsurl, double minlat, double minlon, double maxlat, double maxlon) {
        WMSLayer wmsLayer = null;
        for (Layer l : Main.map.mapView.getAllLayers()) {
            if (!(l instanceof WMSLayer) || !l.name.equals(name)) continue;
            wmsLayer = (WMSLayer)l;
        }
        if (wmsLayer == null) {
            wmsLayer = wmsurl.matches("(?i).*layers=npeoocmap.*") || wmsurl.matches("(?i).*layers=npe.*") ? new OSGBLayer(name, wmsurl) : new WMSLayer(name, wmsurl);
            Main.main.addLayer((Layer)wmsLayer);
        }
        Main.worker.execute((Runnable)((Object)new DownloadWMSTask(wmsLayer, new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon)))));
    }
}

