/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;

public class ValidateAction
extends JosmAction {
    private OSMValidatorPlugin plugin;
    private static final long serialVersionUID = -2304521273582574603L;
    private Collection<OsmPrimitive> lastSelection;

    public ValidateAction(OSMValidatorPlugin plugin) {
        super("Validation", "validator", "Performs the data validation", 86, 136, true);
        this.plugin = plugin;
    }

    public void actionPerformed(ActionEvent ev) {
        this.doValidate(ev, true);
    }

    public void doValidate(ActionEvent ev, boolean getSelectedItems) {
        Collection<Object> selection;
        if (this.plugin.validateAction == null || Main.map == null || !Main.map.isVisible()) {
            return;
        }
        Collection<Test> tests = OSMValidatorPlugin.getEnabledTests(false);
        if (tests.isEmpty()) {
            return;
        }
        if (getSelectedItems) {
            selection = Main.ds.getSelected();
            if (selection.isEmpty()) {
                selection = Main.ds.allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                AgregatePrimitivesVisitor v = new AgregatePrimitivesVisitor();
                selection = v.visit(selection);
                this.lastSelection = selection;
            }
        } else {
            selection = this.lastSelection == null ? Main.ds.allNonDeletedPrimitives() : this.lastSelection;
        }
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Test test : tests) {
            test.setPartialSelection(this.lastSelection != null);
            test.startTest();
            test.visit(selection);
            test.endTest();
            errors.addAll(test.getErrors());
        }
        tests = null;
        this.plugin.validationDialog.tree.setErrors(errors);
        this.plugin.validationDialog.setVisible(true);
        DataSet.fireSelectionChanged((Collection)Main.ds.getSelected());
    }
}

