(function (root, factory) {
	//======================================================================
	// Constants
	//======================================================================
	var holidays = {
		'de': {
			'PH': { // http://de.wikipedia.org/wiki/Feiertage_in_Deutschland
				'Neujahrstag'               : [  1,  1 ], // month 1, day 1, whole Germany
				'Heilige Drei Könige'       : [  1,  6, [ 'Baden-Württemberg', 'Bayern', 'Sachsen-Anhalt'] ], // only in the specified states
				'Tag der Arbeit'            : [  5,  1 ], // whole Germany
				'Karfreitag'                : [ 'easter', -2 ], // two days before easter
				'Ostersonntag'              : [ 'easter',  0, [ 'Brandenburg'] ],
				'Ostermontag'               : [ 'easter',  1 ],
				'Christi Himmelfahrt'       : [ 'easter', 39 ],
				'Pfingstsonntag'            : [ 'easter', 49, [ 'Brandenburg'] ],
				'Pfingstmontag'             : [ 'easter', 50 ],
				'Fronleichnam'              : [ 'easter', 60, [ 'Baden-Württemberg', 'Bayern', 'Hessen', 'Nordrhein-Westfalen', 'Rheinland-Pfalz', 'Saarland' ] ],
				'Mariä Himmelfahrt'         : [  8, 15, [ 'Saarland'] ],
				'Tag der Deutschen Einheit' : [ 10,  3 ],
				'Reformationstag'           : [ 10, 31, [ 'Brandenburg', 'Mecklenburg-Vorpommern', 'Sachsen', 'Sachsen-Anhalt', 'Thüringen'] ],
				'Allerheiligen'             : [ 11,  1, [ 'Baden-Württemberg', 'Bayern', 'Nordrhein-Westfalen', 'Rheinland-Pfalz', 'Saarland' ] ],
				'1. Weihnachtstag'          : [ 12, 25 ],
				'2. Weihnachtstag'          : [ 12, 26 ],
				// 'Silvester'                 : [ 12, 31 ], // for testing
			},
			'Baden-Württemberg': { // does only apply in Baden-Württemberg
				// This more specific rule set overwrites the country wide one (they are just ignored).
				// You may use this instead of the country wide with some
				// additional holidays for some states, if one state
				// totally disagrees about how to do public holidays …
				// 'PH': {
				// 	'2. Weihnachtstag'          : [ 12, 26 ],
				// },

				// school holiday normally variate between states
				'SH': [ // generated by convert_ical_to_json
						// You may can adjust this script to use other resources (for other countries) too.
					{
						name: 'Osterferien',
						2005: [  3, 24, /* to */  3, 24,   3, 29, /* to */  4,  2 ],
						2006: [  4, 18, /* to */  4, 22 ],
						2007: [  4,  2, /* to */  4, 14 ],
						2008: [  3, 17, /* to */  3, 28 ],
						2009: [  4,  9, /* to */  4,  9,   4, 14, /* to */  4, 17 ],
						2010: [  4,  1, /* to */  4,  1,   4,  6, /* to */  4, 10 ],
						2011: [  4, 21, /* to */  4, 21,   4, 26, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 13 ],
						2013: [  3, 25, /* to */  4,  5 ],
						2014: [  4, 14, /* to */  4, 25 ],
						2015: [  3, 30, /* to */  4, 10 ],
						2016: [  3, 29, /* to */  4,  2 ],
						2017: [  4, 10, /* to */  4, 21 ],
					},
					{
						name: 'Pfingstferien',
						2005: [  5, 17, /* to */  5, 28 ],
						2006: [  5, 29, /* to */  6, 10 ],
						2007: [  5, 29, /* to */  6,  9 ],
						2008: [  5, 13, /* to */  5, 23 ],
						2009: [  5, 25, /* to */  6,  6 ],
						2010: [  5, 25, /* to */  6,  5 ],
						2011: [  6, 14, /* to */  6, 25 ],
						2012: [  5, 29, /* to */  6,  9 ],
						2013: [  5, 21, /* to */  6,  1 ],
						2014: [  6, 10, /* to */  6, 21 ],
						2015: [  5, 26, /* to */  6,  6 ],
						2016: [  5, 17, /* to */  5, 28 ],
						2017: [  6,  6, /* to */  6, 16 ],
					},
					{
						name: 'Sommerferien',
						2005: [  7, 28, /* to */  9, 10 ],
						2006: [  8,  3, /* to */  9, 16 ],
						2007: [  7, 26, /* to */  9,  8 ],
						2008: [  7, 24, /* to */  9,  6 ],
						2009: [  7, 30, /* to */  9, 12 ],
						2010: [  7, 29, /* to */  9, 11 ],
						2011: [  7, 28, /* to */  9, 10 ],
						2012: [  7, 26, /* to */  9,  8 ],
						2013: [  7, 25, /* to */  9,  7 ],
						2014: [  7, 31, /* to */  9, 13 ],
						2015: [  7, 30, /* to */  9, 12 ],
						2016: [  7, 28, /* to */  9, 10 ],
						2017: [  7, 27, /* to */  9,  9 ],
					},
					{
						name: 'Herbstferien',
						2005: [ 11,  2, /* to */ 11,  4 ],
						2006: [ 10, 30, /* to */ 11,  3 ],
						2007: [ 10, 29, /* to */ 11,  3 ],
						2008: [ 10, 27, /* to */ 10, 31 ],
						2009: [ 10, 26, /* to */ 10, 31 ],
						2010: [ 11,  2, /* to */ 11,  6 ],
						2011: [ 10, 31, /* to */ 10, 31,  11,  2, /* to */ 11,  4 ],
						2012: [ 10, 29, /* to */ 11,  2 ],
						2013: [ 10, 28, /* to */ 10, 30 ],
						2014: [ 10, 27, /* to */ 10, 30 ],
						2015: [ 11,  2, /* to */ 11,  6 ],
						2016: [ 11,  2, /* to */ 11,  4 ],
					},
					{
						name: 'Weihnachtsferien',
						2005: [ 12, 22, /* to */  1,  5 ],
						2006: [ 12, 27, /* to */  1,  5 ],
						2007: [ 12, 24, /* to */  1,  5 ],
						2008: [ 12, 22, /* to */  1, 10 ],
						2009: [ 12, 23, /* to */  1,  9 ],
						2010: [ 12, 23, /* to */  1,  8 ],
						2011: [ 12, 23, /* to */  1,  5 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 23, /* to */  1,  4 ],
						2014: [ 12, 22, /* to */  1,  5 ],
						2015: [ 12, 23, /* to */  1,  9 ],
						2016: [ 12, 23, /* to */  1,  7 ],
					},
				],
			},
			'Mecklenburg-Vorpommern': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  6, /* to */  2, 20 ],
						2011: [  2,  7, /* to */  2, 19 ],
						2012: [  2,  6, /* to */  2, 17 ],
						2013: [  2,  4, /* to */  2, 15 ],
						2014: [  2,  3, /* to */  2, 15 ],
						2015: [  2,  2, /* to */  2, 14 ],
						2016: [  2,  1, /* to */  2, 13 ],
						2017: [  2,  6, /* to */  2, 18 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 29, /* to */  4,  7 ],
						2011: [  4, 16, /* to */  4, 27 ],
						2012: [  4,  2, /* to */  4, 11 ],
						2013: [  3, 25, /* to */  4,  3 ],
						2014: [  4, 14, /* to */  4, 23 ],
						2015: [  3, 30, /* to */  4,  8 ],
						2016: [  3, 21, /* to */  3, 30 ],
						2017: [  4, 10, /* to */  4, 19 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 21, /* to */  5, 22 ],
						2011: [  6, 10, /* to */  6, 14 ],
						2012: [  5, 25, /* to */  5, 29 ],
						2013: [  5, 17, /* to */  5, 21 ],
						2014: [  6,  6, /* to */  6, 10 ],
						2015: [  5, 22, /* to */  5, 26 ],
						2016: [  5, 14, /* to */  5, 17 ],
						2017: [  6,  2, /* to */  6,  6 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7, 12, /* to */  8, 21 ],
						2011: [  7,  4, /* to */  8, 13 ],
						2012: [  6, 23, /* to */  8,  4 ],
						2013: [  6, 22, /* to */  8,  3 ],
						2014: [  7, 14, /* to */  8, 23 ],
						2015: [  7, 20, /* to */  8, 29 ],
						2016: [  7, 25, /* to */  9,  3 ],
						2017: [  7, 24, /* to */  9,  2 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 18, /* to */ 10, 23 ],
						2011: [ 10, 17, /* to */ 10, 21 ],
						2012: [ 10,  1, /* to */ 10,  5 ],
						2013: [ 10, 14, /* to */ 10, 19 ],
						2014: [ 10, 20, /* to */ 10, 25 ],
						2015: [ 10, 24, /* to */ 10, 30 ],
						2016: [ 10, 24, /* to */ 10, 28 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */ 12, 31 ],
						2011: [ 12, 23, /* to */  1,  3 ],
						2012: [ 12, 21, /* to */  1,  4 ],
						2013: [ 12, 23, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  2 ],
						2015: [ 12, 21, /* to */  1,  2 ],
						2016: [ 12, 22, /* to */  1,  2 ],
					},
				],
			},
			'Hessen': {
				'SH': [
					{
						name: 'Osterferien',
						2010: [  3, 29, /* to */  4, 10 ],
						2011: [  4, 18, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 14 ],
						2013: [  3, 25, /* to */  4,  6 ],
						2014: [  4, 14, /* to */  4, 26 ],
						2015: [  3, 30, /* to */  4, 11 ],
						2016: [  3, 29, /* to */  4,  9 ],
						2017: [  4,  3, /* to */  4, 15 ],
						2018: [  3, 26, /* to */  4,  7 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7,  5, /* to */  8, 14 ],
						2011: [  6, 27, /* to */  8,  5 ],
						2012: [  7,  2, /* to */  8, 10 ],
						2013: [  7,  8, /* to */  8, 16 ],
						2014: [  7, 28, /* to */  9,  5 ],
						2015: [  7, 27, /* to */  9,  5 ],
						2016: [  7, 18, /* to */  8, 26 ],
						2017: [  7,  3, /* to */  8, 11 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 22 ],
						2011: [ 10, 10, /* to */ 10, 22 ],
						2012: [ 10, 15, /* to */ 10, 27 ],
						2013: [ 10, 14, /* to */ 10, 26 ],
						2014: [ 10, 20, /* to */ 11,  1 ],
						2015: [ 10, 19, /* to */ 10, 31 ],
						2016: [ 10, 17, /* to */ 10, 29 ],
						2017: [ 10,  9, /* to */ 10, 21 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 20, /* to */  1,  7 ],
						2011: [ 12, 21, /* to */  1,  6 ],
						2012: [ 12, 24, /* to */  1, 12 ],
						2013: [ 12, 23, /* to */  1, 11 ],
						2014: [ 12, 22, /* to */  1, 10 ],
						2015: [ 12, 23, /* to */  1,  9 ],
						2016: [ 12, 22, /* to */  1,  7 ],
						2017: [ 12, 24, /* to */  1, 13 ],
					},
				],
			},
			'Schleswig-Holstein': {
				'SH': [
					{
						name: 'Osterferien',
						2010: [  4,  3, /* to */  4, 17 ],
						2011: [  4, 15, /* to */  4, 30 ],
						2012: [  3, 30, /* to */  4, 13 ],
						2013: [  3, 25, /* to */  4,  9 ],
						2014: [  4, 16, /* to */  5,  2 ],
						2015: [  4,  1, /* to */  4, 17 ],
						2016: [  3, 24, /* to */  4,  9 ],
						2017: [  4,  7, /* to */  4, 21 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7, 12, /* to */  8, 21 ],
						2011: [  7,  4, /* to */  8, 13 ],
						2012: [  6, 25, /* to */  8,  4 ],
						2013: [  6, 24, /* to */  8,  3 ],
						2014: [  7, 14, /* to */  8, 23 ],
						2015: [  7, 20, /* to */  8, 29 ],
						2016: [  7, 25, /* to */  9,  3 ],
						2017: [  7, 24, /* to */  9,  2 ],
					},
					{
						name: 'Pfingstferien',
						2011: [  6,  3, /* to */  6,  4 ],
						2012: [  5, 18, /* to */  5, 18 ],
						2013: [  5, 10, /* to */  5, 10 ],
						2014: [  5, 30, /* to */  5, 30 ],
						2015: [  5, 15, /* to */  5, 15 ],
						2016: [  5,  6, /* to */  5,  6 ],
						2017: [  5, 26, /* to */  5, 26 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 23 ],
						2011: [ 10, 10, /* to */ 10, 22 ],
						2012: [ 10,  4, /* to */ 10, 19 ],
						2013: [ 10,  4, /* to */ 10, 18 ],
						2014: [ 10, 13, /* to */ 10, 25 ],
						2015: [ 10, 19, /* to */ 10, 31 ],
						2016: [ 10, 17, /* to */ 10, 29 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  7 ],
						2011: [ 12, 23, /* to */  1,  6 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 23, /* to */  1,  6 ],
						2014: [ 12, 22, /* to */  1,  6 ],
						2015: [ 12, 21, /* to */  1,  6 ],
						2016: [ 12, 23, /* to */  1,  6 ],
					},
				],
			},
			'Berlin': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  1, /* to */  2,  6 ],
						2011: [  1, 31, /* to */  2,  5 ],
						2012: [  1, 30, /* to */  2,  4 ],
						2013: [  2,  4, /* to */  2,  9 ],
						2014: [  2,  3, /* to */  2,  8 ],
						2015: [  2,  2, /* to */  2,  7 ],
						2016: [  2,  1, /* to */  2,  6 ],
						2017: [  1, 30, /* to */  2,  4 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 31, /* to */  4, 10 ],
						2011: [  4, 18, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 14,   4, 30, /* to */  4, 30 ],
						2013: [  3, 25, /* to */  4,  6 ],
						2014: [  4, 14, /* to */  4, 26,   5,  2, /* to */  5,  2 ],
						2015: [  3, 30, /* to */  4, 11 ],
						2016: [  3, 21, /* to */  4,  2 ],
						2017: [  4, 10, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 14,   5, 25, /* to */  5, 25 ],
						2011: [  6,  3, /* to */  6,  3 ],
						2012: [  5, 18, /* to */  5, 18 ],
						2013: [  5, 10, /* to */  5, 10,   5, 21, /* to */  5, 21 ],
						2014: [  5, 30, /* to */  5, 30 ],
						2015: [  5, 15, /* to */  5, 15 ],
						2016: [  5,  6, /* to */  5,  6,   5, 17, /* to */  5, 17 ],
						2017: [  5, 26, /* to */  5, 26 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7,  7, /* to */  8, 21 ],
						2011: [  6, 29, /* to */  8, 12 ],
						2012: [  6, 20, /* to */  8,  3 ],
						2013: [  6, 19, /* to */  8,  2 ],
						2014: [  7,  9, /* to */  8, 22 ],
						2015: [  7, 15, /* to */  8, 28 ],
						2016: [  7, 20, /* to */  9,  2 ],
						2017: [  7, 19, /* to */  9,  1 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 23 ],
						2011: [ 10,  4, /* to */ 10, 14 ],
						2012: [ 10,  1, /* to */ 10, 13 ],
						2013: [  9, 30, /* to */ 10, 12 ],
						2014: [ 10, 20, /* to */ 11,  1 ],
						2015: [ 10, 19, /* to */ 10, 31 ],
						2016: [ 10, 17, /* to */ 10, 28 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  1 ],
						2011: [ 12, 23, /* to */  1,  3 ],
						2012: [ 12, 24, /* to */  1,  4 ],
						2013: [ 12, 23, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  2 ],
						2015: [ 12, 23, /* to */  1,  2 ],
						2016: [ 12, 23, /* to */  1,  3 ],
					},
				],
			},
			'Saarland': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2, 15, /* to */  2, 20 ],
						2011: [  3,  7, /* to */  3, 12 ],
						2012: [  2, 20, /* to */  2, 25 ],
						2013: [  2, 11, /* to */  2, 16 ],
						2014: [  3,  3, /* to */  3,  8 ],
						2015: [  2, 16, /* to */  2, 21 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 29, /* to */  4, 10 ],
						2011: [  4, 18, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 14 ],
						2013: [  3, 25, /* to */  4,  6 ],
						2014: [  4, 14, /* to */  4, 26 ],
						2015: [  3, 30, /* to */  4, 11 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7,  5, /* to */  8, 14 ],
						2011: [  6, 24, /* to */  8,  6 ],
						2012: [  7,  2, /* to */  8, 14 ],
						2013: [  7,  8, /* to */  8, 17 ],
						2014: [  7, 28, /* to */  9,  6 ],
						2015: [  7, 27, /* to */  9,  4 ],
						2016: [  7, 18, /* to */  8, 26 ],
						2017: [  7,  3, /* to */  8, 14 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 23 ],
						2011: [ 10,  4, /* to */ 10, 15 ],
						2012: [ 10, 22, /* to */ 11,  3 ],
						2013: [ 10, 21, /* to */ 11,  2 ],
						2014: [ 10, 20, /* to */ 10, 31 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 20, /* to */  1,  1 ],
						2011: [ 12, 23, /* to */  1,  4 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 20, /* to */  1,  4 ],
						2014: [ 12, 22, /* to */  1,  7 ],
					},
				],
			},
			'Bremen': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  1, /* to */  2,  2 ],
						2011: [  1, 31, /* to */  2,  1 ],
						2012: [  1, 30, /* to */  1, 31 ],
						2013: [  1, 31, /* to */  2,  1 ],
						2014: [  1, 30, /* to */  1, 31 ],
						2015: [  2,  2, /* to */  2,  3 ],
						2016: [  1, 28, /* to */  1, 29 ],
						2017: [  1, 30, /* to */  1, 31 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 19, /* to */  4,  6 ],
						2011: [  4, 16, /* to */  4, 30 ],
						2012: [  3, 26, /* to */  4, 11,   4, 30, /* to */  4, 30 ],
						2013: [  3, 16, /* to */  4,  2 ],
						2014: [  4,  3, /* to */  4, 22,   5,  2, /* to */  5,  2 ],
						2015: [  3, 25, /* to */  4, 10 ],
						2016: [  3, 18, /* to */  4,  2 ],
						2017: [  4, 10, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 14,   5, 25, /* to */  5, 25 ],
						2011: [  6,  3, /* to */  6,  3,   6, 14, /* to */  6, 14 ],
						2012: [  5, 18, /* to */  5, 18,   5, 29, /* to */  5, 29 ],
						2013: [  5, 10, /* to */  5, 10,   5, 21, /* to */  5, 21 ],
						2014: [  5, 30, /* to */  5, 30,   6, 10, /* to */  6, 10 ],
						2015: [  5, 15, /* to */  5, 15,   5, 26, /* to */  5, 26 ],
						2016: [  5,  6, /* to */  5,  6,   5, 17, /* to */  5, 17 ],
						2017: [  5, 26, /* to */  5, 26,   6,  6, /* to */  6,  6 ],
					},
					{
						name: 'Sommerferien',
						2010: [  6, 24, /* to */  8,  4 ],
						2011: [  7,  7, /* to */  8, 17 ],
						2012: [  7, 23, /* to */  8, 31 ],
						2013: [  6, 27, /* to */  8,  7 ],
						2014: [  7, 31, /* to */  9, 10 ],
						2015: [  7, 23, /* to */  9,  2 ],
						2016: [  6, 23, /* to */  8,  3 ],
						2017: [  6, 22, /* to */  8,  2 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10,  9, /* to */ 10, 23 ],
						2011: [ 10, 17, /* to */ 10, 29 ],
						2012: [ 10, 22, /* to */ 11,  3 ],
						2013: [ 10,  4, /* to */ 10, 18 ],
						2014: [ 10, 27, /* to */ 11,  8 ],
						2015: [ 10, 19, /* to */ 10, 31 ],
						2016: [ 10,  4, /* to */ 10, 15 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 22, /* to */  1,  5 ],
						2011: [ 12, 23, /* to */  1,  4 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 23, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  5 ],
						2015: [ 12, 23, /* to */  1,  6 ],
						2016: [ 12, 21, /* to */  1,  6 ],
					},
				],
			},
			'Bayern': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2, 15, /* to */  2, 20 ],
						2011: [  3,  7, /* to */  3, 11 ],
						2012: [  2, 20, /* to */  2, 24 ],
						2013: [  2, 11, /* to */  2, 15 ],
						2014: [  3,  3, /* to */  3,  7 ],
						2015: [  2, 16, /* to */  2, 20 ],
						2016: [  2,  8, /* to */  2, 12 ],
						2017: [  2, 27, /* to */  3,  3 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 29, /* to */  4, 10 ],
						2011: [  4, 18, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 14 ],
						2013: [  3, 25, /* to */  4,  6 ],
						2014: [  4, 14, /* to */  4, 26 ],
						2015: [  3, 30, /* to */  4, 11 ],
						2016: [  3, 21, /* to */  4,  1 ],
						2017: [  4, 10, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 25, /* to */  6,  5 ],
						2011: [  6, 14, /* to */  6, 25 ],
						2012: [  5, 29, /* to */  6,  9 ],
						2013: [  5, 21, /* to */  5, 31 ],
						2014: [  6, 10, /* to */  6, 21 ],
						2015: [  5, 26, /* to */  6,  5 ],
						2016: [  5, 17, /* to */  5, 28 ],
						2017: [  6,  6, /* to */  6, 16 ],
					},
					{
						name: 'Sommerferien',
						2010: [  8,  2, /* to */  9, 13 ],
						2011: [  7, 30, /* to */  9, 12 ],
						2012: [  8,  1, /* to */  9, 12 ],
						2013: [  7, 31, /* to */  9, 11 ],
						2014: [  7, 30, /* to */  9, 15 ],
						2015: [  8,  1, /* to */  9, 14 ],
						2016: [  7, 30, /* to */  9, 12 ],
						2017: [  7, 29, /* to */  9, 11 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 11,  2, /* to */ 11,  5 ],
						2011: [ 10, 31, /* to */ 11,  5 ],
						2012: [ 10, 29, /* to */ 11,  3 ],
						2013: [ 10, 28, /* to */ 10, 31 ],
						2014: [ 10, 27, /* to */ 10, 31 ],
						2015: [ 11,  2, /* to */ 11,  7 ],
						2016: [ 10, 31, /* to */ 11,  4 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 24, /* to */  1,  7 ],
						2011: [ 12, 27, /* to */  1,  5 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 23, /* to */  1,  4 ],
						2014: [ 12, 24, /* to */  1,  5 ],
						2015: [ 12, 24, /* to */  1,  5 ],
						2016: [ 12, 24, /* to */  1,  5 ],
					},
				],
			},
			'Niedersachsen': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  1, /* to */  2,  2 ],
						2011: [  1, 31, /* to */  2,  1 ],
						2012: [  1, 30, /* to */  1, 31 ],
						2013: [  1, 31, /* to */  2,  1 ],
						2014: [  1, 30, /* to */  1, 31 ],
						2015: [  2,  2, /* to */  2,  3 ],
						2016: [  1, 28, /* to */  1, 29 ],
						2017: [  1, 30, /* to */  1, 31 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 19, /* to */  4,  6 ],
						2011: [  4, 16, /* to */  4, 30 ],
						2012: [  3, 26, /* to */  4, 11,   4, 30, /* to */  4, 30 ],
						2013: [  3, 16, /* to */  4,  2 ],
						2014: [  4,  3, /* to */  4, 22,   5,  2, /* to */  5,  2 ],
						2015: [  3, 25, /* to */  4, 10 ],
						2016: [  3, 18, /* to */  4,  2 ],
						2017: [  4, 10, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 14,   5, 25, /* to */  5, 25 ],
						2011: [  6,  3, /* to */  6,  3,   6, 14, /* to */  6, 14 ],
						2012: [  5, 18, /* to */  5, 18,   5, 29, /* to */  5, 29 ],
						2013: [  5, 10, /* to */  5, 10,   5, 21, /* to */  5, 21 ],
						2014: [  5, 30, /* to */  5, 30,   6, 10, /* to */  6, 10 ],
						2015: [  5, 15, /* to */  5, 15,   5, 26, /* to */  5, 26 ],
						2016: [  5,  6, /* to */  5,  6,   5, 17, /* to */  5, 17 ],
						2017: [  5, 26, /* to */  5, 26,   6,  6, /* to */  6,  6 ],
					},
					{
						name: 'Sommerferien',
						2010: [  6, 24, /* to */  8,  4 ],
						2011: [  7,  7, /* to */  8, 17 ],
						2012: [  7, 23, /* to */  8, 31 ],
						2013: [  6, 27, /* to */  8,  7 ],
						2014: [  7, 31, /* to */  9, 10 ],
						2015: [  7, 23, /* to */  9,  2 ],
						2016: [  6, 23, /* to */  8,  3 ],
						2017: [  6, 22, /* to */  8,  2 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10,  9, /* to */ 10, 23 ],
						2011: [ 10, 17, /* to */ 10, 29 ],
						2012: [ 10, 22, /* to */ 11,  3 ],
						2013: [ 10,  4, /* to */ 10, 18 ],
						2014: [ 10, 27, /* to */ 11,  8 ],
						2015: [ 10, 19, /* to */ 10, 31 ],
						2016: [ 10,  4, /* to */ 10, 15 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 22, /* to */  1,  5 ],
						2011: [ 12, 23, /* to */  1,  4 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 23, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  5 ],
						2015: [ 12, 23, /* to */  1,  6 ],
						2016: [ 12, 21, /* to */  1,  6 ],
					},
				],
			},
			'Nordrhein-Westfalen': {
				'SH': [
					{
						name: 'Osterferien',
						2010: [  3, 27, /* to */  4, 10 ],
						2011: [  4, 18, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 14 ],
						2013: [  3, 25, /* to */  4,  6 ],
						2014: [  4, 14, /* to */  4, 26 ],
						2015: [  3, 30, /* to */  4, 11 ],
						2016: [  3, 21, /* to */  4,  2 ],
						2017: [  4, 10, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 25, /* to */  5, 25 ],
						2012: [  5, 29, /* to */  5, 29 ],
						2013: [  5, 21, /* to */  5, 21 ],
						2014: [  6, 10, /* to */  6, 10 ],
						2015: [  5, 26, /* to */  5, 26 ],
						2016: [  5, 17, /* to */  5, 17 ],
						2017: [  6,  6, /* to */  6,  6 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7, 15, /* to */  8, 27 ],
						2011: [  7, 25, /* to */  9,  6 ],
						2012: [  7,  9, /* to */  8, 21 ],
						2013: [  7, 22, /* to */  9,  3 ],
						2014: [  7,  7, /* to */  8, 19 ],
						2015: [  6, 29, /* to */  8, 11 ],
						2016: [  7, 11, /* to */  8, 23 ],
						2017: [  7, 17, /* to */  8, 29 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 23 ],
						2011: [ 10, 24, /* to */ 11,  5 ],
						2012: [ 10,  8, /* to */ 10, 20 ],
						2013: [ 10, 21, /* to */ 11,  2 ],
						2014: [ 10,  6, /* to */ 10, 18 ],
						2015: [ 10,  5, /* to */ 10, 17 ],
						2016: [ 10, 10, /* to */ 10, 21 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 24, /* to */  1,  8 ],
						2011: [ 12, 23, /* to */  1,  6 ],
						2012: [ 12, 21, /* to */  1,  4 ],
						2013: [ 12, 23, /* to */  1,  7 ],
						2014: [ 12, 22, /* to */  1,  6 ],
						2015: [ 12, 23, /* to */  1,  6 ],
						2016: [ 12, 23, /* to */  1,  6 ],
					},
				],
			},
			'Sachsen': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  8, /* to */  2, 20 ],
						2011: [  2, 12, /* to */  2, 26 ],
						2012: [  2, 13, /* to */  2, 25 ],
						2013: [  2,  4, /* to */  2, 15 ],
						2014: [  2, 17, /* to */  3,  1 ],
						2015: [  2,  9, /* to */  2, 21 ],
						2016: [  2,  8, /* to */  2, 20 ],
						2017: [  2, 13, /* to */  2, 24 ],
					},
					{
						name: 'Osterferien',
						2010: [  4,  1, /* to */  4, 10 ],
						2011: [  4, 22, /* to */  4, 30 ],
						2012: [  4,  6, /* to */  4, 14 ],
						2013: [  3, 29, /* to */  4,  6 ],
						2014: [  4, 18, /* to */  4, 26 ],
						2015: [  4,  2, /* to */  4, 11 ],
						2016: [  3, 25, /* to */  4,  2 ],
						2017: [  4, 13, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 14 ],
						2011: [  6,  3, /* to */  6,  3 ],
						2012: [  5, 18, /* to */  5, 18 ],
						2013: [  5, 10, /* to */  5, 10,   5, 18, /* to */  5, 22 ],
						2014: [  5, 30, /* to */  5, 30 ],
						2015: [  5, 15, /* to */  5, 15 ],
						2016: [  5,  6, /* to */  5,  6 ],
						2017: [  5, 26, /* to */  5, 26 ],
					},
					{
						name: 'Sommerferien',
						2010: [  6, 28, /* to */  8,  6 ],
						2011: [  7, 11, /* to */  8, 19 ],
						2012: [  7, 23, /* to */  8, 31 ],
						2013: [  7, 15, /* to */  8, 23 ],
						2014: [  7, 21, /* to */  8, 29 ],
						2015: [  7, 13, /* to */  8, 21 ],
						2016: [  6, 27, /* to */  8,  5 ],
						2017: [  6, 26, /* to */  8,  4 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10,  4, /* to */ 10, 16 ],
						2011: [ 10, 17, /* to */ 10, 28 ],
						2012: [ 10, 22, /* to */ 11,  2 ],
						2013: [ 10, 21, /* to */ 11,  1 ],
						2014: [ 10, 20, /* to */ 10, 31 ],
						2015: [ 10, 12, /* to */ 10, 24 ],
						2016: [ 10,  3, /* to */ 10, 15 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  1 ],
						2011: [ 12, 23, /* to */  1,  2 ],
						2012: [ 12, 22, /* to */  1,  2 ],
						2013: [ 12, 21, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  3 ],
						2015: [ 12, 21, /* to */  1,  2 ],
						2016: [ 12, 23, /* to */  1,  2 ],
					},
				],
			},
			'Thüringen': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  1, /* to */  2,  6 ],
						2011: [  1, 31, /* to */  2,  5 ],
						2012: [  2,  6, /* to */  2, 11 ],
						2013: [  2, 18, /* to */  2, 23 ],
						2014: [  2, 17, /* to */  2, 22 ],
						2015: [  2,  2, /* to */  2,  7 ],
						2016: [  2,  1, /* to */  2,  6 ],
						2017: [  2,  6, /* to */  2, 11 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 29, /* to */  4,  9 ],
						2011: [  4, 18, /* to */  4, 30 ],
						2012: [  4,  2, /* to */  4, 13 ],
						2013: [  3, 25, /* to */  4,  6 ],
						2014: [  4, 19, /* to */  5,  2 ],
						2015: [  3, 30, /* to */  4, 11 ],
						2016: [  3, 24, /* to */  4,  2 ],
						2017: [  4, 10, /* to */  4, 21 ],
					},
					{
						name: 'Sommerferien',
						2010: [  6, 24, /* to */  8,  4 ],
						2011: [  7, 11, /* to */  8, 19 ],
						2012: [  7, 23, /* to */  8, 31 ],
						2013: [  7, 15, /* to */  8, 23 ],
						2014: [  7, 21, /* to */  8, 29 ],
						2015: [  7, 13, /* to */  8, 21 ],
						2016: [  6, 27, /* to */  8, 10 ],
						2017: [  6, 26, /* to */  8,  9 ],
					},
					{
						name: 'Pfingstferien',
						2011: [  6, 11, /* to */  6, 14 ],
						2012: [  5, 25, /* to */  5, 29 ],
						2013: [  5, 10, /* to */  5, 10 ],
						2014: [  5, 30, /* to */  5, 30 ],
						2015: [  5, 15, /* to */  5, 15 ],
						2016: [  5,  6, /* to */  5,  6 ],
						2017: [  5, 26, /* to */  5, 26 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10,  9, /* to */ 10, 23 ],
						2011: [ 10, 17, /* to */ 10, 28 ],
						2012: [ 10, 22, /* to */ 11,  3 ],
						2013: [ 10, 21, /* to */ 11,  2 ],
						2014: [ 10,  6, /* to */ 10, 18 ],
						2015: [ 10,  5, /* to */ 10, 17 ],
						2016: [ 10, 10, /* to */ 10, 22 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  1 ],
						2011: [ 12, 23, /* to */  1,  1 ],
						2012: [ 12, 24, /* to */  1,  5 ],
						2013: [ 12, 23, /* to */  1,  4 ],
						2014: [ 12, 22, /* to */  1,  3 ],
						2015: [ 12, 23, /* to */  1,  2 ],
						2016: [ 12, 23, /* to */ 12, 31 ],
					},
				],
			},
			'Hamburg': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  1, 29, /* to */  1, 29 ],
						2011: [  1, 31, /* to */  1, 31 ],
						2012: [  1, 30, /* to */  1, 30 ],
						2013: [  2,  1, /* to */  2,  1 ],
						2014: [  1, 31, /* to */  1, 31 ],
						2015: [  1, 30, /* to */  1, 30 ],
						2016: [  1, 29, /* to */  1, 29 ],
						2017: [  1, 30, /* to */  1, 30 ],
					},
					{
						name: 'Osterferien',
						2010: [  3,  8, /* to */  3, 20 ],
						2011: [  3,  7, /* to */  3, 18 ],
						2012: [  3,  5, /* to */  3, 16 ],
						2013: [  3,  4, /* to */  3, 15 ],
						2014: [  3,  3, /* to */  3, 14 ],
						2015: [  3,  2, /* to */  3, 13 ],
						2016: [  3,  7, /* to */  3, 18 ],
						2017: [  3,  6, /* to */  3, 17 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 22 ],
						2011: [  4, 26, /* to */  4, 29,   6,  3, /* to */  6,  3 ],
						2012: [  4, 30, /* to */  5,  4,   5, 18, /* to */  5, 18 ],
						2013: [  5,  2, /* to */  5, 10 ],
						2014: [  4, 28, /* to */  5,  2,   5, 30, /* to */  5, 30 ],
						2015: [  5, 11, /* to */  5, 15 ],
						2016: [  5,  6, /* to */  5,  6,   5, 17, /* to */  5, 20 ],
						2017: [  5, 22, /* to */  5, 26 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7,  8, /* to */  8, 18 ],
						2011: [  6, 30, /* to */  8, 10 ],
						2012: [  6, 21, /* to */  8,  1 ],
						2013: [  6, 20, /* to */  7, 31 ],
						2014: [  7, 10, /* to */  8, 20 ],
						2015: [  7, 16, /* to */  8, 26 ],
						2016: [  7, 21, /* to */  8, 31 ],
						2017: [  7, 20, /* to */  8, 30 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10,  4, /* to */ 10, 15 ],
						2011: [ 10,  4, /* to */ 10, 14 ],
						2012: [ 10,  1, /* to */ 10, 12 ],
						2013: [  9, 30, /* to */ 10, 11 ],
						2014: [ 10, 13, /* to */ 10, 24 ],
						2015: [ 10, 19, /* to */ 10, 30 ],
						2016: [ 10, 17, /* to */ 10, 28 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  3 ],
						2011: [ 12, 27, /* to */  1,  6 ],
						2012: [ 12, 21, /* to */  1,  4 ],
						2013: [ 12, 19, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  6 ],
						2015: [ 12, 21, /* to */  1,  1 ],
						2016: [ 12, 27, /* to */  1,  6 ],
					},
				],
			},
			'Sachsen-Anhalt': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  8, /* to */  2, 13 ],
						2011: [  2,  5, /* to */  2, 12 ],
						2012: [  2,  4, /* to */  2, 11 ],
						2013: [  2,  1, /* to */  2,  8 ],
						2014: [  2,  1, /* to */  2, 12 ],
						2015: [  2,  2, /* to */  2, 14 ],
						2016: [  2,  1, /* to */  2, 10 ],
						2017: [  2,  4, /* to */  2, 11 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 29, /* to */  4,  9 ],
						2011: [  4, 18, /* to */  4, 27 ],
						2012: [  4,  2, /* to */  4,  7 ],
						2013: [  3, 25, /* to */  3, 30 ],
						2014: [  4, 14, /* to */  4, 17 ],
						2015: [  4,  2, /* to */  4,  2 ],
						2016: [  3, 24, /* to */  3, 24 ],
						2017: [  4, 10, /* to */  4, 13 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 22 ],
						2011: [  6, 14, /* to */  6, 18 ],
						2012: [  5, 18, /* to */  5, 25 ],
						2013: [  5, 10, /* to */  5, 18 ],
						2014: [  5, 30, /* to */  6,  7 ],
						2015: [  5, 15, /* to */  5, 23 ],
						2016: [  5,  6, /* to */  5, 14 ],
						2017: [  5, 26, /* to */  5, 26 ],
					},
					{
						name: 'Sommerferien',
						2010: [  6, 24, /* to */  8,  4 ],
						2011: [  7, 11, /* to */  8, 24 ],
						2012: [  7, 23, /* to */  9,  5 ],
						2013: [  7, 15, /* to */  8, 28 ],
						2014: [  7, 21, /* to */  9,  3 ],
						2015: [  7, 13, /* to */  8, 26 ],
						2016: [  6, 27, /* to */  8, 10 ],
						2017: [  6, 26, /* to */  8,  9 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 18, /* to */ 10, 23 ],
						2011: [ 10, 17, /* to */ 10, 22 ],
						2012: [ 10, 29, /* to */ 11,  2 ],
						2013: [ 10, 21, /* to */ 10, 25 ],
						2014: [ 10, 27, /* to */ 10, 30 ],
						2015: [ 10, 17, /* to */ 10, 24 ],
						2016: [ 10,  4, /* to */ 10, 15 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 22, /* to */  1,  5 ],
						2011: [ 12, 22, /* to */  1,  7 ],
						2012: [ 12, 19, /* to */  1,  4 ],
						2013: [ 12, 21, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  5 ],
						2015: [ 12, 21, /* to */  1,  5 ],
						2016: [ 12, 19, /* to */  1,  2 ],
					},
				],
			},
			'Rheinland-Pfalz': {
				'SH': [
					{
						name: 'Osterferien',
						2010: [  3, 26, /* to */  4,  9 ],
						2011: [  4, 18, /* to */  4, 29 ],
						2012: [  3, 29, /* to */  4, 13 ],
						2013: [  3, 20, /* to */  4,  5 ],
						2014: [  4, 11, /* to */  4, 25 ],
						2015: [  3, 26, /* to */  4, 10 ],
						2016: [  3, 18, /* to */  4,  1 ],
						2017: [  4, 10, /* to */  4, 21 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7,  5, /* to */  8, 13 ],
						2011: [  6, 27, /* to */  8,  5 ],
						2012: [  7,  2, /* to */  8, 10 ],
						2013: [  7,  8, /* to */  8, 16 ],
						2014: [  7, 28, /* to */  9,  5 ],
						2015: [  7, 27, /* to */  9,  4 ],
						2016: [  7, 18, /* to */  8, 26 ],
						2017: [  7,  3, /* to */  8, 11 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 22 ],
						2011: [ 10,  4, /* to */ 10, 14 ],
						2012: [ 10,  1, /* to */ 10, 12 ],
						2013: [ 10,  4, /* to */ 10, 18 ],
						2014: [ 10, 20, /* to */ 10, 31 ],
						2015: [ 10, 19, /* to */ 10, 30 ],
						2016: [ 10, 10, /* to */ 10, 21 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  7 ],
						2011: [ 12, 22, /* to */  1,  6 ],
						2012: [ 12, 20, /* to */  1,  4 ],
						2013: [ 12, 23, /* to */  1,  7 ],
						2014: [ 12, 22, /* to */  1,  7 ],
						2015: [ 12, 23, /* to */  1,  8 ],
						2016: [ 12, 22, /* to */  1,  6 ],
					},
				],
			},
			'Brandenburg': {
				'SH': [
					{
						name: 'Winterferien',
						2010: [  2,  1, /* to */  2,  6 ],
						2011: [  1, 31, /* to */  2,  5 ],
						2012: [  1, 30, /* to */  2,  4 ],
						2013: [  2,  4, /* to */  2,  9 ],
						2014: [  2,  3, /* to */  2,  8 ],
						2015: [  2,  2, /* to */  2,  7 ],
						2016: [  2,  1, /* to */  2,  6 ],
						2017: [  1, 30, /* to */  2,  4 ],
					},
					{
						name: 'Osterferien',
						2010: [  3, 31, /* to */  4, 10 ],
						2011: [  4, 20, /* to */  4, 30 ],
						2012: [  4,  4, /* to */  4, 14,   4, 30, /* to */  4, 30 ],
						2013: [  3, 27, /* to */  4,  6 ],
						2014: [  4, 16, /* to */  4, 26,   5,  2, /* to */  5,  2 ],
						2015: [  4,  1, /* to */  4, 11 ],
						2016: [  3, 23, /* to */  4,  2 ],
						2017: [  4, 12, /* to */  4, 22 ],
					},
					{
						name: 'Pfingstferien',
						2010: [  5, 14, /* to */  5, 14 ],
						2011: [  6,  3, /* to */  6,  3 ],
						2012: [  5, 18, /* to */  5, 18 ],
						2013: [  5, 10, /* to */  5, 10 ],
						2014: [  5, 30, /* to */  5, 30 ],
						2015: [  5, 15, /* to */  5, 15 ],
						2016: [  5,  6, /* to */  5,  6,   5, 17, /* to */  5, 17 ],
						2017: [  5, 26, /* to */  5, 26 ],
					},
					{
						name: 'Sommerferien',
						2010: [  7,  8, /* to */  8, 21 ],
						2011: [  6, 30, /* to */  8, 13 ],
						2012: [  6, 21, /* to */  8,  3 ],
						2013: [  6, 20, /* to */  8,  2 ],
						2014: [  7, 10, /* to */  8, 22 ],
						2015: [  7, 16, /* to */  8, 28 ],
						2016: [  7, 21, /* to */  9,  3 ],
						2017: [  7, 20, /* to */  9,  1 ],
					},
					{
						name: 'Herbstferien',
						2010: [ 10, 11, /* to */ 10, 23 ],
						2011: [ 10,  4, /* to */ 10, 14 ],
						2012: [ 10,  1, /* to */ 10, 13 ],
						2013: [  9, 30, /* to */ 10, 12,  11,  1, /* to */ 11,  1 ],
						2014: [ 10, 20, /* to */ 11,  1 ],
						2015: [ 10, 19, /* to */ 10, 30 ],
						2016: [ 10, 17, /* to */ 10, 28 ],
					},
					{
						name: 'Weihnachtsferien',
						2010: [ 12, 23, /* to */  1,  1 ],
						2011: [ 12, 23, /* to */  1,  3 ],
						2012: [ 12, 24, /* to */  1,  4 ],
						2013: [ 12, 23, /* to */  1,  3 ],
						2014: [ 12, 22, /* to */  1,  2 ],
						2015: [ 12, 23, /* to */  1,  2 ],
						2016: [ 12, 23, /* to */  1,  3 ],
					},
				],
			},
		},
		'at': {
			'PH': { // http://de.wikipedia.org/wiki/Feiertage_in_%C3%96sterreich
				'Neujahrstag'               : [  1,  1 ],
				'Heilige Drei Könige'       : [  1,  6 ],
				// 'Josef'                     : [  3, 19, [ 'Kärnten', 'Steiermark', 'Tirol', 'Vorarlberg' ] ],
				// 'Karfreitag'                : [ 'easter', -2 ],
				'Ostermontag'               : [ 'easter',  1 ],
				'Staatsfeiertag'            : [  5,  1 ],
				// 'Florian'                   : [  5,  4, [ 'Oberösterreich' ] ],
				'Christi Himmelfahrt'       : [ 'easter', 39 ],
				'Pfingstmontag'             : [ 'easter', 50 ],
				'Fronleichnam'              : [ 'easter', 60 ],
				'Mariä Himmelfahrt'         : [  8, 15 ],
				// 'Rupert'                    : [  9, 24, [ 'Salzburg' ] ],
				// 'Tag der Volksabstimmung'   : [ 10, 10, [ 'Kärnten' ] ],
				'Nationalfeiertag'          : [ 10, 26 ],
				'Allerheiligen'             : [ 11,  1 ],
				// 'Martin'                    : [ 11, 11, [ 'Burgenland' ] ],
				// 'Leopold'                   : [ 11, 15, [ 'Niederösterreich', 'Wien' ] ],
				'Mariä Empfängnis'          : [ 12,  8 ],
				// 'Heiliger Abend'            : [ 12, 24 ],
				'Christtag'                 : [ 12, 25 ],
				'Stefanitag'                : [ 12, 26 ],
				// 'Silvester'                 : [ 12, 31 ],
			},
		},
	};

	//----------------------------------------------------------------------------
	//  error correction
	//  Taken form http://www.netzwolf.info/j/osm/time_domain.js
	//  Credits go to Netzwolf
	//
	//  Key to word_error_correction is the token name except wrong_words
	//----------------------------------------------------------------------------
	var word_error_correction = {
		wrong_words: {
			'Assuming "<ok>" for "<ko>"': {
				summer: 'May-Oct',
				winter: 'Nov-Apr',
			}, 'Bitte benutze die englische Schreibweise "<ok>" für "<ko>".': {
				sommer: 'summer',
			}, 'Bitte benutze "<ok>" für "<ko>". Beispiel: "Mo 08:00-12:00; Tu off"': {
				ruhetag: 'off',
				ruhetage: 'off',
			}, 'Assuming "<ok>" for "<ko>". Please avoid using "workday": http://wiki.openstreetmap.org/wiki/Talk:Key:opening_hours#need_syntax_for_holidays_and_workingdays': {
				// 	// Used around 260 times but the problem is, that work day might be different in other countries.
				wd:       'Mo-Fr',
				weekday:  'Mo-Fr',
				weekdays: 'Mo-Fr',
			}, 'Please ommit "<ko>" or use a colon instead: "12:00-14:00".': {
				h: '',
			}, 'Please ommit "<ko>".': {
				season: '',
			}, 'Please ommit "<ko>". You might want to express open end which can be specified as "12:00+" for example': {
				from: '',
			}, 'Please use notation "<ok>" for "<ko>". If the times are unsure or variate consider a comment e.g. 12:00-14:00 "only on sunshine".': {
				'~':  '-',
			}, 'Please use notation "<ok>" for "<ko>".': {
				'–':  '-',
				to:   '-',
				till: '-',
				and:  ',',
				'&':  ',',
				daily:    'Mo-Su',
				always:   '24/7',
				midnight: '00:00',
			}, 'Please use time format in 24 hours notation ("<ko>").': {
				pm: '',
				am: '',
			}, 'Bitte verzichte auf "<ko>".': {
				uhr: '',
			}, 'Bitte verzichte auf "<ko>". Sie möchten eventuell eine Öffnungszeit ohne vorgegebenes Ende angeben. Beispiel: "12:00+"': {
				ab:  '',
				von: '',
			}, 'Bitte benutze die Schreibweise "<ok>" für "<ko>".': {
				bis: '-',
				und: ',',
			}, 'Bitte benutze die englische Abkürzung "<ok>" für "<ko>".': {
				feiertag:   'PH',
				feiertage:  'PH',
				feiertagen: 'PH'
			}, 'S\'il vous plaît utiliser "<ok>" pour "<ko>".': {
				'fermé': 'off',
				'et':    ',',
				'à':     '-',
			}, 'Neem de engelse afkorting "<ok>" voor "<ko>" alstublieft.': {
				feestdag:   'PH',
				feestdagen: 'PH',
			}
		},

		month: {
			'default': {
				jan:  0,
				feb:  1,
				mar:  2,
				apr:  3,
				may:  4,
				jun:  5,
				jul:  6,
				aug:  7,
				sep:  8,
				oct:  9,
				nov: 10,
				dec: 11,
			}, 'Please use the English abbreviation "<ok>" for "<ko>".': {
				january:    0,
				february:   1,
				march:      2,
				april:      3,
				// may:     4,
				june:       5,
				july:       6,
				august:     7,
				september:  8,
				sept:       8,
				october:    9,
				november:  10,
				december:  11,
			}, 'Bitte benutze die englische Abkürzung "<ok>" für "<ko>".': {
				januar:    0,
				februar:   1,
				'märz':    2,
				maerz:     2,
				mai:       4,
				juni:      5,
				juli:      6,
				okt:       9,
				oktober:   9,
				dez:      11,
				dezember: 11,
			}, 'S\'il vous plaît utiliser l\'abréviation "<ok>" pour "<ko>".': {
				janvier:    0,
				février:    1,
				fév:        1,
				mars:       2,
				avril:      3,
				avr:        3,
				mai:        4,
				juin:       5,
				juillet:    6,
				août:       7,
				aoû:        7,
				septembre:  8,
				octobre:    9,
				novembre:  10,
				décembre:  11,
			}, 'Neem de engelse afkorting "<ok>" voor "<ko>" alstublieft.': {
				januari:  0,
				februari: 1,
				maart:    2,
				mei:      4,
				augustus: 7,
			}
		},

		weekday: { // good source: http://www.omniglot.com/language/time/days.htm
			'default': {
				su: 0,
				mo: 1,
				tu: 2,
				we: 3,
				th: 4,
				fr: 5,
				sa: 6,
			}, 'Assuming "<ok>" for "<ko>"': {
				m:          1,
				w:          3,
				f:          5,
			}, 'Please use the abbreviation "<ok>" for "<ko>".': {
				sun:        0,
				sunday:     0,
				sundays:    0,
				mon:        1,
				monday:     1,
				mondays:    1,
				tue:        2,
				tuesday:    2,
				tuesdays:   2,
				wed:        3,
				wednesday:  3,
				wednesdays: 3,
				thu:        4,
				thursday:   4,
				thursdays:  4,
				fri:        5,
				friday:     5,
				fridays:    5,
				sat:        6,
				saturday:   6,
				saturdays:  6,
			}, 'Bitte benutze die englische Abkürzung "<ok>" für "<ko>". Could also mean Saturday in Polish …': {
				so:         0,
			}, 'Bitte benutze die englische Abkürzung "<ok>" für "<ko>".': {
				son:         0,
				sonntag:     0,
				sonntags:    0,
				montag:      1,
				montags:     1,
				di:          2,
				die:         2,
				dienstag:    2,
				dienstags:   2,
				mi:          3,
				mit:         3,
				mittwoch:    3,
				mittwochs:   3,
				'do':        4,
				don:         4,
				donnerstag:  4,
				donnerstags: 4,
				fre:         5,
				freitag:     5,
				freitags:    5,
				sam:         6,
				samstag:     6,
				samstags:    6,
			}, 'S\'il vous plaît utiliser l\'abréviation "<ok>" pour "<ko>".': {
				dim:      0,
				dimanche: 0,
				lu:       1,
				lun:      1,
				lundi:    1,
				mardi:    2,
				mer:      3,
				mercredi: 3,
				je:       4,
				jeu:      4,
				jeudi:    4,
				ve:       5,
				ven:      5,
				vendredi: 5,
				samedi:   6,
			}, 'Neem de engelse afkorting "<ok>" voor "<ko>" alstublieft.': {
				zo:        0,
				zon:       0,
				zontag:    0,
				maandag:   1,
				din:       2,
				dinsdag:   2,
				wo:        3,
				woe:       3,
				woensdag:  3,
				donderdag: 4,
				vr:        5,
				vri:       5,
				vrijdag:   5,
				za:        6,
				zat:       6,
				zaterdag:  6,
			}, 'Please use the English abbreviation "<ok>" for "<ko>".': { // FIXME: Translate to Czech.
				'neděle':  0,
				'ne':      0,
				'pondělí': 1,
				'po':      1,
				'úterý':   2,
				'út':      2,
				'středa':  3,
				'st':      3,
				'čtvrtek': 4,
				'čt':      4,
				'pátek':   5,
				'pá':      5,
				'sobota':  6,
			}, 'Please use the English abbreviation "<ok>" for "<ko>".': {
				// Spanish.
				'martes':    0,
				'miércoles': 1,
				'jueves':    2,
				'viernes':   3,
				'sábado':    4,
				'domingo':   5,
				'lunes':     6,
				// Indonesian.
				'selasa': 0,
				'rabu':   1,
				'kami':   2,
				'jumat':  3,
				'sabtu':  4,
				'minggu': 5,
				'senin':  6,
				// Swedish
				'söndag':  0,
				'måndag':  1,
				ma:        1,
				'tisdag':  2,
				'onsdag':  3,
				'torsdag': 4,
				'fredag':  5,
				'lördag':  6,
				// Polish
				'niedziela': 0, 'niedz': 0, 'n': 0, 'ndz': 0,
				'poniedziałek': 1, 'poniedzialek': 1, 'pon': 1, 'pn': 1,
				'wtorek': 2, 'wt': 2,
				'środa': 3, 'sroda': 3, 'śr': 3, 'sr': 3,
				'czwartek': 4, 'czw': 4, 'cz': 4,
				'piątek': 5, 'piatek': 5, 'pt': 5,
				'sobota': 6, 'sob': 6, // 'so': 6 // abbreviation also used in German
			},
		},

		timevar: { // Special time variables which actual value depends on the date and the position of the facility.
			'default': {
				sunrise: 'sunrise',
				sunset:  'sunset',
				dawn:    'dawn',
				dusk:    'dusk',
			}, 'Please use notation "<ok>" for "<ko>".': {
				sundown: 'sunset',
			}, 'Bitte benutze die Schreibweise "<ok>" für "<ko>".': {
				'morgendämmerung': 'dawn',
				'abenddämmerung':  'dusk',
				sonnenaufgang: 'sunrise',
				sonnenuntergang: ',',
			},
		},

		'event': { // variable events
			'default': {
				easter: 'easter',
			}, 'Bitte benutze die Schreibweise "<ok>" für "<ko>".': {
				ostern: 'easter',
			},
		},
	};

	if (typeof exports === 'object') {
		// For nodejs
		var SunCalc = require('suncalc');
		module.exports = factory(SunCalc, holidays, word_error_correction);
	} else {
		// For browsers
		root.opening_hours = factory(root.SunCalc, holidays, word_error_correction);
	}
}(this, function (SunCalc, holidays, word_error_correction) {
	return function(value, nominatiomJSON, oh_mode) {
		var word_value_replacement = { // if the correct values can not be calculated
			dawn    : 60 * 5 + 30,
			sunrise : 60 * 6,
			sunset  : 60 * 18,
			dusk    : 60 * 18 + 30,
		};
		var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
		var weekdays = ['Su','Mo','Tu','We','Th','Fr','Sa'];
		var default_prettify_conf = {
			'leading_zero_hour': true,       // enforce leading zero
			'one_zero_if_hour_zero': false,  // only one zero "0" if hour is zero "0"
			'leave_off_closed': true,        // leave keywords of and closed as is
			'keyword_for_off_closed': 'off', // use given keyword instead of "off" or "closed"
			'block_sep_string': ' ',         // separate blocks by string
			'print_semicolon': true,         // print token which separates normal blocks
			'leave_weekday_sep_one_day_betw': true, // use the separator (either "," or "-" which is used to separate days which follow to each other like Sa,Su or Su-Mo
			'sep_one_day_between': ',' // separator which should be used
		};

		var minutes_in_day = 60 * 24;
		var msec_in_day    = 1000 * 60 * minutes_in_day;
		var msec_in_week   = msec_in_day * 7;

		//======================================================================
		// Constructor - entry to parsing code
		//======================================================================
		// Terminology:
		//
		// Mo-Fr 10:00-11:00; Th 10:00-12:00
		// \_____block_____/  \____block___/
		//
		// The README refers to blocks as rules, which is more intuitive but less clear.
		// Because of that only the README uses the term rule in that context.
		// In all internal parts of this project, the term block is used.
		//
		// Mo-Fr Jan 10:00-11:00
		// \__/  \_/ \_________/
		// selectors (left to right: weekday, month, time)
		//
		// Logic:
		// - Tokenize
		// Foreach block:
		//   - Run toplevel (block) parser
		//     - Which calls subparser for specific selector types
		//       - Which produce selector functions


		// Evaluate additional information which can be given. They are
		// required to reasonably calculate 'sunrise' and so on and to use the
		// correct holidays.
		var location_cc, location_state, lat, lon;
		if (typeof nominatiomJSON != 'undefined') {
			if (typeof nominatiomJSON.address != 'undefined' &&
					typeof nominatiomJSON.address.state != 'undefined') { // country_code will be tested later …
						location_cc    = nominatiomJSON.address.country_code;
						location_state = nominatiomJSON.address.state;
			}

			if (typeof nominatiomJSON.lon != 'undefined') { // lat will be tested later …
				lat = nominatiomJSON.lat;
				lon = nominatiomJSON.lon;
			}
		}

		// 0: time ranges (opening_hours, lit, …) default
		// 1: points in time (collection_times, service_times, …)
		// 2: both (time ranges and points in time)
		if (typeof oh_mode == 'undefined') {
			oh_mode = 0;
		} else if (!(typeof oh_mode == 'number' && (oh_mode == 0 || oh_mode == 1 || oh_mode == 2))) {
			throw 'The third constructor parameter is oh_mode and must be a number (0, 1 or 2)'
		}

		if (value.match(/^(\s*;?\s*)+$/))
			throw 'Value contains nothing meaningful which can be parsed';

		var parsing_warnings = [];
		var done_with_warnings = false; // The functions which throw warnings can be called multiple times.
		var has_token = {};
		var tokens = tokenize(value);
		// console.log(JSON.stringify(tokens, null, '\t'));
		var prettified_value = '';
		var used_subparsers = {}; // Used sub parsers for one block, will be asdreset for each block. Declared as global, because it is manipulation inside much sub parsers.
		var week_stable = true;

		var blocks = [];

		for (var nblock = 0; nblock < tokens.length; nblock++) {
			if (tokens[nblock][0].length == 0) continue;
			// Block does contain nothing useful e.g. second block of '10:00-12:00;' (empty) which needs to be handled.

			var continue_at = 0;
			do {
				if (continue_at == tokens[nblock][0].length) break;
				// Block does contain nothing useful e.g. second block of '10:00-12:00,' (empty) which needs to be handled.

				var selectors = {
					// Time selectors
					time: [],

					// Temporary array of selectors from time wrapped to the next day
					wraptime: [],

					// Date selectors
					weekday: [],
					holiday: [],
					week: [],
					month: [],
					monthday: [],
					year: [],

					// Array with non-empty date selector types, with most optimal ordering
					date: [],

					fallback: tokens[nblock][1],
					additional: continue_at ? true : false,
					meaning: true,
					unknown: false,
					comment: undefined,
				};

				continue_at = parseGroup(tokens[nblock][0], continue_at, selectors, nblock);
				if (typeof continue_at == 'object')
					continue_at = continue_at[0];
				else
					continue_at = 0;

				if (selectors.year.length > 0)
					selectors.date.push(selectors.year);
				if (selectors.holiday.length > 0)
					selectors.date.push(selectors.holiday);
				if (selectors.month.length > 0)
					selectors.date.push(selectors.month);
				if (selectors.monthday.length > 0)
					selectors.date.push(selectors.monthday);
				if (selectors.week.length > 0)
					selectors.date.push(selectors.week);
				if (selectors.weekday.length > 0)
					selectors.date.push(selectors.weekday);

				blocks.push(selectors);

				// this handles selectors with time ranges wrapping over midnight (e.g. 10:00-02:00)
				// it generates wrappers for all selectors and creates a new block
				if (selectors.wraptime.length > 0) {
					var wrapselectors = {
						time: selectors.wraptime,
						date: [],

						meaning: selectors.meaning,
						unknown: selectors.unknown,
						comment: selectors.comment,

						wrapped: true,
					};

					for (var dselg = 0; dselg < selectors.date.length; dselg++) {
						wrapselectors.date.push([]);
						for (var dsel = 0; dsel < selectors.date[dselg].length; dsel++) {
							wrapselectors.date[wrapselectors.date.length-1].push(
									generateDateShifter(selectors.date[dselg][dsel], -msec_in_day)
								);
						}
					}

					blocks.push(wrapselectors);
				}
			} while (continue_at)
		}

		// Tokenization function: Splits string into parts.
		// output: array of arrays of pairs [content, type]
		function tokenize(value) {
			var all_tokens       = new Array();
			var curr_block_tokens = new Array();

			var last_block_fallback_terminated = false;

			while (value != '') {
				var tmp;
				if (tmp = value.match(/^(?:week\b|open|unknown)/i)) {
					// reserved word
					curr_block_tokens.push([tmp[0].toLowerCase(), tmp[0].toLowerCase(), value.length ]);
					value = value.substr(tmp[0].length);
				} else if (tmp = value.match(/^24\/7/i)) {
					// reserved word
					has_token[tmp[0]] = true;
					curr_block_tokens.push([tmp[0], tmp[0], value.length ]);
					value = value.substr(tmp[0].length);
				} else if (tmp = value.match(/^(?:off|closed)/i)) {
					// reserved word
					curr_block_tokens.push([tmp[0].toLowerCase(), 'closed', value.length ]);
					value = value.substr(tmp[0].length);
				} else if (tmp = value.match(/^(?:PH|SH)/i)) {
					// special day name (holidays)
					curr_block_tokens.push([tmp[0].toUpperCase(), 'holiday', value.length ]);
					value = value.substr(2);
				} else if (tmp = value.match(/^days?/i)) {
					curr_block_tokens.push([tmp[0].toLowerCase(), 'calcday', value.length ]);
					value = value.substr(tmp[0].length);
				} else if (tmp = value.match(/^(&|–|~|[a-zA-ZäÄàÀéÉ]+\b)\.?/i)) {
					// Handle all remaining words with error tolerance
					var correct_val = returnCorrectWordOrToken(tmp[1].toLowerCase(), value.length);
					if (typeof correct_val == 'object') {
						curr_block_tokens.push([ correct_val[0], correct_val[1], value.length ]);
						value = value.substr(tmp[0].length);
					} else if (typeof correct_val == 'string') {
						value = correct_val + value.substr(tmp[0].length);
					} else {
						// other single-character tokens
						curr_block_tokens.push([value[0].toLowerCase(), value[0].toLowerCase(), value.length - 1 ]);
						value = value.substr(1);
					}
				} else if (tmp = value.match(/^\d+/)) {
					// number
					if (tmp[0] > 1900) // assumed to be a year number
						curr_block_tokens.push([tmp[0], 'year', value.length ]);
					else
						curr_block_tokens.push([+tmp[0], 'number', value.length ]);
					value = value.substr(tmp[0].length);
				} else if (tmp = value.match(/^"([^"]*)"/)) {
					// comment
					curr_block_tokens.push([tmp[1], 'comment', value.length ]);
					value = value.substr(tmp[0].length);
				} else if (value.match(/^;/)) {
					// semicolon terminates block
					// next tokens belong to a new block
					all_tokens.push([ curr_block_tokens, last_block_fallback_terminated, value.length ]);
					value = value.substr(1);

					curr_block_tokens = [];
					last_block_fallback_terminated = false;
				} else if (value.match(/^\|\|/)) {
					// || terminates block
					// next tokens belong to a fallback block
					if (curr_block_tokens.length == 0)
						throw formatWarnErrorMessage(-1, value.length - 2, 'Rule before fallback rule does not contain anything useful');

					all_tokens.push([ curr_block_tokens, last_block_fallback_terminated, value.length ]);
					value = value.substr(2);

					curr_block_tokens = [];
					last_block_fallback_terminated = true;
				} else if (value.match(/^(?:␣|\s)/)) {
					// Using "␣" as space is not expected to be a normal mistake. Just ignore it to make using taginfo easier.
					value = value.substr(1);
				} else if (tmp = value.match(/^\s+/)) {
					// whitespace is ignored
					value = value.substr(tmp[0].length);
				} else if (value.match(/^[:.]/)) {
					// time separator
					if (value[0] == '.' && !done_with_warnings)
						parsing_warnings.push([ -1, value.length - 1, 'Please use ":" as hour/minute-separator' ]);
					curr_block_tokens.push([ ':', 'timesep', value.length ]);
					value = value.substr(1);
				} else {
					// other single-character tokens
					curr_block_tokens.push([value[0].toLowerCase(), value[0].toLowerCase(), value.length ]);
					value = value.substr(1);
				}
			}

			all_tokens.push([ curr_block_tokens, last_block_fallback_terminated ]);

			return all_tokens;
		}

		// error correction/tolerance
		function returnCorrectWordOrToken(word, value_length) {
			for (var token_name in word_error_correction) {
				for (var comment in word_error_correction[token_name]) {
					for (var old_val in word_error_correction[token_name][comment]) {
						if (old_val == word) {
							var val = word_error_correction[token_name][comment][old_val];
							if (token_name == 'wrong_words' && !done_with_warnings) {
								parsing_warnings.push([ -1, value_length - old_val.length,
									comment.replace(/<ko>/, old_val).replace(/<ok>/, val) ]);
								return val;
							} else if (comment != 'default'){
								var correct_abbr;
								for (correct_abbr in word_error_correction[token_name]['default']) {
									if (word_error_correction[token_name]['default'][correct_abbr] == val)
										break;
								}
								if (token_name != 'timevar') { // normally written in lower case
									correct_abbr = correct_abbr.charAt(0).toUpperCase() + correct_abbr.slice(1);
								}
								if (!done_with_warnings)
									parsing_warnings.push([ -1, value_length - old_val.length,
										comment.replace(/<ko>/, old_val).replace(/<ok>/, correct_abbr) ]);
							}
							return [ val, token_name ];
						}
					}
				}
			}
		}

		function getWarnings(it) {

			if (typeof it == 'object') { // getWarnings was called in a state without critical errors. We can do extended tests.

				// Check if 24/7 is used and it does not mean 24/7 because there are other rules. This can be avoided.
				var has_advanced = it.advance();

				if (has_advanced === true && has_token['24/7'] && !done_with_warnings) {
					parsing_warnings.push([ -1, 0, 'You used 24/7 in a way that is probably not interpreted as "24 hours 7 days a week".'
							// Probably because of: "24/7; 12:00-14:00 open", ". Needs extra testing.
							+ ' For correctness you might want to use "open" or "closed"'
							+ ' for this rule and then write your exceptions which should achieve the same goal and is more clear'
							+ ' e.g. "open; Mo 12:00-14:00 off".']);
				}
			}

			var warnings = [];
			for (var i = 0; i < parsing_warnings.length; i++) {
				warnings.push( formatWarnErrorMessage(parsing_warnings[i][0], parsing_warnings[i][1], parsing_warnings[i][2]) );
			}
			return warnings;
		}

		// Function to check token array for specific pattern
		function matchTokens(tokens, at /*, matches... */) {
			if (at + arguments.length - 2 > tokens.length)
				return false;
			for (var i = 0; i < arguments.length - 2; i++) {
				if (tokens[at + i][1] !== arguments[i + 2])
					return false;
			}

			return true;
		}

		function generateDateShifter(func, shift) {
			return function(date) {
				var res = func(new Date(date.getTime() + shift));

				if (typeof res[1] === 'undefined')
					return res;
				return [ res[0], new Date(res[1].getTime() - shift) ];
			}
		}

		//======================================================================
		// Top-level parser
		//======================================================================
		function parseGroup(tokens, at, selectors, nblock, conf) {
			var prettified_group_value = '';
			used_subparsers = { 'time ranges': 0 };

			// console.log(tokens); // useful for debugging of tokenize
			while (at < tokens.length) {
				var old_at = at;
				// console.log('Parsing at position', at +':', tokens[at]);
				if (matchTokens(tokens, at, 'weekday')) {
					at = parseWeekdayRange(tokens, at, selectors);
				} else if (matchTokens(tokens, at, '24/7')) {
					// selectors.time.push(function(date) { return [true]; });
					// Not needed. If there is no selector it automatically matches everything.
					at++;
				} else if (matchTokens(tokens, at, 'holiday')) {
					if (matchTokens(tokens, at+1, ','))
						at = parseHoliday(tokens, at, selectors, true);
					else
						at = parseHoliday(tokens, at, selectors, false);
					week_stable = false;
				} else if (matchTokens(tokens, at, 'month', 'number')
						|| matchTokens(tokens, at, 'month', 'weekday')
						|| matchTokens(tokens, at, 'year', 'month', 'number')
						|| matchTokens(tokens, at, 'year', 'event')
						|| matchTokens(tokens, at, 'event')) {
					at = parseMonthdayRange(tokens, at, nblock);
					week_stable = false;
				} else if (matchTokens(tokens, at, 'year')) {
					at = parseYearRange(tokens, at);
					week_stable = false;
				} else if (matchTokens(tokens, at, 'month')) {
					at = parseMonthRange(tokens, at);
					// week_stable = false; // decided based on actual values
				} else if (matchTokens(tokens, at, 'week')) {
					at = parseWeekRange(tokens, at + 1);
					week_stable = false;

					// if (prettified_group_value[-1] != ' ')
					// 	prettified_group_value = prettified_group_value.substring(0, prettified_group_value.length - 1);
				} else if (at != 0 && at != tokens.length - 1 && tokens[at][0] == ':') {
					// Ignore colon if they appear somewhere else than as time separator.
					// Except the start or end of the value.
					// This provides compatibility with the syntax proposed by Netzwolf:
					// http://wiki.openstreetmap.org/wiki/Key:opening_hours:specification
					if (!done_with_warnings && matchTokens(tokens, at-1, 'weekday') || matchTokens(tokens, at-1, 'holiday'))
						parsing_warnings.push([nblock, at, 'Please don’t use ":" after ' + tokens[at-1][1] + '.']);

					if (prettified_group_value[-1] != ' ')
						prettified_group_value = prettified_group_value.substring(0, prettified_group_value.length - 1);
					at++;
				} else if (matchTokens(tokens, at, 'number', 'timesep')
						|| matchTokens(tokens, at, 'timevar')
						|| matchTokens(tokens, at, '(', 'timevar')
						|| matchTokens(tokens, at, 'number', '-')) {
					at = parseTimeRange(tokens, at, selectors);

					if (typeof used_subparsers['time ranges'] != 'number')
						used_subparsers['time ranges'] = 1;
					else
						used_subparsers['time ranges']++;
				} else if (matchTokens(tokens, at, 'closed')) {
					selectors.meaning = false;
					at++;
					if (matchTokens(tokens, at, ',')) // additional block
						at = [ at + 1 ];

					if (typeof used_subparsers['state keywords'] != 'number')
						used_subparsers['state keywords'] = 1;
					else
						used_subparsers['state keywords']++;
				} else if (matchTokens(tokens, at, 'open')) {
					selectors.meaning = true;
					at++;
					if (matchTokens(tokens, at, ',')) // additional block
						at = [ at + 1 ];

					if (typeof used_subparsers['state keywords'] != 'number')
						used_subparsers['state keywords'] = 1;
					else
						used_subparsers['state keywords']++;
				} else if (matchTokens(tokens, at, 'unknown')) {
					selectors.meaning = false;
					selectors.unknown = true;
					at++;
					if (matchTokens(tokens, at, ',')) // additional block
						at = [ at + 1 ];

					if (typeof used_subparsers['state keywords'] != 'number')
						used_subparsers['state keywords'] = 1;
					else
						used_subparsers['state keywords']++;
				} else if (matchTokens(tokens, at, 'comment')) {
					selectors.comment = tokens[at][0];
					if (at > 0) {
						if (!matchTokens(tokens, at - 1, 'open')
							&& !matchTokens(tokens, at - 1, 'closed')) {
							// Then it is unknown. Either with unknown explicitly
							// specified or just a comment behind.
							selectors.meaning = false;
							selectors.unknown = true;
						}
					} else { // block starts with comment
						// selectors.time.push(function(date) { return [true]; });
						// Not needed. If there is no selector it automatically matches everything.
						selectors.meaning = false;
						selectors.unknown = true;
					}
					at++;
					if (matchTokens(tokens, at, ',')) // additional block
						at = [ at + 1 ];

					if (typeof used_subparsers['comments'] != 'number')
						used_subparsers['comments'] = 1;
					else
						used_subparsers['comments']++;
				} else {
					var warnings = getWarnings();
					throw formatWarnErrorMessage(nblock, at, 'Unexpected token: "' + tokens[at][1]
						+ '" This means that the syntax is not valid at that point or it is currently not supported.')
						+ (warnings ? ' ' + warnings.join('; ') : '');
				}

				if (typeof conf != 'undefined') {

					// 'Mo: 12:00-13:00' -> 'Mo 12:00-13:00'
					if (used_subparsers['time ranges'] && old_at > 1 && tokens[old_at-1][0] == ':'
							&& matchTokens(tokens, old_at - 2, 'weekday'))
						prettified_group_value = prettified_group_value.substring(0, prettified_group_value.length - 2) + ' ';

					// 'week 1, week 3' -> 'week 1,week 3'
					if (prettified_group_value.substr(prettified_group_value.length -2, 2) == ', '
							&& matchTokens(tokens, old_at, 'week'))
						prettified_group_value = prettified_group_value.substring(0, prettified_group_value.length - 1);

					prettified_group_value += prettifySelector(tokens, old_at, at, conf, used_subparsers['time ranges']);
				}

				if (typeof at == 'object') // additional block
					break;
			}

			prettified_value += prettified_group_value.replace(/\s+$/, '');

			if (!done_with_warnings) {
				for (var subparser_name in used_subparsers) {
					if (used_subparsers[subparser_name] > 1) {
						if (subparser_name.match(/^(?:comments|state keywords)/)) {
							parsing_warnings.push([nblock, at - 1, 'You have used ' + used_subparsers[subparser_name]
									+ ' ' + subparser_name + ' in one rule.'
									+ ' You may only use one in one rule.'
									+ ' Rules can be separated by ";".' ]);
						} else {
							parsing_warnings.push([nblock, at - 1, 'You have used ' + used_subparsers[subparser_name]
									+ ' not connected ' + subparser_name + ' in one rule.'
									+ ' This is probably an error.'
									+ ' Equal selector types can (and should) always be written in conjunction separated by comma or something.'
									+ ' Example for time ranges "12:00-13:00,15:00-18:00". Rules can be separated by ";".']);
						}
					}
				}
			}


			return at;
		}

		//======================================================================
		// Time range parser (10:00-12:00,14:00-16:00)
		//======================================================================
		function parseTimeRange(tokens, at, selectors) {
			for (; at < tokens.length; at++) {
				var has_time_var_calc = [], has_normal_time = []; // element 0: start time, 1: end time
				has_normal_time[0] = matchTokens(tokens, at, 'number', 'timesep', 'number');
				has_time_var_calc[0] = matchTokens(tokens, at, '(', 'timevar');
				if (has_normal_time[0] || matchTokens(tokens, at, 'timevar') || has_time_var_calc[0]) {
					// relying on the fact that always *one* of them is true

					var is_point_in_time = false; // no time range

					if (has_normal_time[0])
						var minutes_from = getMinutesByHoursMinutes(tokens, nblock, at+has_time_var_calc[0]);
					else
						var minutes_from = word_value_replacement[tokens[at+has_time_var_calc[0]][0]];

					var timevar_add = [ 0, 0 ];
					if (has_time_var_calc[0]) {
						timevar_add[0] = parseTimevarCalc(tokens, at);
						minutes_from += timevar_add[0];
					}

					var has_open_end = false;
					if (!matchTokens(tokens, at+(has_normal_time[0] ? 3 : (has_time_var_calc[0] ? 7 : 1)), '-')) {
						if (matchTokens(tokens, at+(has_normal_time[0] ? 3 : (has_time_var_calc[0] ? 7 : 1)), '+')) {
							has_open_end = true;
						} else {
							if (oh_mode == 0) {
								throw formatWarnErrorMessage(nblock, at+(has_normal_time[0] ? 3 : (has_time_var_calc[0] ? 2 : 1)),
									'hyphen (-) or open end (+) in time range '
									+ (has_time_var_calc[0] ? 'calculation ' : '')
									+ 'expected. For working with points in time, the mode for opening_hours.js has to be altered. Maybe wrong tag?');
							} else {
								var minutes_to = minutes_from + 1;
								is_point_in_time = true;
							}
						}
					}

					var at_end_time = at+(has_normal_time[0] ? 3 : (has_time_var_calc[0] ? 7 : 1))+1; // after '-'
					if (has_open_end) {
						if (minutes_from >= 22 * 60)
							var minutes_to = minutes_from + 60 * 8;
						else if (minutes_from >= 17 * 60)
							var minutes_to = minutes_from + 60 * 10;
						else
							var minutes_to = minutes_in_day;
					} else if (!is_point_in_time) {
						has_normal_time[1] = matchTokens(tokens, at_end_time, 'number', 'timesep', 'number');
						has_time_var_calc[1]      = matchTokens(tokens, at_end_time, '(', 'timevar');
						if (!has_normal_time[1] && !matchTokens(tokens, at_end_time, 'timevar') && !has_time_var_calc[1]) {
							if (!is_point_in_time)
								throw formatWarnErrorMessage(nblock, at_end_time, 'time range does not continue as expected');
						} else if (oh_mode == 1) {
							throw formatWarnErrorMessage(nblock, at_end_time, 'opening_hours is running in "points in time mode".'
								+ ' Found time range.');
						} else {
							if (has_normal_time[1])
								var minutes_to = getMinutesByHoursMinutes(tokens, nblock, at_end_time);
							else
								var minutes_to = word_value_replacement[tokens[at_end_time+has_time_var_calc[1]][0]];

							if (has_time_var_calc[1]) {
								timevar_add[1] = parseTimevarCalc(tokens, at_end_time);
								minutes_to += timevar_add[1];
							}

							// this shortcut makes always-open range check faster
							// and is also useful in tests, as it doesn't produce
							// extra check points which may hide errors in other
							// selectors
							// if (minutes_from == 0 && minutes_to == minutes_in_day)
							// 	selectors.time.push(function(date) { return [true]; });
							// Not needed. If there is no selector it automatically matches everything.
						}
					}

					// normalize minutes into range
					// XXX: what if it's further than tomorrow?
					// XXX: this is incorrect, as it assumes the same day
					//      should cooperate with date selectors to select the next day
					if (minutes_from >= minutes_in_day)
						throw formatWarnErrorMessage(nblock, at_end_time - 1,
							'Time range starts outside of the current day');
					if (minutes_to < minutes_from || ((has_normal_time[0] && has_normal_time[1]) && minutes_from == minutes_to))
						minutes_to += minutes_in_day;
					if (minutes_to > minutes_in_day * 2)
						throw formatWarnErrorMessage(nblock, at_end_time + (has_normal_time[1] ? 3 : (has_time_var_calc[1] ? 7 : 1)) - 1,
							'Time spanning more than two midnights not supported');

					var timevar_string = [];
					if (typeof lat != 'undefined') { // lon will also be defined (see above)
						if ((!has_normal_time[0] || !has_normal_time[1]) && !has_open_end)
							week_stable = false;
						if (!has_normal_time[0])
							timevar_string[0] = tokens[at+has_time_var_calc[0]][0];
						if (!has_normal_time[1] && !has_open_end && !is_point_in_time)
							timevar_string[1]   = tokens[at_end_time+has_time_var_calc[1]][0]
					} // else: we can not calculate exact times so we use the already applied constants (word_value_replacement).

					if (minutes_to > minutes_in_day) { // has_normal_time[1] must be true
						selectors.time.push(function(minutes_from, minutes_to, timevar_string, timevar_add, has_open_end, is_point_in_time) { return function(date) {
							var ourminutes = date.getHours() * 60 + date.getMinutes();

							if (timevar_string[0]) {
								var date_from = eval('SunCalc.getTimes(date, lat, lon).' + timevar_string[0]);
								minutes_from  = date_from.getHours() * 60 + date_from.getMinutes() + timevar_add[0];
							}
							if (timevar_string[1]) {
								var date_to = eval('SunCalc.getTimes(date, lat, lon).' + timevar_string[1]);
								minutes_to  = date_to.getHours() * 60 + date_to.getMinutes() + timevar_add[1];
								minutes_to += minutes_in_day;
								// Needs to be added because it was added by
								// normal times in: if (minutes_to < // minutes_from)
								// above the selector construction.
							} else if (is_point_in_time) {
								minutes_to = minutes_from + 1;
							}

							if (ourminutes < minutes_from)
								return [false, dateAtDayMinutes(date, minutes_from)];
							else
								return [true, dateAtDayMinutes(date, minutes_to), has_open_end];
						}}(minutes_from, minutes_to, timevar_string, timevar_add, has_open_end, is_point_in_time));

						selectors.wraptime.push(function(minutes_from, minutes_to, timevar_string, timevar_add, has_open_end, is_point_in_time) { return function(date) {
							var ourminutes = date.getHours() * 60 + date.getMinutes();

							if (timevar_string[0]) {
								var date_from = eval('SunCalc.getTimes(date, lat, lon).' + timevar_string[0]);
								minutes_from  = date_from.getHours() * 60 + date_from.getMinutes() + timevar_add[0];
							}
							if (timevar_string[1]) {
								var date_to = eval('SunCalc.getTimes(date, lat, lon).' + timevar_string[1]);
								minutes_to  = date_to.getHours() * 60 + date_to.getMinutes() + timevar_add[1];
								// minutes_in_day does not need to be added.
								// For normal times in it was added in: if (minutes_to < // minutes_from)
								// above the selector construction and
								// subtracted in the selector construction call
								// which returns the selector function.
							} else if (is_point_in_time) {
								minutes_to = minutes_from + 1;
							}

							if (ourminutes < minutes_to)
								return [true, dateAtDayMinutes(date, minutes_to), has_open_end];
							else
								return [false, undefined];
						}}(minutes_from, minutes_to - minutes_in_day, timevar_string, timevar_add, has_open_end, is_point_in_time));
					} else {
						selectors.time.push(function(minutes_from, minutes_to, timevar_string, timevar_add, has_open_end, is_point_in_time) { return function(date) {
							var ourminutes = date.getHours() * 60 + date.getMinutes();

							if (timevar_string[0]) {
								var date_from = eval('SunCalc.getTimes(date, lat, lon).' + timevar_string[0]);
								minutes_from  = date_from.getHours() * 60 + date_from.getMinutes() + timevar_add[0];
							}
							if (timevar_string[1]) {
								var date_to = eval('SunCalc.getTimes(date, lat, lon).' + timevar_string[1]);
								minutes_to  = date_to.getHours() * 60 + date_to.getMinutes() + timevar_add[1];
							} else if (is_point_in_time) {
								minutes_to = minutes_from + 1;
							}

							if (ourminutes < minutes_from)
								return [false, dateAtDayMinutes(date, minutes_from)];
							else if (ourminutes < minutes_to)
								return [true, dateAtDayMinutes(date, minutes_to), has_open_end];
							else
								return [false, dateAtDayMinutes(date, minutes_from + minutes_in_day)];
						}}(minutes_from, minutes_to, timevar_string, timevar_add, has_open_end, is_point_in_time));
					}

					at = at_end_time + (is_point_in_time ? -1 :
							(has_normal_time[1] ? 3 : (has_time_var_calc[1] ? 7 : !has_open_end))
							);
				} else if (matchTokens(tokens, at, 'number', '-', 'number')) { // "Mo 09-18" -> "Mo 09:00-18:00". Please don’t use this
					var minutes_from = tokens[at][0]   * 60;
					var minutes_to   = tokens[at+2][0] * 60;
					if (!done_with_warnings)
						parsing_warnings.push([nblock, at + 2,
							'Time range without minutes specified. Not very explicit! Please use this syntax instead e.g. "12:00-14:00".']);

					if (minutes_from >= minutes_in_day)
						throw formatWarnErrorMessage(nblock, at,
							'Time range starts outside of the current day');
					if (minutes_to < minutes_from)
						minutes_to += minutes_in_day;
					if (minutes_to > minutes_in_day * 2)
						throw formatWarnErrorMessage(nblock, at + 2,
							'Time spanning more than two midnights not supported');

					if (minutes_to > minutes_in_day) {
						selectors.time.push(function(minutes_from, minutes_to) { return function(date) {
							var ourminutes = date.getHours() * 60 + date.getMinutes();

							if (ourminutes < minutes_from)
								return [false, dateAtDayMinutes(date, minutes_from)];
							else
								return [true, dateAtDayMinutes(date, minutes_to)];
						}}(minutes_from, minutes_to));

						selectors.wraptime.push(function(minutes_from, minutes_to) { return function(date) {
							var ourminutes = date.getHours() * 60 + date.getMinutes();

							if (ourminutes < minutes_to)
								return [true, dateAtDayMinutes(date, minutes_to)];
							else
								return [false, undefined];
						}}(minutes_from, minutes_to - minutes_in_day));
					} else {
						selectors.time.push(function(minutes_from, minutes_to) { return function(date) {
							var ourminutes = date.getHours() * 60 + date.getMinutes();

							if (ourminutes < minutes_from)
								return [false, dateAtDayMinutes(date, minutes_from)];
							else if (ourminutes < minutes_to)
								return [true, dateAtDayMinutes(date, minutes_to), has_open_end];
							else
								return [false, dateAtDayMinutes(date, minutes_from + minutes_in_day)];
						}}(minutes_from, minutes_to));
					}

					at += 3;
				} else { // additional block
					if (matchTokens(tokens, at, '('))
						throw formatWarnErrorMessage(nblock, at+1, 'Missing variable time (e.g. sunrise) after: "' + tokens[at][1] + '"');
					if (matchTokens(tokens, at, 'number', 'timesep'))
						throw formatWarnErrorMessage(nblock, at+2, 'Missing minutes in time range after: "' + tokens[at+1][1] + '"');
					if (matchTokens(tokens, at, 'number'))
						throw formatWarnErrorMessage(nblock, at+2, 'Missing time seperator in time range after: "' + tokens[at][1] + '"');
					return [ at ];
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			return at;
		}

		// for given date, returns date moved to the start of specified day minute
		function dateAtDayMinutes(date, minutes) {
			return new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, minutes);
		}

		// extract the added or subtracted time of "(sunrise-01:30)"
		// returns in minutes e.g. -90
		function parseTimevarCalc(tokens, at) {
			if (matchTokens(tokens, at+2, '+') || matchTokens(tokens, at+2, '-')) {
				if (matchTokens(tokens, at+3, 'number', 'timesep', 'number')) {
					if (matchTokens(tokens, at+6, ')')) {
						var add_or_subtract = tokens[at+2][0] == '+' ? '1' : '-1';
						return (tokens[at+3][0] * 60 + tokens[at+5][0]) * add_or_subtract;
					} else {
						error = [ at+6, '. Missing ")".'];
					}
				} else {
					error = [ at+5, ' (time).'];
				}
			} else {
				error = [ at+2, '. "+" or "-" expected.'];
			}

			if (error)
				throw formatWarnErrorMessage(nblock, error[0],
					'Calculcation with variable time is not in the right syntax' + error[1]);
		}

		// Only used if throwing an error is wanted.
		function getMinutesByHoursMinutes(tokens, nblock, at) {
			if (tokens[at+2][0] > 59)
				throw formatWarnErrorMessage(nblock, at+2,
						'Minutes are greter than 59.');
			return tokens[at][0] * 60 + tokens[at+2][0];
		}

		//======================================================================
		// Weekday range parser (Mo,We-Fr,Sa[1-2,-1])
		//======================================================================
		function parseWeekdayRange(tokens, at, selectors) {
			for (; at < tokens.length; at++) {
				if (matchTokens(tokens, at, 'weekday', '[')) {
					// Conditional weekday (Mo[3])
					var numbers = [];

					// Get list of constraints
					var endat = parseNumRange(tokens, at+2, function(from, to, at) {

						// bad number
						if (from == 0 || from < -5 || from > 5)
							throw formatWarnErrorMessage(nblock, at,
								'Number between -5 and 5 (except 0) expected');

						if (from == to) {
							numbers.push(from);
						} else if (from < to) {
							for (var i = from; i <= to; i++) {
								// bad number
								if (i == 0 || i < -5 || i > 5)
									throw formatWarnErrorMessage(nblock, at+2,
										'Number between -5 and 5 (except 0) expected.');

								numbers.push(i);
							}
						} else {
							throw formatWarnErrorMessage(nblock, at+2,
								'Bad range: ' + from + '-' + to);
						}
					});

					if (!matchTokens(tokens, endat, ']'))
						throw formatWarnErrorMessage(nblock, endat, '"]" or more numbers expected.');

					var add_days = getMoveDays(tokens, endat+1, 6, 'constrained weekdays');
					week_stable = false;

					// Create selector for each list element
					for (var nnumber = 0; nnumber < numbers.length; nnumber++) {

						selectors.weekday.push(function(weekday, number, add_days) { return function(date) {
							var date_num = getValueForDate(date, false); // Year not needed to distinguish.
							var start_of_this_month = new Date(date.getFullYear(), date.getMonth(), 1);
							var start_of_next_month = new Date(date.getFullYear(), date.getMonth() + 1, 1);

							var target_day_this_month;

							target_day_this_month = getDateForConstrainedWeekday(date.getFullYear(), date.getMonth(), weekday, [ number ]);

							var target_day_with_added_days_this_month = new Date(target_day_this_month.getFullYear(),
								target_day_this_month.getMonth(), target_day_this_month.getDate() + add_days);

							// The target day with added days can be before this month
							if (target_day_with_added_days_this_month.getTime() < start_of_this_month.getTime()) {
								// but in this case, the target day without the days added needs to be in this month
								if (target_day_this_month.getTime() >= start_of_this_month.getTime()) {
									// so we calculate it for the month
									// following this month and hope that the
									// target day will actually be this month.

									target_day_with_added_days_this_month = dateAtNextWeekday(
										new Date(date.getFullYear(), date.getMonth() + (number > 0 ? 0 : 1) + 1, 1), weekday);
									target_day_this_month.setDate(target_day_with_added_days_this_month.getDate()
										+ (number + (number > 0 ? -1 : 0)) * 7 + add_days);
								} else {
									// Calculated target day is not inside this month
									// therefore the specified weekday (e.g. fifth Sunday)
									// does not exist this month. Try it next month.
									return [false, start_of_next_month];
								}
							} else if (target_day_with_added_days_this_month.getTime() >= start_of_next_month.getTime()) {
								// The target day is in the next month. If the target day without the added days is not in this month
								if (target_day_this_month.getTime() >= start_of_next_month.getTime())
									return [false, start_of_next_month];
							}

							if (add_days > 0) {
								var target_day_with_added_moved_days_this_month = dateAtNextWeekday(
									new Date(date.getFullYear(), date.getMonth() + (number > 0 ? 0 : 1) -1, 1), weekday);
								target_day_with_added_moved_days_this_month.setDate(target_day_with_added_moved_days_this_month.getDate()
									+ (number + (number > 0 ? -1 : 0)) * 7 + add_days);

								if (date_num == getValueForDate(target_day_with_added_moved_days_this_month, false))
									return [true, dateAtDayMinutes(date, minutes_in_day)];
							} else if (add_days < 0) {
								var target_day_with_added_moved_days_this_month = dateAtNextWeekday(
									new Date(date.getFullYear(), date.getMonth() + (number > 0 ? 0 : 1) + 1, 1), weekday);
								target_day_with_added_moved_days_this_month.setDate(target_day_with_added_moved_days_this_month.getDate()
									+ (number + (number > 0 ? -1 : 0)) * 7 + add_days);

								if (target_day_with_added_moved_days_this_month.getTime() >= start_of_next_month.getTime()) {
									if (target_day_with_added_days_this_month.getTime() >= start_of_next_month.getTime())
										return [false, target_day_with_added_moved_days_this_month];
								} else {
									if (target_day_with_added_days_this_month.getTime() < start_of_next_month.getTime()
										&& getValueForDate(target_day_with_added_days_this_month, false) == date_num)
										return [true, dateAtDayMinutes(date, minutes_in_day)];

									target_day_with_added_days_this_month = target_day_with_added_moved_days_this_month;
								}
							}

							// we hit the target day
							if (date.getDate() == target_day_with_added_days_this_month.getDate()) {
								return [true, dateAtDayMinutes(date, minutes_in_day)];
							}

							// we're before target day
							if (date.getDate() < target_day_with_added_days_this_month.getDate()) {
								return [false, target_day_with_added_days_this_month];
							}

							// we're after target day, set check date to next month
							return [false, start_of_next_month];
						}}(tokens[at][0], numbers[nnumber], add_days[0]));
					}

					at = endat + 1 + add_days[1];
				} else if (matchTokens(tokens, at, 'weekday')) {
					// Single weekday (Mo) or weekday range (Mo-Fr)
					var is_range = matchTokens(tokens, at+1, '-', 'weekday');

					var weekday_from = tokens[at][0];
					var weekday_to = is_range ? tokens[at+2][0] : weekday_from;

					var inside = true;

					// handle reversed range
					if (weekday_to < weekday_from) {
						var tmp = weekday_to;
						weekday_to = weekday_from - 1;
						weekday_from = tmp + 1;
						inside = false;
					}

					if (weekday_to < weekday_from) { // handle full range
						// selectors.weekday.push(function(date) { return [true]; });
						// Not needed. If there is no selector it automatically matches everything.
					} else {
						selectors.weekday.push(function(weekday_from, weekday_to, inside) { return function(date) {
							var ourweekday = date.getDay();

							if (ourweekday < weekday_from || ourweekday > weekday_to) {
								return [!inside, dateAtNextWeekday(date, weekday_from)];
							} else {
								return [inside, dateAtNextWeekday(date, weekday_to + 1)];
							}
						}}(weekday_from, weekday_to, inside));
					}

					at += is_range ? 3 : 1;
				} else if (matchTokens(tokens, at, 'holiday')) {
					week_stable = false;
					return parseHoliday(tokens, at, selectors, true);
				} else {
					throw formatWarnErrorMessage(nblock, at, 'Unexpected token in weekday range: ' + tokens[at][1]);
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			if (typeof used_subparsers['weekdays'] != 'number')
				used_subparsers['weekdays'] = 1;
			else
				used_subparsers['weekdays']++;

			return at;
		}

		// Numeric list parser (1,2,3-4,-1), used in weekday parser above
		function parseNumRange(tokens, at, func) {
			for (; at < tokens.length; at++) {
				if (matchTokens(tokens, at, 'number', '-', 'number')) {
					// Number range
					func(tokens[at][0], tokens[at+2][0], at);
					at += 3;
				} else if (matchTokens(tokens, at, '-', 'number')) {
					// Negative number
					func(-tokens[at+1][0], -tokens[at+1][0], at);
					at += 2
				} else if (matchTokens(tokens, at, 'number')) {
					// Single number
					func(tokens[at][0], tokens[at][0], at);
					at++;
				} else {
					throw formatWarnErrorMessage(nblock, at + matchTokens(tokens, at, '-'),
						'Unexpected token in number range: ' + tokens[at][1]);
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			return at;
		}

		function getMoveDays(tokens, at, max_differ, name) {
			var add_days = [ 0, 0 ]; // [ 'add days', 'how many tokens' ]
			add_days[0] = matchTokens(tokens, at, '+') || (matchTokens(tokens, at, '-') ? -1 : 0);
			if (add_days[0] != 0 && matchTokens(tokens, at+1, 'number', 'calcday')) {
				// continues with '+ 5 days' or something like that
				if (tokens[at+1][0] > max_differ)
					throw formatWarnErrorMessage(nblock, at+2,
						'There should be no reason to differ more than ' + max_differ + ' days from a ' + name + '. If so tell us …');
				add_days[0] *= tokens[at+1][0];
				if (add_days[0] == 0 && !done_with_warnings)
					parsing_warnings.push([ nblock, at+2, 'Adding 0 does not change the date. Please omit this.' ]);
				add_days[1] = 3;
			} else {
				add_days[0] = 0;
			}
			return add_days;
		}


		// for given date, returns date moved to the specific day of week
		function dateAtNextWeekday(date, day) {
			var delta = day - date.getDay();
			return new Date(date.getFullYear(), date.getMonth(), date.getDate() + delta + (delta < 0 ? 7 : 0));
		}

		//======================================================================
		// Holiday parser for public and school holidays (PH,SH)
		// push_to_weekday will push the selector into the weekday selector array which has the desired side effect of working in conjunction with the weekday selectors (either the holiday match or the weekday), which is the normal and expected behavior.
		//======================================================================
		function parseHoliday(tokens, at, selectors, push_to_weekday) {
			for (; at < tokens.length; at++) {
				if (matchTokens(tokens, at, 'holiday')) {
					if (tokens[at][0] == 'PH') {
						var applying_holidays = getMatchingHoliday(tokens[at][0]);

						// Only allow moving one day in the past or in the future.
						// This makes implementation easier because only one holiday is assumed to be moved to the next year.
						var add_days = getMoveDays(tokens, at+1, 1, 'public holiday');

						var selector = function(applying_holidays, add_days) { return function(date) {

							var holidays = getApplyingHolidaysForYear(applying_holidays, date.getFullYear(), add_days);
							// Needs to be calculated each time because of movable days.

							var date_num = getValueForDate(date, true);

							for (var i = 0; i < holidays.length; i++) {
								var next_holiday_date_num = getValueForDate(holidays[i][0], true);

								if (date_num < next_holiday_date_num) {

									if (add_days[0] > 0) {
										// Calculate the last holiday from previous year to tested against it.
										var holidays_last_year = getApplyingHolidaysForYear(applying_holidays, date.getFullYear() - 1, add_days);
										var last_holiday_last_year = holidays_last_year[holidays_last_year.length - 1];
										var last_holiday_last_year_num = getValueForDate(last_holiday_last_year[0], true);

										if (date_num < last_holiday_last_year_num ) {
											return [ false, last_holiday_last_year[0] ];
										} else if (date_num == last_holiday_last_year_num) {
											return [true, dateAtDayMinutes(last_holiday_last_year[0], minutes_in_day),
												'Day after ' +last_holiday_last_year[1] ];
										}
									}

									return [ false, holidays[i][0] ];
								} else if (date_num == next_holiday_date_num) {
									return [true, new Date(date.getFullYear(), date.getMonth(), date.getDate() + 1),
										(add_days[0] > 0 ? 'Day after ' : (add_days[0] < 0 ? 'Day before ' : '')) + holidays[i][1] ];
								}
							}

							if (add_days[0] < 0) {
								// Calculate the first holiday from next year to tested against it.
								var holidays_next_year = getApplyingHolidaysForYear(applying_holidays, date.getFullYear() + 1, add_days);
								var first_holidays_next_year = holidays_next_year[0];
								var first_holidays_next_year_num = getValueForDate(first_holidays_next_year[0], true);
								if (date_num == first_holidays_next_year_num) {
									return [true, dateAtDayMinutes(first_holidays_next_year[0], minutes_in_day),
										'Day before ' + first_holidays_next_year[1] ];
								}
							}

							// continue next year
							return [ false, new Date(holidays[0][0].getFullYear() + 1,
									holidays[0][0].getMonth(),
									holidays[0][0].getDate()) ];

						}}(applying_holidays, add_days);

						if (push_to_weekday)
							selectors.weekday.push(selector);
						else
							selectors.holiday.push(selector);

						at += 1 + add_days[1];
					} else if (tokens[at][0] == 'SH') {
						var applying_holidays = getMatchingHoliday(tokens[at][0]);

						var holidays = []; // needs to be sorted each time because of movable days

						var selector = function(applying_holidays) { return function(date) {
							var date_num = getValueForDate(date);

							// Iterate over holiday array containing the different holiday ranges.
							for (var i = 0; i < applying_holidays.length; i++) {

								var holiday = getSHForYear(applying_holidays[i], date.getFullYear());

								for (var h = 0; h < holiday.length; h+=4) {
									var holiday_to_plus = new Date(date.getFullYear(), holiday[2+h] - 1, holiday[3+h] + 1);
									var holiday_from = (holiday[0+h] - 1) * 100 + holiday[1+h];
									var holiday_to   = (holiday[2+h] - 1) * 100 + holiday[3+h];
									holiday_to_plus  = getValueForDate(holiday_to_plus);

									var holiday_ends_next_year = holiday_to < holiday_from;

									if (date_num < holiday_from) { // date is before selected holiday

										// check if we are in the holidays from the last year spanning into this year
										var last_year_holiday = getSHForYear(applying_holidays[applying_holidays.length - 1], date.getFullYear() - 1, false);
										if (typeof last_year_holiday != 'undefined') {
											var last_year_holiday_from = (last_year_holiday[last_year_holiday.length - 4] - 1) * 100
												+ last_year_holiday[last_year_holiday.length - 3]; // e.g. 1125
											var last_year_holiday_to   = (last_year_holiday[last_year_holiday.length - 2] - 1) * 100
												+ last_year_holiday[last_year_holiday.length - 1]; // e.g. 0005

											if (last_year_holiday_to < last_year_holiday_from && date_num < last_year_holiday_to)
												return [ true, new Date(date.getFullYear(),
													last_year_holiday[last_year_holiday.length - 2] - 1,
													last_year_holiday[last_year_holiday.length - 1] + 1),
													applying_holidays[applying_holidays.length - 1].name ];
											else
												return [ false, new Date(date.getFullYear(), holiday[0+h] - 1, holiday[1+h]) ];
										} else { // school holidays for last year are not defined.
											return [ false, new Date(date.getFullYear(), holiday[0+h] - 1, holiday[1+h]) ];
										}
									} else if (holiday_from <= date_num && (date_num < holiday_to_plus || holiday_ends_next_year)) {
										return [ true, new Date(date.getFullYear() + holiday_ends_next_year, holiday[2+h] - 1, holiday[3+h] + 1),
											applying_holidays[i].name ];
									} else if (holiday_to_plus == date_num) { // selected holiday end is equal to month and day
										if (h + 4 < holiday.length) { // next holiday is next date range of the same holidays
											h += 4;
											return [ false, new Date(date.getFullYear(), holiday[0+h] - 1, holiday[1+h]) ];
										} else {
											if (i + 1 == applying_holidays.length) { // last holidays are handled, continue all over again
												var holiday = getSHForYear(applying_holidays[0], date.getFullYear() + 1);
												return [ false, new Date(date.getFullYear() + !holiday_ends_next_year, holiday[0+h] - 1, holiday[1+h]) ];
											} else { // return the start of the next holidays
													var holiday = getSHForYear(applying_holidays[i+1], date.getFullYear());
													return [ false, new Date(date.getFullYear(), holiday[0] - 1, holiday[1]) ];
											}
										}
									}
								}
							}
							return [ false ];
						}}(applying_holidays);

						if (push_to_weekday)
							selectors.weekday.push(selector);
						else
							selectors.holiday.push(selector);
						at += 1;
					}
				} else if (matchTokens(tokens, at, 'weekday')) {
					return parseWeekdayRange(tokens, at, selectors);
				} else {
					throw formatWarnErrorMessage(nblock, at, 'Unexpected token (school holiday parser): ' + tokens[at][1]);
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			return at;
		}

		// Returns a number for a date which can then be used to compare just the dates (without the time).
		// This is necessary because a selector could be called for the middle of the day and we need to tell if it matches that day.
		// Example: Returns 20150015 for Jan 01 2015
		function getValueForDate(date, include_year) {
			// Implicit because undefined evaluates to false
			// include_year = typeof include_year != 'undefined' ? include_year : false;

			return (include_year ? date.getFullYear() * 10000 : 0) + date.getMonth() * 100 + date.getDate();
		}

		// return the school holiday definition e.g. [ 5, 25, /* to */ 6, 5 ],
		// for the specified year
		function getSHForYear(SH_hash, year, fatal) {
			if (typeof fatal == 'undefined')
				fatal = true;

			var holiday = SH_hash[year];
			if (typeof holiday == 'undefined') {
				holiday = SH_hash['default']; // applies for any year without explicit definition
				if (typeof holiday == 'undefined') {
					if (fatal) {
						throw 'School holiday ' + SH_hash.name + ' has no definition for the year ' + year + '.';
					} else {
						return undefined;
					}
				}
			}
			return holiday;
		}

		// Return closed holiday definition available.
		// First try to get the state, if missing get the country wide holidays
		// (which can be limited to some states).
		function getMatchingHoliday(type_of_holidays) {
			if (typeof location_cc != 'undefined') {
				if (holidays.hasOwnProperty(location_cc)) {
					if (typeof location_state != 'undefined') {
						if (holidays[location_cc][location_state]
								&& holidays[location_cc][location_state][type_of_holidays]) {
							// if holidays for the state are specified use it
							// and ignore lesser specific ones (for the country)
							return holidays[location_cc][location_state][type_of_holidays];
						} else if (holidays[location_cc][type_of_holidays]) {
							// holidays are only defined country wide
							matching_holiday = {}; // holidays in the country wide scope can be limited to certain states
							for (var holiday_name in holidays[location_cc][type_of_holidays]) {
								if (typeof holidays[location_cc][type_of_holidays][holiday_name][2] === 'object') {
									if (-1 != indexOf.call(holidays[location_cc][type_of_holidays][holiday_name][2], location_state))
										matching_holiday[holiday_name] = holidays[location_cc][type_of_holidays][holiday_name];
								} else {
									matching_holiday[holiday_name] = holidays[location_cc][type_of_holidays][holiday_name];
								}
							}
							if (Object.keys(matching_holiday).length == 0)
								throw 'There are no holidays ' + type_of_holidays + ' defined for country ' + location_cc + '.'
									+ ' Please add them: https://github.com/ypid/opening_hours.js ';
							return matching_holiday;
						} else {
							throw 'Holidays ' + type_of_holidays + ' are not defined for country ' + location_cc
								+ ' and state ' + location_state + '.'
								+ ' Please add them.';
						}
					}
				} else {
					throw 'No holidays are defined for country ' + location_cc + '. Please add them: https://github.com/ypid/opening_hours.js ';
				}
			} else { // we have no idea which holidays do apply because the country code was not provided
				throw 'Country code missing which is needed to select the correct holidays (see README how to provide it)'
			}
		}

		function getMovableEventsForYear(Y) {
			// calculate easter
			var C = Math.floor(Y/100);
			var N = Y - 19*Math.floor(Y/19);
			var K = Math.floor((C - 17)/25);
			var I = C - Math.floor(C/4) - Math.floor((C - K)/3) + 19*N + 15;
			I = I - 30*Math.floor((I/30));
			I = I - Math.floor(I/28)*(1 - Math.floor(I/28)*Math.floor(29/(I + 1))*Math.floor((21 - N)/11));
			var J = Y + Math.floor(Y/4) + I + 2 - C + Math.floor(C/4);
			J = J - 7*Math.floor(J/7);
			var L = I - J;
			var M = 3 + Math.floor((L + 40)/44);
			var D = L + 28 - 31*Math.floor(M/4);

			return {
				'easter': new Date(Y, M - 1, D),
			};
		}

		function indexOf(needle) {
			if(typeof Array.prototype.indexOf === 'function') {
				indexOf = Array.prototype.indexOf;
			} else {
				indexOf = function(needle) {
					var i = -1, index = -1;
					for(i = 0; i < this.length; i++) {
						if(this[i] === needle) {
							index = i;
							break;
						}
					}
					return index;
				};
			}
			return indexOf.call(this, needle);
		}

		function getApplyingHolidaysForYear(applying_holidays, year, add_days) {
			var movableDays = getMovableEventsForYear(year);

			var sorted_holidays = [];

			for (var holiday_name in applying_holidays) {
				if (typeof applying_holidays[holiday_name][0] == 'string') {
					var selected_movableDay = movableDays[applying_holidays[holiday_name][0]];
					if (!selected_movableDay)
						throw 'Movable day ' + applying_holidays[holiday_name][0] + ' can not not be calculated.'
							+ ' Please add the formula how to calculate it.';
					var next_holiday = new Date(selected_movableDay.getFullYear(),
							selected_movableDay.getMonth(),
							selected_movableDay.getDate()
							+ applying_holidays[holiday_name][1]
						);
					if (year != next_holiday.getFullYear())
						throw 'The movable day ' + applying_holidays[holiday_name][0] + ' plus '
							+ applying_holidays[holiday_name][1]
							+ ' days is not in the year of the movable day anymore. Currently not supported.';
				} else {
					var next_holiday = new Date(year,
							applying_holidays[holiday_name][0] - 1,
							applying_holidays[holiday_name][1]
						);
				}
				if (add_days[0])
					next_holiday.setDate(next_holiday.getDate() + add_days[0]);

				sorted_holidays.push([ next_holiday, holiday_name ]);
			}

			sorted_holidays = sorted_holidays.sort(function(a,b){
				if (a[0].getTime() < b[0].getTime()) return -1;
				if (a[0].getTime() > b[0].getTime()) return 1;
				return 0;
			});

			return sorted_holidays;
		}

		//======================================================================
		// Year range parser (2013,2016-2018,2020/2)
		//======================================================================
		function parseYearRange(tokens, at) {
			for (; at < tokens.length; at++) {
				if (matchTokens(tokens, at, 'year')) {
					var is_range = false, has_period = false;
					if (matchTokens(tokens, at+1, '-', 'year', '/', 'number')) {
						var is_range   = true;
						var has_period = true;
						if (!done_with_warnings && tokens[at+4][0] == 1)
							parsing_warnings.push([nblock, at+1+3, 'Please don’t use year ranges with period equals one (see README)']);
					} else {
						var is_range   = matchTokens(tokens, at+1, '-', 'year');
						var has_period = matchTokens(tokens, at+1, '/', 'number');
					}

					selectors.year.push(function(tokens, at, is_range, has_period) { return function(date) {
						var ouryear = date.getFullYear();
						var year_from = tokens[at][0];
						var year_to = is_range ? tokens[at+2][0] : year_from;

						// handle reversed range
						if (year_to < year_from) {
							var tmp = year_to;
							year_to = year_from;
							year_from = tmp;
						}

						if (ouryear < year_from ){
							return [false, new Date(year_from, 0, 1)];
						} else if (has_period) {
							if (year_from <= ouryear) {
								if (is_range) {
									var period = tokens[at+4][0];

									if (year_to < ouryear)
										return [false];
								} else {
									var period = tokens[at+2][0];
								}
								if (period > 0) {
									if ((ouryear - year_from) % period == 0) {
										return [true, new Date(ouryear + 1, 0, 1)];
									} else {
										return [false, new Date(ouryear + period - 1, 0, 1)];
									}
								}
							}
						} else if (is_range) {
							if (year_from <= ouryear && ouryear <= year_to)
								return [true, new Date(year_to + 1, 0, 1)];
						} else if (ouryear == year_from) {
							return [true];
						}

						return [false];

					}}(tokens, at, is_range, has_period));

					at += 1 + (is_range ? 2 : 0) + (has_period ? 2 : 0);
				} else {
					throw formatWarnErrorMessage(nblock, at, 'Unexpected token in year range: ' + tokens[at][1]);
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			if (typeof used_subparsers['year ranges'] != 'number')
				used_subparsers['year ranges'] = 1;
			else
				used_subparsers['year ranges']++;

			return at;
		}

		//======================================================================
		// Week range parser (week 11-20, week 1-53/2)
		//======================================================================
		function parseWeekRange(tokens, at) {
			for (; at < tokens.length; at++) {
				if (matchTokens(tokens, at, 'number')) {
					var is_range = matchTokens(tokens, at+1, '-', 'number'), has_period = false;
					if (is_range) {
						has_period = matchTokens(tokens, at+3, '/', 'number');
						// if (week_stable) {
						// 	if (tokens[at][0] == 1 && tokens[at+2][0] >) // Maximum?
						// 		week_stable = true;
						// 	else
						// 		week_stable = false;
						// } else {
						// 	week_stable = false;
						// }
					}

					selectors.week.push(function(tokens, at, is_range, has_period) { return function(date) {
						var ourweek = Math.floor((date - dateAtWeek(date, 0)) / msec_in_week);

						var week_from = tokens[at][0] - 1;
						var week_to = is_range ? tokens[at+2][0] - 1 : week_from;

						var start_of_next_year = new Date(date.getFullYear() + 1, 0, 1);

						// before range
						if (ourweek < week_from)
							return [false, getMinDate(dateAtWeek(date, week_from), start_of_next_year)];

						// we're after range, set check date to next year
						if (ourweek > week_to)
							return [false, start_of_next_year];

						// we're in range
						var period;
						if (has_period) {
							var period = tokens[at+4][0];
							if (period > 1) {
								var in_period = (ourweek - week_from) % period == 0;
								if (in_period)
									return [true, getMinDate(dateAtWeek(date, ourweek + 1), start_of_next_year)];
								else
									return [false, getMinDate(dateAtWeek(date, ourweek + period - 1), start_of_next_year)];
							}
						}

						return [true, getMinDate(dateAtWeek(date, week_to + 1), start_of_next_year)];
					}}(tokens, at, is_range, has_period));

					at += 1 + (is_range ? 2 : 0) + (has_period ? 2 : 0);
				} else {
					throw formatWarnErrorMessage(nblock, at, 'Unexpected token in week range: ' + tokens[at][1]);
				}

				if (!matchTokens(tokens, at, ','))
					break;

				if (!matchTokens(tokens, at+1, 'number')) {
					at++; // we don‘t need the comma in parseGroup
					break;
				}
			}

			if (typeof used_subparsers['week ranges'] != 'number')
				used_subparsers['week ranges'] = 1;
			else
				used_subparsers['week ranges']++;

			return at;
		}

		function dateAtWeek(date, week) {
			var tmpdate = new Date(date.getFullYear(), 0, 1);
			tmpdate.setDate(1 - (tmpdate.getDay() + 6) % 7 + week * 7); // start of week n where week starts on Monday
			return tmpdate;
		}

		function getMinDate(date /*, ...*/) {
			for (var i = 1; i < arguments.length; i++)
				if (arguments[i].getTime() < date.getTime())
					date = arguments[i];
			return date;
		}

		//======================================================================
		// Month range parser (Jan,Feb-Mar)
		//======================================================================
		function parseMonthRange(tokens, at) {
			for (; at < tokens.length; at++) {
				if (matchTokens(tokens, at, 'month')) {
					// Single month (Jan) or month range (Feb-Mar)
					var is_range = matchTokens(tokens, at+1, '-', 'month');

					if (is_range && week_stable) {
						var month_from = tokens[at][0];
						var month_to   = tokens[at+2][0];
						if (month_from == (month_to + 1) % 12)
							week_stable = true;
						else
							week_stable = false;
					} else {
						week_stable = false;
					}

					selectors.month.push(function(tokens, at, is_range) { return function(date) {
						var ourmonth = date.getMonth();
						var month_from = tokens[at][0];
						var month_to = is_range ? tokens[at+2][0] : month_from;

						var inside = true;

						// handle reversed range
						if (month_to < month_from) {
							var tmp = month_to;
							month_to = month_from - 1;
							month_from = tmp + 1;
							inside = false;
						}

						// handle full range
						if (month_to < month_from)
							return [!inside];

						if (ourmonth < month_from || ourmonth > month_to) {
							return [!inside, dateAtNextMonth(date, month_from)];
						} else {
							return [inside, dateAtNextMonth(date, month_to + 1)];
						}
					}}(tokens, at, is_range));

					at += is_range ? 3 : 1;
				} else {
					throw formatWarnErrorMessage(nblock, at, 'Unexpected token in month range: ' + tokens[at][1]);
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			if (typeof used_subparsers['months'] != 'number')
				used_subparsers['months'] = 1;
			else
				used_subparsers['months']++;

			return at;
		}

		function dateAtNextMonth(date, month) {
			return new Date(date.getFullYear(), month < date.getMonth() ? month + 12 : month);
		}

		function getConstrainedWeekday(tokens, at) {
			var number = 0;
			var endat = parseNumRange(tokens, at, function(from, to, at) {

				// bad number
				if (from == 0 || from < -5 || from > 5)
					throw formatWarnErrorMessage(nblock, at,
						'Number between -5 and 5 (except 0) expected');

				if (from == to) {
					if (number != 0)
						throw formatWarnErrorMessage(nblock, at,
							'You can not use a more than one constrained weekday in a month range');
					number = from;
				} else {
					throw formatWarnErrorMessage(nblock, at+2,
						'You can not use a range of constrained weekdays in a month range');
				}
			});

			if (!matchTokens(tokens, endat, ']'))
				throw formatWarnErrorMessage(nblock, endat, '"]" expected.');

			return [ number, endat + 1 ];
		}

		function getDateForConstrainedWeekday(year, month, weekday, constrained_weekday, add_days) {
			var tmp_date = dateAtNextWeekday(
				new Date(year, month + (constrained_weekday[0] > 0 ? 0 : 1), 1), weekday);

			tmp_date.setDate(tmp_date.getDate() + (constrained_weekday[0] + (constrained_weekday[0] > 0 ? -1 : 0)) * 7);

			if (typeof add_days != 'undefined' && add_days[1])
				tmp_date.setDate(tmp_date.getDate() + add_days[0]);

			return tmp_date;
		}

		//======================================================================
		// Month day range parser (Jan 26-31; Jan 26-Feb 26)
		//======================================================================
		function parseMonthdayRange(tokens, at, nblock) {
			for (; at < tokens.length; at++) {
				var has_year = [], has_month = [], has_event = [], has_calc = [], has_constrained_weekday = [], has_calc = [];
				has_year[0]  = matchTokens(tokens, at, 'year');
				has_month[0] = matchTokens(tokens, at+has_year[0], 'month', 'number');
				has_event[0] = matchTokens(tokens, at+has_year[0], 'event');
				if (has_event[0])
					has_calc[0] = getMoveDays(tokens, at+has_year[0]+1, 200, 'event like easter');

				if (matchTokens(tokens, at+has_year[0], 'month', 'weekday', '[')) {
					has_constrained_weekday[0] = getConstrainedWeekday(tokens, at+has_year[0]+3);
					has_calc[0] = getMoveDays(tokens, has_constrained_weekday[0][1], 6, 'constrained weekdays');
					var at_range_sep = has_constrained_weekday[0][1] + (typeof has_calc[0] != 'undefined' && has_calc[0][1] ? 3 : 0);
				} else {
					var at_range_sep = at+has_year[0]
						+ (has_event[0]
							? (typeof has_calc[0] != 'undefined' && has_calc[0][1] ? 4 : 1)
							: 2);
				}

				if ((has_month[0] || has_event[0] || has_constrained_weekday[0]) && matchTokens(tokens, at_range_sep, '-')) {
					has_year[1]  = matchTokens(tokens, at_range_sep+1, 'year');
					var at_sec_event_or_month = at_range_sep+1+has_year[1];
					has_month[1] = matchTokens(tokens, at_sec_event_or_month, 'month', 'number');
					if (!has_month[1]) {
						has_event[1] = matchTokens(tokens, at_sec_event_or_month, 'event');
						if (has_event[1]) {
							has_calc[1] = getMoveDays(tokens, at_sec_event_or_month+1, 366, 'event like easter');
						} else if (matchTokens(tokens, at_sec_event_or_month, 'month', 'weekday', '[')) {
							has_constrained_weekday[1] = getConstrainedWeekday(tokens, at_sec_event_or_month+3);
							has_calc[1] = getMoveDays(tokens, has_constrained_weekday[1][1], 6, 'constrained weekdays');
						}
					}
				}

				if (has_year[0] == has_year[1] && (has_month[1] || has_event[1] || has_constrained_weekday[1])) {

					selectors.monthday.push(function(tokens, at, nblock, has_year, has_event, has_calc, at_sec_event_or_month, has_constrained_weekday) { return function(date) {
						var start_of_next_year = new Date(date.getFullYear() + 1, 0, 1);

						if (has_event[0]) {
							var movableDays = getMovableEventsForYear(has_year[0] ? parseInt(tokens[at][0]) : date.getFullYear());
							var from_date   = movableDays[tokens[at+has_year[0]][0]];

							if (typeof has_calc[0] != 'undefined' && has_calc[0][1]) {
								var from_year_before_calc = from_date.getFullYear();
								from_date.setDate(from_date.getDate() + has_calc[0][0]);
								if (from_year_before_calc != from_date.getFullYear())
									throw formatWarnErrorMessage(nblock, at+has_year[0]+has_calc[0][1]*3,
										'The movable day ' + tokens[at+has_year[0]][0] + ' plus ' + has_calc[0][0]
										+ ' days is not in the year of the movable day anymore. Currently not supported.');
							}
						} else if (has_constrained_weekday[0]) {
							var from_date = getDateForConstrainedWeekday((has_year[0] ? tokens[at][0] : date.getFullYear()), // year
								tokens[at+has_year[0]][0], // month
								tokens[at+has_year[0]+1][0], // weekday
								has_constrained_weekday[0],
								has_calc[0]);
							// var from_date_without_calc = getDateForConstrainedWeekday((has_year[0] ? tokens[at][0] : date.getFullYear()), // year
							// 	tokens[at+has_year[0]][0], // month
							// 	tokens[at+has_year[0]+1][0], // weekday
							// 	has_constrained_weekday[0],
							// 	[ 0, 0 ]);
							// 	if (from_date_without_calc.getFullYear() != from_date.getFullYear())
							// 		throw formatWarnErrorMessage(nblock, at+has_year[0]+has_calc[0][1],
							// 			'The constrained ' + weekdays[tokens[at+has_year[0]+1][0]] + ' plus ' + has_calc[0][0]
							// 			+ ' days is not in the year of the movable day anymore. Currently not supported.');
						} else {
							var from_date = new Date((has_year[0] ? tokens[at][0] : date.getFullYear()),
								tokens[at+has_year[0]][0], tokens[at+has_year[0]+1][0]);
						}

						if (has_event[1]) {
							var movableDays = getMovableEventsForYear(has_year[1]
										? parseInt(tokens[at_sec_event_or_month-1][0])
										: date.getFullYear());
							var to_date     = movableDays[tokens[at_sec_event_or_month][0]];

							if (typeof has_calc[1] != 'undefined' && has_calc[1][1]) {
								var to_year_before_calc = to_date.getFullYear();
								to_date.setDate(to_date.getDate() + has_calc[1][0]);
								if (to_year_before_calc != to_date.getFullYear())
									throw formatWarnErrorMessage(nblock, at_sec_event_or_month+has_calc[1][1],
										'The movable day ' + tokens[at_sec_event_or_month][0] + ' plus ' + has_calc[1][0]
										+ ' days is not in the year of the movable day anymore. Currently not supported.');
							}
						} else if (has_constrained_weekday[1]) {
							var to_date = getDateForConstrainedWeekday((has_year[1] ? tokens[at_sec_event_or_month-1][0] : date.getFullYear()), // year
								tokens[at_sec_event_or_month][0],   // month
								tokens[at_sec_event_or_month+1][0], // weekday
								has_constrained_weekday[1],
								has_calc[1]);
						} else {
							var to_date = new Date((has_year[1] ? tokens[at_sec_event_or_month-1][0] : date.getFullYear()),
								tokens[at_sec_event_or_month][0], tokens[at_sec_event_or_month+1][0] + 1);
						}

						var inside = true;

						if (to_date < from_date) {
							var tmp = to_date;
							to_date = from_date;
							from_date = tmp;
							inside = false;
						}

						if (date.getTime() < from_date.getTime()) {
							return [!inside, from_date];
						} else if (date.getTime() < to_date.getTime()) {
							return [inside, to_date];
						} else {
							if (has_year[0]) {
								return [!inside];
							} else {
								// // back matching, if from_date is moved to last year
								// var from_date_next_year = getDateForConstrainedWeekday(date.getFullYear() + 1, // year
								// 	tokens[at+has_year[0]][0], // month
								// 	tokens[at+has_year[0]+1][0], // weekday
								// 	has_constrained_weekday[0],
								// 	has_calc[0]);
								// if (date.getFullYear() == from_date_next_year.getFullYear()) {
								// 	if (date.getTime() < from_date_next_year.getTime()) {
								// 		return [!inside, from_date_next_year];
								// 	}
								// }

								return [!inside, start_of_next_year];
							}
						}
					}}(tokens, at, nblock, has_year, has_event, has_calc, at_sec_event_or_month, has_constrained_weekday));

					at = (has_constrained_weekday[1]
							? has_constrained_weekday[1][1]
							: at_sec_event_or_month + (has_event[1] ? 1 : 2))
						+ (typeof has_calc[1] != 'undefined' ? has_calc[1][1] : 0);

				} else if (has_month[0]) {

					var is_range = matchTokens(tokens, at+2+has_year[0], '-', 'number'), has_period = false;
					if (is_range)
						has_period = matchTokens(tokens, at+4+has_year[0], '/', 'number');

					var at_timesep_if_monthRange = at + has_year[0] + 1 // at month number
						+ (is_range ? 2 : 0) + (has_period ? 2 : 0)
						+ !(is_range || has_period); // if not range nor has_period, add one

					if (matchTokens(tokens, at_timesep_if_monthRange, 'timesep', 'number')
							&& (matchTokens(tokens, at_timesep_if_monthRange+2, '+')
								|| matchTokens(tokens, at_timesep_if_monthRange+2, '-')))
						return parseMonthRange(tokens, at);

					selectors.monthday.push(function(tokens, at, is_range, has_period, has_year) { return function(date) {
						var start_of_next_year = new Date(date.getFullYear() + 1, 0, 1);

						var from_date = new Date((has_year ? tokens[at][0] : date.getFullYear()),
							tokens[at+has_year][0], tokens[at+1 + has_year][0]);
						var to_date   = new Date(from_date.getFullYear(), from_date.getMonth(),
							tokens[at+(is_range ? 3 : 1)+has_year][0] + 1);

						if (date.getTime() < from_date.getTime())
							return [false, from_date];
						else if (date.getTime() >= to_date.getTime())
							return [false, start_of_next_year];
						else if (!has_period)
							return [true, to_date];

						var period = tokens[at+has_year+5][0];
						if (!done_with_warnings && period == 1)
							parsing_warnings.push([nblock, at+has_year+5, 'Please don’t use day ranges with period equals one (see README)']);
						var nday = Math.floor((date.getTime() - from_date.getTime()) / msec_in_day);
						var in_period = nday % period;

						if (in_period == 0)
							return [true, new Date(date.getFullYear(), date.getMonth(), date.getDate() + 1)];
						else
							return [false, new Date(date.getFullYear(), date.getMonth(), date.getDate() + period - in_period)];

					}}(tokens, at, is_range, has_period, has_year[0]));

					at += 2 + has_year[0] + (is_range ? 2 : 0) + (has_period ? 2 : 0);

				} else if (has_event[0]) {

					selectors.monthday.push(function(tokens, at, nblock, has_event, has_year, add_days) { return function(date) {

						// console.log('enter selector with date: ' + date);
						var movableDays = getMovableEventsForYear((has_year ? tokens[at][0] : date.getFullYear()));
						var event_date = movableDays[tokens[at+has_year][0]];
						if (!event_date)
							throw 'Movable day ' + tokens[at+has_year][0] + ' can not not be calculated.'
								+ ' Please add the formula how to calculate it.';

						if (add_days[0]) {
							event_date.setDate(event_date.getDate() + add_days[0]);
							if (date.getFullYear() != event_date.getFullYear())
								throw formatWarnErrorMessage(nblock, at+has_year+add_days[1], 'The movable day ' + tokens[at+has_year][0] + ' plus '
									+ add_days[0]
									+ ' days is not in the year of the movable day anymore. Currently not supported.');
						}

						if (date.getTime() < event_date.getTime())
							return [false, event_date];
						// else if (date.getTime() < event_date.getTime() + msec_in_day) // does not work because of daylight saving times
						else if (event_date.getMonth() * 100 + event_date.getDate() == date.getMonth() * 100 + date.getDate())
							return [true, new Date(date.getFullYear(), date.getMonth(), date.getDate() + 1)];
						else
							return [false, new Date(date.getFullYear() + 1, 0, 1)];

					}}(tokens, at, nblock, has_event[0], has_year[0], has_calc[0]));

					at += has_year[0] + has_event[0] + (typeof has_calc[0][1] != 'undefined' && has_calc[0][1] ? 3 : 0);
				} else if (has_constrained_weekday[0]) {
					at = parseMonthRange(tokens, at);
				} else if (matchTokens(tokens, at, 'month')) {
					return parseMonthRange(tokens, at);
				} else {
					// throw 'Unexpected token in monthday range: "' + tokens[at] + '"';
					return at;
				}

				if (!matchTokens(tokens, at, ','))
					break;
			}

			if (typeof used_subparsers['monthday ranges'] != 'number')
				used_subparsers['monhday ranges'] = 1;
			else
				used_subparsers['monhday ranges']++;

			// console.log(tokens[at-1], 'return');
			return at;
		}

		//======================================================================
		// Main selector traversal function
		//======================================================================
		this.getStatePair = function(date) {
			var resultstate = false;
			var changedate;
			var unknown = false;
			var comment = undefined;
			var match_block;

			var date_matching_blocks = [];

			for (var nblock = 0; nblock < blocks.length; nblock++) {
				var matching_date_block = true;
				// console.log(nblock, 'length',  blocks[nblock].date.length);

				// Try each date selector type
				for (var ndateselector = 0; ndateselector < blocks[nblock].date.length; ndateselector++) {
					var dateselectors = blocks[nblock].date[ndateselector];
					// console.log(nblock, ndateselector);

					var has_matching_selector = false;
					for (var datesel = 0; datesel < dateselectors.length; datesel++) {
						var res = dateselectors[datesel](date);
						if (res[0]) {
							has_matching_selector = true;

							if (typeof res[2] == 'string') { // holiday name
								comment = [ res[2] ];
							}

						}
						if (typeof changedate === 'undefined' || (typeof res[1] !== 'undefined' && res[1].getTime() < changedate.getTime()))
							changedate = res[1];
					}

					if (!has_matching_selector) {
						matching_date_block = false;
						// We can ignore other date selectors, as the state won't change
						// anyway until THIS selector matches (due to conjunction of date
						// selectors of different types).
						// This is also an optimization, if widest date selector types
						// are checked first.
						break;
					}

				}

				if (matching_date_block) {
					// The following lines implement date overwriting logic (e.g. for
					// "Mo-Fr 10:00-20:00; We 10:00-16:00", We block overrides Mo-Fr block.
					//
					// This is the only way to be consistent. I thought about ("22:00-02:00; Tu 12:00-14:00") letting Th override 22:00-02:00 partly:
					// Like: Th 00:00-02:00,12:00-14:00 but this would result in including 22:00-00:00 for Th which is probably not what you want.
					if (blocks[nblock].date.length > 0 && (blocks[nblock].meaning || blocks[nblock].unknown)
							&& !blocks[nblock].wrapped && !blocks[nblock].additional && !blocks[nblock].fallback) {
						// var old_date_matching_blocks = date_matching_blocks;
						date_matching_blocks = [];
						// for (var nblock = 0; nblock < old_date_matching_blocks.length; nblock++) {
						// 	if (!blocks[old_date_matching_blocks[nblock]].wrapped)
						// 		date_matching_blocks.push(nblock);
						// }
					}
					date_matching_blocks.push(nblock);
				}
			}

			block:
			for (var nblock = 0; nblock < date_matching_blocks.length; nblock++) {
				var block = date_matching_blocks[nblock];

				// console.log('Processing block ' + block + ':\t' + blocks[block].comment + '    with date', date,
				// 	'and', blocks[block].time.length, 'time selectors');

				// there is no time specified, state applies to the whole day
				if (blocks[block].time.length == 0) {
					// console.log('there is no time', date);
					if (!blocks[block].fallback || (blocks[block].fallback && !(resultstate || unknown))) {
						resultstate = blocks[block].meaning;
						unknown     = blocks[block].unknown;
						match_block = block;

						if (typeof blocks[block].comment != 'undefined')
							comment     = blocks[block].comment;
						else if (typeof comment == 'object') // holiday name
							comment = comment[0];

						if (blocks[block].fallback)
							break block; // fallback block matched, no need for checking the rest
					}
				}

				for (var timesel = 0; timesel < blocks[block].time.length; timesel++) {
					var res = blocks[block].time[timesel](date);

					// console.log('res:', res);
					if (res[0]) {
						if (!blocks[block].fallback || (blocks[block].fallback && !(resultstate || unknown))) {
							resultstate = blocks[block].meaning;
							unknown     = blocks[block].unknown;
							match_block = block;

							if (typeof blocks[block].comment != 'undefined') // only use comment if one is specified
								comment     = blocks[block].comment;
							else if (typeof comment == 'object') // holiday name
								comment = comment[0];
							else if (comment === 'Specified as open end. Closing time was guessed.')
								comment = blocks[block].comment;

							// open end
							if (typeof res[2] == 'boolean' && res[2] && (resultstate || unknown)) {
								if (typeof comment == 'undefined')
									comment = 'Specified as open end. Closing time was guessed.';
								resultstate = false;
								unknown     = true;
							}

							if (blocks[block].fallback) {
								if (typeof changedate === 'undefined' || (typeof res[1] !== 'undefined' && res[1] < changedate))
									changedate = res[1];

								break block; // fallback block matched, no need for checking the rest
							}
						}
					}
					if (typeof changedate === 'undefined' || (typeof res[1] !== 'undefined' && res[1] < changedate))
						changedate = res[1];
				}
			}

			// console.log('changedate', changedate, resultstate, comment, match_block);
			return [ resultstate, changedate, unknown, comment, match_block ];
		}

		function formatWarnErrorMessage(nblock, at, message) {
			var pos = 0;
			if (nblock == -1) { // usage of block index not required because we do have access to value.length
				pos = value.length - at;
			} else { // Issue accrued at a later time, position in string needs to be reconstructed.
				if (typeof tokens[nblock][0][at] == 'undefined') {
					pos = value.length;
				} else {
					pos = value.length;
					if (typeof tokens[nblock][0][at+1] != 'undefined')
						pos -= tokens[nblock][0][at+1][2];
					else if (typeof tokens[nblock][2] != 'undefined')
						pos -= tokens[nblock][2];
				}
			}
			return value.substring(0, pos) + ' <--- (' + message + ')';
		}

		function prettifySelector(tokens, at, last_at, conf, used_parseTimeRange) {
			var value = '';
			var start_at = at;
			while (at < last_at) {
				if (matchTokens(tokens, at, 'weekday')) { // FIXME
					if (!conf.leave_weekday_sep_one_day_betw
						&& at - start_at > 1 && (matchTokens(tokens, at-1, ',') || matchTokens(tokens, at-1, '-'))
						&& matchTokens(tokens, at-2, 'weekday')
						&& tokens[at][0] == (tokens[at-2][0] + 1) % 7)  {
							value = value.substring(0, value.length - 1) + conf.sep_one_day_between;
					}
					value += weekdays[tokens[at][0]];
				} else if (at - start_at > 0 && used_parseTimeRange > 0 && matchTokens(tokens, at-1, 'timesep')
						&& matchTokens(tokens, at, 'number')) { // '09:0' -> '09:00'
					value += (tokens[at][0] < 10 ? '0' : '') + tokens[at][0].toString();
				} else if (used_parseTimeRange > 0 && conf.leading_zero_hour && at != tokens.length
						&& matchTokens(tokens, at, 'number')
						&& matchTokens(tokens, at+1, 'timesep')) { // '9:00' -> '19:00'
					value += (tokens[at][0] < 10 ? (tokens[at][0] == 0 && conf.one_zero_if_hour_zero ? '' : '0') : '') + tokens[at][0].toString();
				} else if (used_parseTimeRange > 0 && at + 2 < last_at
						&& matchTokens(tokens, at, 'number')
						&& matchTokens(tokens, at+1, '-')
						&& matchTokens(tokens, at+2, 'number')) { // '9-18' -> '09:00-18:00'
					value += (tokens[at][0] < 10 ? (tokens[at][0] == 0 && conf.one_zero_if_hour_zero ? '' : '0') : '') + tokens[at][0].toString();
					value += ':00-';
					value += (tokens[at+2][0] < 10 ? '0' : '') + tokens[at+2][0].toString();
					value += ':00';
					at += 3;
				} else if (matchTokens(tokens, at, 'comment')) {
					value += '"' + tokens[at][0].toString() + '"';
				} else if (matchTokens(tokens, at, 'closed')) {
					value += (conf.leave_off_closed ? tokens[at][0] : conf.keyword_for_off_closed);
				} else if (at - start_at > 0 && matchTokens(tokens, at, 'number')
						&& (matchTokens(tokens, at-1, 'month')
						||  matchTokens(tokens, at-1, 'week')
						)) {
					value += ' ' + tokens[at][0];
				} else if (at - start_at > 0 && matchTokens(tokens, at, 'month')
						&& matchTokens(tokens, at-1, 'year')) {
					value += ' ' + months[[tokens[at][0]]];
				} else if (at - start_at > 0 && matchTokens(tokens, at, 'event')
						&& matchTokens(tokens, at-1, 'year')) {
					value += ' ' + tokens[at][0];
				} else if (matchTokens(tokens, at, 'month')) {
					value += months[[tokens[at][0]]];
					if (at + 1 < last_at && matchTokens(tokens, at+1, 'weekday'))
						value += ' ';
				} else if (at + 2 < last_at
						&& (matchTokens(tokens, at, '-') || matchTokens(tokens, at, '+'))
						&& matchTokens(tokens, at+1, 'number', 'calcday')) {
					value += ' ' + tokens[at][0] + tokens[at+1][0] + ' day' + (Math.abs(tokens[at+1][0]) == 1 ? '' : 's');
					at += 2;
				} else {
					// if (matchTokens(tokens, at, 'open') || matchTokens(tokens, at, 'unknown'))
					// 	value += ' ';

					value += tokens[at][0].toString();
				}
				at++;
			}
			return value + ' ';
		}

		//======================================================================
		// Public interface
		// All functions below are considered public.
		//======================================================================

		//======================================================================
		// Iterator interface
		//======================================================================
		this.getIterator = function(date) {
			return new function(oh) {
				if (typeof date === 'undefined')
					date = new Date();

				var prevstate = [ undefined, date, undefined, undefined, undefined ];
				var state = oh.getStatePair(date);

				this.setDate = function(date) {
					if (typeof date != 'object')
						throw 'Date as parameter needed.';

					prevstate = [ undefined, date, undefined, undefined, undefined ];
					state     = oh.getStatePair(date);
				}

				this.getDate = function() {
					return prevstate[1];
				}

				this.getState = function() {
					return state[0];
				}

				this.getUnknown = function() {
					return state[2];
				}

				this.getStateString = function(past) {
					return (state[0] ? 'open' : (state[2] ? 'unknown' : (past ? 'closed' : 'close')));
				}

				this.getComment = function() {
					return state[3];
				}

				this.getMatchingRule = function(user_conf) {
					if (typeof state[4] == 'undefined')
						return undefined;

					if (typeof user_conf != 'object')
						var user_conf = {};
					for (key in default_prettify_conf) {
						if (typeof user_conf[key] != 'undefined')
							user_conf[key] = default_prettify_conf[key];
					}

					var really_done_with_warnings = done_with_warnings; // getWarnings can be called later.
					done_with_warnings = true;
					prettified_value = '';
					var selectors = { // Not really needed. This whole thing is only necessary because of the token used for additional blocks.
						time: [], weekday: [], holiday: [], week: [], month: [], monthday: [], year: [], wraptime: [],

						fallback: false, // does not matter
						additional: false,
						meaning: true,
						unknown: false,
						comment: undefined,
					};

					parseGroup(tokens[state[4]][0], 0, selectors, state[4], user_conf);

					done_with_warnings = really_done_with_warnings;

					return prettified_value;
				}

				this.advance = function(datelimit) {
					if (typeof datelimit === 'undefined')
						datelimit = new Date(prevstate[1].getTime() + msec_in_day * 366 * 5);
					else if (datelimit.getTime() <= prevstate[1].getTime())
						return false; // The limit for advance needs to be after the current time.

					do {
						// open range, we won't be able to advance
						if (typeof state[1] === 'undefined')
							return false;

						// console.log('\n' + 'previous check time:', prevstate[1]
						// 	+ ', current check time:',
						// 	// (state[1].getHours() < 10 ? '0' : '') + state[1].getHours() +
						// 	// ':'+(state[1].getMinutes() < 10 ? '0' : '')+ state[1].getMinutes(), state[1].getDate(),
						// 	state[1],
						// 	(state[0] ? 'open' : (state[2] ? 'unknown' : 'closed')) + ', comment:', state[3]);

						// We're going backwards or staying at place.
						// This always indicates coding error in a selector code.
						if (state[1].getTime() <= prevstate[1].getTime())
							throw 'Fatal: infinite loop in nextChange';

						// don't advance beyond limits (same as open range)
						if (state[1].getTime() >= datelimit.getTime())
							return false;

						// do advance
						prevstate = state;
						state = oh.getStatePair(prevstate[1]);
					} while (state[0] === prevstate[0] && state[2] === prevstate[2] && state[3] === prevstate[3]);
					return true;
				}
			}(this);
		}

		// get parse warnings
		// returns an empty string if there are no warnings
		this.getWarnings = function() {
			var it = this.getIterator();
			return getWarnings(it);
		}

		// get a nicely formated value.
		this.prettifyValue = function(user_conf) {
			if (typeof user_conf != 'object')
				var user_conf = {};

			for (key in default_prettify_conf) {
				if (typeof user_conf[key] == 'undefined')
					user_conf[key] = default_prettify_conf[key];
			}

			var really_done_with_warnings = done_with_warnings; // getWarnings can be called later.
			done_with_warnings = true;

			prettified_value = '';
			for (var nblock = 0; nblock < tokens.length; nblock++) {
				if (tokens[nblock][0].length == 0) continue;
				// Block does contain nothing useful e.g. second block of '10:00-12:00;' (empty) which needs to be handled.

				if (nblock != 0)
					prettified_value += (tokens[nblock][1]
						?  user_conf.block_sep_string + '|| '
						: (user_conf.print_semicolon ? ';' : '') + user_conf.block_sep_string);

				var continue_at = 0;
				do {
					if (continue_at == tokens[nblock][0].length) break;
					// Block does contain nothing useful e.g. second block of '10:00-12:00,' (empty) which needs to be handled.

					var selectors = { // Not really needed. This whole thing is only necessary because of the token used for additional blocks.
						time: [], weekday: [], holiday: [], week: [], month: [], monthday: [], year: [], wraptime: [],

						fallback: tokens[nblock][1],
						additional: continue_at ? true : false,
						meaning: true,
						unknown: false,
						comment: undefined,
					};

					continue_at = parseGroup(tokens[nblock][0], continue_at, selectors, nblock, user_conf);

					if (typeof continue_at == 'object') {
						continue_at = continue_at[0];
						prettified_value += user_conf.block_sep_string;
					} else {
						continue_at = 0;
					}

				} while (continue_at)
			}

			done_with_warnings = really_done_with_warnings;

			return prettified_value;
		}

		// check whether facility is `open' on the given date (or now)
		this.getState = function(date) {
			var it = this.getIterator(date);
			return it.getState();
		}

		// If the state of a amenity is conditional. Conditions can be expressed in comments.
		// True will only be returned if the state is false as the getState only
		// returns true if the amenity is really open. So you may want to check
		// the resold of getUnknown if getState returned false.
		this.getUnknown = function(date) {
			var it = this.getIterator(date);
			return it.getUnknown();
		}

		// Return state string. Either 'open', 'unknown' or 'closed'.
		this.getStateString = function(date, past) {
			var it = this.getIterator(date);
			return it.getStateString(past);
		}

		// Returns the comment.
		// Most often this will be an empty string as comments are not used that
		// often in OSM yet.
		this.getComment = function(date) {
			var it = this.getIterator(date);
			return it.getComment();
		}

		this.getMatchingRule = function(date) {
			var it = this.getIterator(date);
			return it.getMatchingRule();
		}

		// returns time of next status change
		this.getNextChange = function(date, maxdate) {
			var it = this.getIterator(date);
			if (!it.advance(maxdate))
				return undefined;
			return it.getDate();
		}

		// return array of open intervals between two dates
		this.getOpenIntervals = function(from, to) {
			var res = [];

			var it = this.getIterator(from);

			if (it.getState() || it.getUnknown())
				res.push([from, undefined, it.getUnknown(), it.getComment()]);

			while (it.advance(to)) {
				if (it.getState() || it.getUnknown()) {
					if (res.length != 0 && typeof res[res.length - 1][1] == 'undefined') {
						// last state was also open or unknown
						res[res.length - 1][1] = it.getDate();
					}
					res.push([it.getDate(), undefined, it.getUnknown(), it.getComment()]);
				} else {
					if (res.length != 0 && typeof res[res.length - 1][1] == 'undefined') {
						// only use the first time as closing/change time and ignore closing times which might follow
						res[res.length - 1][1] = it.getDate();
					}
				}
			}

			if (res.length > 0 && typeof res[res.length - 1][1] === 'undefined')
				res[res.length - 1][1] = to;

			return res;
		}

		// return total number of milliseconds a facility is open within a given date range
		this.getOpenDuration = function(from, to) {
		// console.log('-----------');

			var open    = 0;
			var unknown = 0;

			var it = this.getIterator(from);
			var prevdate    = (it.getState() || it.getUnknown()) ? from : undefined;
			var prevstate   = it.getState();
			var prevunknown = it.getUnknown();

			while (it.advance(to)) {
				if (it.getState() || it.getUnknown()) {

					if (typeof prevdate !== 'undefined') {
						// last state was also open or unknown
						if (prevunknown) //
							unknown += it.getDate().getTime() - prevdate.getTime();
						else if (prevstate)
							open    += it.getDate().getTime() - prevdate.getTime();
					}

					prevdate    = it.getDate();
					prevstate   = it.getState();
					prevunknown = it.getUnknown();
					// console.log('if', prevdate, open / (1000 * 60 * 60), unknown / (1000 * 60 * 60));
				} else {
					// console.log('else', prevdate);
					if (typeof prevdate !== 'undefined') {
						if (prevunknown)
							unknown += it.getDate().getTime() - prevdate.getTime();
						else
							open    += it.getDate().getTime() - prevdate.getTime();
						prevdate = undefined;
					}
				}
			}

			if (typeof prevdate !== 'undefined') {
				if (prevunknown)
					unknown += to.getTime() - prevdate.getTime();
				else
					open    += to.getTime() - prevdate.getTime();
			}

			return [ open, unknown ];
		}

		this.isWeekStable = function() {
			return week_stable;
		}
	}
}));
