/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsDialog
extends ToggleDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 6183400754671501117L;
    private JLabel statusLabel;
    private JLabel wayLabel;
    private JLabel latLabel;
    private JLabel longLabel;
    private JLabel courseLabel;
    private JLabel speedLabel;
    private JPanel panel = new JPanel();

    public LiveGpsDialog(MapFrame mapFrame) {
        super(I18n.tr((String)"Live GPS"), "livegps", I18n.tr((String)"Show GPS data."), 71, 100);
        this.panel.setLayout(new GridLayout(6, 2));
        this.panel.add(new JLabel(I18n.tr((String)"Status")));
        this.statusLabel = new JLabel();
        this.panel.add(this.statusLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Way Info")));
        this.wayLabel = new JLabel();
        this.panel.add(this.wayLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Latitude")));
        this.latLabel = new JLabel();
        this.panel.add(this.latLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Longitude")));
        this.longLabel = new JLabel();
        this.panel.add(this.longLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Speed")));
        this.speedLabel = new JLabel();
        this.panel.add(this.speedLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Course")));
        this.courseLabel = new JLabel();
        this.panel.add(this.courseLabel);
        this.add(new JScrollPane(this.panel), "Center");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            LiveGpsData data = (LiveGpsData)evt.getNewValue();
            if (data.isFix()) {
                this.panel.setBackground(Color.WHITE);
                this.latLabel.setText(data.getLatitude() + "deg");
                this.longLabel.setText(data.getLongitude() + "deg");
                this.speedLabel.setText(data.getSpeed() * 3.6f + "km/h");
                this.courseLabel.setText(data.getCourse() + "deg");
                String wayString = data.getWayInfo();
                if (wayString.length() > 0) {
                    this.wayLabel.setText(wayString);
                } else {
                    this.wayLabel.setText("unknown");
                }
            } else {
                this.latLabel.setText("");
                this.longLabel.setText("");
                this.speedLabel.setText("");
                this.courseLabel.setText("");
                this.panel.setBackground(Color.RED);
            }
        } else if ("gpsstatus".equals(evt.getPropertyName())) {
            LiveGpsStatus status = (LiveGpsStatus)evt.getNewValue();
            this.statusLabel.setText(status.getStatusMessage());
            if (status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                this.panel.setBackground(Color.RED);
            } else {
                this.panel.setBackground(Color.WHITE);
            }
        }
    }
}

