/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String getPluginDir() {
        return Main.pref.getPreferencesDir() + "plugins/validator/";
    }

    public static JButton createButton(String name, String icon, String tooltip, ActionListener action) {
        JButton button = new JButton(I18n.tr((String)name), ImageProvider.get((String)icon));
        button.setActionCommand(name);
        button.addActionListener(action);
        button.setToolTipText(I18n.tr((String)tooltip));
        button.putClientProperty("help", "Dialog/SelectionList/" + name);
        return button;
    }

    public static Version getVersion() {
        PluginInformation info = PluginInformation.getLoaded((String)"validator");
        if (info == null) {
            return null;
        }
        return new Version(info.version, (String)info.attr.get("Plugin-Date"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(URL resource) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(resource.openStream()));
            StringBuilder sb = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = in.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File mirror(URL url, String destDir, long maxTime) {
        File destDirFile;
        if (url.getProtocol().equals("file")) {
            return new File(url.toString());
        }
        String localPath = Main.pref.get("validator.mirror." + url);
        File oldFile = null;
        if (localPath != null && localPath.length() > 0) {
            StringTokenizer st = new StringTokenizer(localPath, ";");
            long checkDate = Long.parseLong(st.nextToken());
            localPath = st.nextToken();
            oldFile = new File(localPath);
            long l = maxTime = maxTime <= 0L ? 604800000L : maxTime * 1000L;
            if (System.currentTimeMillis() - checkDate < maxTime && oldFile.exists()) {
                return oldFile;
            }
        }
        if (!(destDirFile = new File(destDir)).exists()) {
            destDirFile.mkdirs();
        }
        localPath = destDir + System.currentTimeMillis() + "-" + new File(url.getPath()).getName();
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int length;
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            bis = new BufferedInputStream(conn.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(localPath));
            byte[] buffer = new byte[4096];
            while ((length = bis.read(buffer)) > -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, length);
            }
        }
        catch (IOException ioe) {
            if (oldFile != null) {
                File file = oldFile;
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Main.pref.put("validator.mirror." + url, System.currentTimeMillis() + ";" + localPath);
        if (oldFile != null) {
            oldFile.delete();
        }
        return new File(localPath);
    }

    public static List<List<Way>> getWaysInCell(Way w, Map<Point2D, List<Way>> cellWays) {
        if (w.nodes.size() == 0) {
            return Collections.emptyList();
        }
        Node n1 = (Node)w.nodes.get(0);
        Node n2 = (Node)w.nodes.get(w.nodes.size() - 1);
        ArrayList<List<Way>> cells = new ArrayList<List<Way>>(2);
        HashSet<Point2D.Double> cellNodes = new HashSet<Point2D.Double>();
        long x0 = Math.round(n1.eastNorth.east() * 10000.0);
        long y0 = Math.round(n1.eastNorth.north() * 10000.0);
        long x1 = Math.round(n2.eastNorth.east() * 10000.0);
        long y1 = Math.round(n2.eastNorth.north() * 10000.0);
        Point2D.Double cell = new Point2D.Double(x0, y0);
        cellNodes.add(cell);
        List<Way> ways = cellWays.get(cell);
        if (ways == null) {
            ways = new ArrayList<Way>();
            cellWays.put(cell, ways);
        }
        cells.add(ways);
        cell = new Point2D.Double(x1, y1);
        if (!cellNodes.contains(cell)) {
            cellNodes.add(cell);
            ways = cellWays.get(cell);
            if (ways == null) {
                ways = new ArrayList<Way>();
                cellWays.put(cell, ways);
            }
            cells.add(ways);
        }
        x0 = (long)Math.floor(n1.eastNorth.east() * 10000.0);
        y0 = (long)Math.floor(n1.eastNorth.north() * 10000.0);
        x1 = (long)Math.floor(n2.eastNorth.east() * 10000.0);
        y1 = (long)Math.floor(n2.eastNorth.north() * 10000.0);
        cell = new Point2D.Double(x0, y0);
        if (!cellNodes.contains(cell)) {
            cellNodes.add(cell);
            ways = cellWays.get(cell);
            if (ways == null) {
                ways = new ArrayList<Way>();
                cellWays.put(cell, ways);
            }
            cells.add(ways);
        }
        if (!cellNodes.contains(cell = new Point2D.Double(x1, y1))) {
            cellNodes.add(cell);
            ways = cellWays.get(cell);
            if (ways == null) {
                ways = new ArrayList<Way>();
                cellWays.put(cell, ways);
            }
            cells.add(ways);
        }
        return cells;
    }

    public static List<Point2D> getSegmentCells(Node n1, Node n2, int gridDetail) {
        ArrayList<Point2D> cells = new ArrayList<Point2D>();
        double x0 = n1.eastNorth.east() * (double)gridDetail;
        double x1 = n2.eastNorth.east() * (double)gridDetail;
        double y0 = n1.eastNorth.north() * (double)gridDetail + 1.0;
        double y1 = n2.eastNorth.north() * (double)gridDetail + 1.0;
        if (x0 > x1) {
            double aux = x0;
            x0 = x1;
            x1 = aux;
            aux = y0;
            y0 = y1;
            y1 = aux;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        long stepY = y0 <= y1 ? 1L : -1L;
        long gridX0 = (long)Math.floor(x0);
        long gridX1 = (long)Math.floor(x1);
        long gridY0 = (long)Math.floor(y0);
        long gridY1 = (long)Math.floor(y1);
        long maxSteps = gridX1 - gridX0 + Math.abs(gridY1 - gridY0) + 1L;
        while (gridX0 <= gridX1 && (gridY0 - gridY1) * stepY <= 0L && maxSteps-- > 0L) {
            cells.add(new Point2D.Double(gridX0, gridY0));
            double scanY = dy / dx * ((double)(gridX0 + 1L) - x1) + y1 + (double)(dy < 0.0 ? -1 : 0);
            double scanX = dx / dy * ((double)(gridY0 + (long)(dy < 0.0 ? 0 : 1) * stepY) - y1) + x1;
            double distX = Math.pow((double)(gridX0 + 1L) - x0, 2.0) + Math.pow(scanY - y0, 2.0);
            double distY = Math.pow(scanX - x0, 2.0) + Math.pow((double)(gridY0 + stepY) - y0, 2.0);
            if (distX < distY) {
                ++gridX0;
                continue;
            }
            gridY0 += stepY;
        }
        return cells;
    }

    public static class Version {
        public String revision;
        public String time;

        public Version(String revision, String time) {
            this.revision = revision;
            this.time = time;
        }
    }
}

