/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 0;
    protected static final int UNTAGGED_WAY = 1;
    protected static final int UNNAMED_WAY = 2;
    protected static final int ONE_NODE_WAY = 3;
    public static final String[] ALLOWED_TAGS = new String[]{"created_by", "converted_by"};
    public static final Set<String> NAMED_WAYS = new HashSet<String>();

    public UntaggedWay() {
        super(I18n.tr((String)"Untagged, empty, and one node ways."), I18n.tr((String)"This test checks for untagged, empty and one node ways."));
    }

    public void visit(Way w) {
        if (w.deleted || w.incomplete) {
            return;
        }
        int numTags = 0;
        Map tags = w.keys;
        if (tags != null) {
            numTags = tags.size();
            for (String tag : ALLOWED_TAGS) {
                if (!tags.containsKey(tag)) continue;
                --numTags;
            }
            String highway = (String)tags.get("highway");
            if (numTags != 0 && highway != null && NAMED_WAYS.contains(highway) && !tags.containsKey("name") && !tags.containsKey("ref")) {
                String key;
                boolean hasName = false;
                Iterator i$ = w.keySet().iterator();
                while (i$.hasNext() && !(hasName = (key = (String)i$.next()).startsWith("name:") || key.endsWith("_name") || key.endsWith("_ref"))) {
                }
                if (!hasName) {
                    this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Unnamed ways"), (OsmPrimitive)w, 2));
                }
            }
        }
        if (numTags == 0) {
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Untagged ways"), (OsmPrimitive)w, 1));
        }
        if (w.nodes.size() == 0) {
            this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Empty ways"), (OsmPrimitive)w, 0));
        }
        if (w.nodes.size() == 1) {
            this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"One node ways"), (OsmPrimitive)w, 3));
        }
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getInternalCode() == 0 || testError.getInternalCode() == 3;
        }
        return false;
    }

    public Command fixError(TestError testError) {
        return new DeleteCommand(testError.getPrimitives());
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
    }
}

