/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyKeyCommand
extends Command {
    private final List<OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> objects, String key, String newKey) {
        this.objects = new LinkedList<OsmPrimitive>(objects);
        this.key = key;
        this.newKey = newKey;
    }

    public void executeCommand() {
        super.executeCommand();
        for (OsmPrimitive osm : this.objects) {
            if (osm.keys == null) continue;
            osm.modified = true;
            osm.put(this.newKey, (String)osm.keys.remove(this.key));
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    public MutableTreeNode description() {
        String text = I18n.tr((String)"Replace \"{0}\" by \"{1}\" for", (Object[])new Object[]{this.key, this.newKey});
        if (this.objects.size() == 1) {
            NameVisitor v = new NameVisitor();
            this.objects.iterator().next().visit((Visitor)v);
            text = text + " " + I18n.tr((String)v.className) + " " + v.name;
        } else {
            text = text + " " + this.objects.size() + " " + I18n.trn((String)"object", (String)"objects", (long)this.objects.size());
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new JLabel(text, ImageProvider.get((String)"data", (String)"key"), 0));
        if (this.objects.size() == 1) {
            return root;
        }
        NameVisitor v = new NameVisitor();
        for (OsmPrimitive osm : this.objects) {
            osm.visit((Visitor)v);
            root.add(new DefaultMutableTreeNode(v.toLabel()));
        }
        return root;
    }
}

