/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.validator.ErrorTreePanel;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorDialog
extends ToggleDialog
implements ActionListener {
    private static final long serialVersionUID = 2952292777351992696L;
    protected ErrorTreePanel tree = new ErrorTreePanel();
    private JButton fixButton;
    private JButton selectButton;
    private DefaultMutableTreeNode lastSelectedNode = null;

    public ValidatorDialog() {
        super(I18n.tr((String)"Validation errors"), "validator", I18n.tr((String)"Open the validation window."), 86, 150);
        this.tree.addMouseListener(new ClickWatch());
        this.tree.addTreeSelectionListener(new SelectionWatch());
        this.add(new JScrollPane(this.tree), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        this.selectButton = Util.createButton("Select", "mapmode/selection/select", "Set the selected elements on the map to the selected items in the list above.", this);
        this.selectButton.setEnabled(false);
        buttonPanel.add(this.selectButton);
        buttonPanel.add(Util.createButton("Validate", "dialogs/refresh", "Validate the data.", this));
        this.fixButton = Util.createButton("Fix", "dialogs/fix", "Fix the selected errors.", this);
        this.fixButton.setEnabled(false);
        buttonPanel.add(this.fixButton);
        this.add(buttonPanel, "South");
    }

    public void setVisible(boolean v) {
        if (this.tree != null) {
            this.tree.setVisible(v);
        }
        if (this.action != null && this.action.button != null) {
            this.action.button.setSelected(v);
        }
        super.setVisible(v);
        Main.map.repaint();
    }

    private void fixErrors(ActionEvent e) {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                TestError error;
                Command fixCommand;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                if (processedNodes.contains(childNode)) continue;
                processedNodes.add(childNode);
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError) || (fixCommand = (error = (TestError)nodeInfo).getFix()) == null) continue;
                Main.main.undoRedo.add(fixCommand);
            }
        }
        Main.map.repaint();
        DataSet.fireSelectionChanged((Collection)Main.ds.getSelected());
        OSMValidatorPlugin.getPlugin().validateAction.doValidate(e, false);
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>(40);
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null) {
            return;
        }
        for (TreePath path : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                TestError error = (TestError)nodeInfo;
                sel.addAll(error.getPrimitives());
            }
        }
        Main.ds.setSelected(sel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Select")) {
            this.setSelectedItems();
        } else if (actionCommand.equals("Validate")) {
            OSMValidatorPlugin.getPlugin().validateAction.actionPerformed(e);
        } else if (actionCommand.equals("Fix")) {
            this.fixErrors(e);
        }
    }

    private boolean setSelection(Collection<OsmPrimitive> sel, boolean addSelected) {
        TestError error;
        Object nodeInfo;
        DefaultMutableTreeNode childNode;
        Enumeration<TreeNode> children;
        boolean hasFixes = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(node)) {
            children = this.lastSelectedNode.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                childNode = (DefaultMutableTreeNode)children.nextElement();
                nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                error = (TestError)nodeInfo;
                error.setSelected(false);
            }
        }
        this.lastSelectedNode = node;
        if (node == null) {
            return hasFixes;
        }
        children = node.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            childNode = (DefaultMutableTreeNode)children.nextElement();
            nodeInfo = childNode.getUserObject();
            if (!(nodeInfo instanceof TestError)) continue;
            error = (TestError)nodeInfo;
            error.setSelected(true);
            boolean bl = hasFixes = hasFixes || error.isFixable();
            if (!addSelected) continue;
            sel.addAll(error.getPrimitives());
        }
        this.selectButton.setEnabled(true);
        return hasFixes;
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            ValidatorDialog.this.selectButton.setEnabled(false);
            if (e.getSource() instanceof JScrollPane) {
                System.out.println(e.getSource());
                return;
            }
            boolean hasFixes = ValidatorDialog.this.setSelection(null, false);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            Main.map.repaint();
        }
    }

    public class ClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean isDblClick = e.getClickCount() > 1;
            HashSet sel = isDblClick ? new HashSet(40) : null;
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, isDblClick);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            if (isDblClick) {
                Main.ds.setSelected(sel);
            }
        }
    }
}

