/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.comparator.impl;

import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.ObjectDifference;
import org.unitils.reflectionassert.util.HibernateUtil;

public class HibernateProxyComparator
implements Comparator {
    public boolean canCompare(Object left, Object right) {
        return HibernateUtil.isHibernateProxy(left) || HibernateUtil.isHibernateProxy(right);
    }

    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        if (HibernateUtil.isUninitialized(left) && HibernateUtil.isUninitialized(right)) {
            Object rightIdentifier;
            String leftType = HibernateUtil.getEntitiyName(left);
            String rightType = HibernateUtil.getEntitiyName(right);
            if (leftType == null || !leftType.equals(rightType)) {
                return new ObjectDifference("Different hibernate proxy types. Left: " + leftType + ", right: " + rightType, left, right);
            }
            Object leftIndentifier = HibernateUtil.getIdentifier(left);
            Difference identifierDifference = reflectionComparator.getDifference(leftIndentifier, rightIdentifier = HibernateUtil.getIdentifier(right), onlyFirstDifference);
            if (identifierDifference != null) {
                ObjectDifference difference = new ObjectDifference("Different hibernate proxy values", left, right);
                difference.addFieldDifference("<proxy id>", identifierDifference);
                return difference;
            }
            return null;
        }
        Object leftUnproxied = HibernateUtil.getUnproxiedValue(left);
        Object rightUnproxied = HibernateUtil.getUnproxiedValue(right);
        return reflectionComparator.getDifference(leftUnproxied, rightUnproxied, onlyFirstDifference);
    }
}

